/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.grid;

import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.Grid;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.SRS;
import org.springframework.util.Assert;

public class GridSetFactory {
    private static Logger log = Logging.getLogger((String)GridSetFactory.class.getName());
    public static final double DEFAULT_PIXEL_SIZE_METER = 2.8E-4;
    public static int DEFAULT_LEVELS = 22;
    public static final double EPSG4326_TO_METERS = 111319.49079327358;
    public static final double EPSG3857_TO_METERS = 1.0;

    private static GridSet baseGridSet(String name, SRS srs, int tileWidth, int tileHeight) {
        GridSet gridSet = new GridSet();
        gridSet.setName(name);
        gridSet.setSrs(srs);
        gridSet.setTileWidth(tileWidth);
        gridSet.setTileHeight(tileHeight);
        return gridSet;
    }

    public static GridSet createGridSet(String name, SRS srs, BoundingBox extent, boolean alignTopLeft, double[] resolutions, double[] scaleDenoms, Double metersPerUnit, double pixelSize, String[] scaleNames, int tileWidth, int tileHeight, boolean yCoordinateFirst) {
        int i;
        Assert.notNull((Object)name, (String)"name is null");
        Assert.notNull((Object)srs, (String)"srs is null");
        Assert.notNull((Object)extent, (String)"extent is null");
        Assert.isTrue((!extent.isNull() && extent.isSane() ? 1 : 0) != 0, (String)("Extent is invalid: " + String.valueOf(extent)));
        Assert.isTrue((resolutions != null || scaleDenoms != null ? 1 : 0) != 0, (String)"The gridset definition must have either resolutions or scale denominators");
        Assert.isTrue((resolutions == null || scaleDenoms == null ? 1 : 0) != 0, (String)"Only one of resolutions or scaleDenoms should be provided, not both");
        for (i = 1; resolutions != null && i < resolutions.length; ++i) {
            if (!(resolutions[i] >= resolutions[i - 1])) continue;
            throw new IllegalArgumentException("Each resolution should be lower than it's prior one. Res[" + i + "] == " + resolutions[i] + ", Res[" + (i - 1) + "] == " + resolutions[i - 1] + ".");
        }
        for (i = 1; scaleDenoms != null && i < scaleDenoms.length; ++i) {
            if (!(scaleDenoms[i] >= scaleDenoms[i - 1])) continue;
            throw new IllegalArgumentException("Each scale denominator should be lower than it's prior one. Scale[" + i + "] == " + scaleDenoms[i] + ", Scale[" + (i - 1) + "] == " + scaleDenoms[i - 1] + ".");
        }
        GridSet gridSet = GridSetFactory.baseGridSet(name, srs, tileWidth, tileHeight);
        gridSet.setResolutionsPreserved(resolutions != null);
        gridSet.setPixelSize(pixelSize);
        gridSet.setOriginalExtent(extent);
        gridSet.yBaseToggle = alignTopLeft;
        gridSet.setyCoordinateFirst(yCoordinateFirst);
        if (metersPerUnit == null) {
            if (srs.equals(SRS.getEPSG4326())) {
                gridSet.setMetersPerUnit(111319.49079327358);
            } else if (srs.equals(SRS.getEPSG3857())) {
                gridSet.setMetersPerUnit(1.0);
            } else {
                if (resolutions == null) {
                    log.config("GridSet " + name + " was defined without metersPerUnit, assuming 1m/unit. All scales will be off if this is incorrect.");
                } else {
                    log.config("GridSet " + name + " was defined without metersPerUnit. Assuming 1m per SRS unit for WMTS scale output.");
                    gridSet.setScaleWarning(true);
                }
                gridSet.setMetersPerUnit(1.0);
            }
        } else {
            gridSet.setMetersPerUnit(metersPerUnit);
        }
        if (resolutions == null) {
            gridSet.setGridLevels(new Grid[scaleDenoms.length]);
        } else {
            gridSet.setGridLevels(new Grid[resolutions.length]);
        }
        for (int i2 = 0; i2 < gridSet.getNumLevels(); ++i2) {
            Grid curGrid = new Grid();
            if (scaleDenoms != null) {
                curGrid.setScaleDenominator(scaleDenoms[i2]);
                curGrid.setResolution(pixelSize * (scaleDenoms[i2] / gridSet.getMetersPerUnit()));
            } else {
                curGrid.setResolution(resolutions[i2]);
                curGrid.setScaleDenominator(resolutions[i2] * gridSet.getMetersPerUnit() / 2.8E-4);
            }
            double mapUnitWidth = (double)tileWidth * curGrid.getResolution();
            double mapUnitHeight = (double)tileHeight * curGrid.getResolution();
            long tilesWide = (long)Math.ceil((extent.getWidth() - mapUnitWidth * 0.01) / mapUnitWidth);
            long tilesHigh = (long)Math.ceil((extent.getHeight() - mapUnitHeight * 0.01) / mapUnitHeight);
            curGrid.setNumTilesWide(tilesWide);
            curGrid.setNumTilesHigh(tilesHigh);
            if (scaleNames == null || scaleNames[i2] == null) {
                curGrid.setName(gridSet.getName() + ":" + i2);
            } else {
                curGrid.setName(scaleNames[i2]);
            }
            gridSet.setGrid(i2, curGrid);
        }
        return gridSet;
    }

    public static GridSet createGridSet(String name, SRS srs, BoundingBox extent, boolean alignTopLeft, int levels, Double metersPerUnit, double pixelSize, int tileWidth, int tileHeight, boolean yCoordinateFirst) {
        int tilesHigh;
        int tilesWide;
        double extentHeight;
        double resY;
        double extentWidth = extent.getWidth();
        double resX = extentWidth / (double)tileWidth;
        if (resX <= (resY = (extentHeight = extent.getHeight()) / (double)tileHeight)) {
            tilesWide = 1;
            tilesHigh = (int)Math.round(resY / resX);
            resY /= (double)tilesHigh;
        } else {
            tilesHigh = 1;
            tilesWide = (int)Math.round(resX / resY);
            resX /= (double)tilesWide;
        }
        double res = Math.max(resX, resY);
        double adjustedExtentWidth = (double)(tilesWide * tileWidth) * res;
        double adjustedExtentHeight = (double)(tilesHigh * tileHeight) * res;
        BoundingBox adjExtent = new BoundingBox(extent);
        adjExtent.setMaxX(adjExtent.getMinX() + adjustedExtentWidth);
        if (alignTopLeft) {
            adjExtent.setMinY(adjExtent.getMaxY() - adjustedExtentHeight);
        } else {
            adjExtent.setMaxY(adjExtent.getMinY() + adjustedExtentHeight);
        }
        double[] resolutions = new double[levels];
        resolutions[0] = res;
        for (int i = 1; i < levels; ++i) {
            resolutions[i] = resolutions[i - 1] / 2.0;
        }
        return GridSetFactory.createGridSet(name, srs, adjExtent, alignTopLeft, resolutions, null, metersPerUnit, pixelSize, null, tileWidth, tileHeight, yCoordinateFirst);
    }
}

