/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.locks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.codec.digest.DigestUtils;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.locks.LockProvider;
import org.geowebcache.locks.MemoryLockProvider;
import org.geowebcache.storage.DefaultStorageFinder;
import org.geowebcache.util.IOUtils;

public class NIOLockProvider
implements LockProvider {
    public static Logger LOGGER = Logging.getLogger((String)NIOLockProvider.class.getName());
    private final String root;
    private final int waitBeforeRetry;
    private final int maxLockAttempts;
    MemoryLockProvider memoryProvider = new MemoryLockProvider();

    public NIOLockProvider(DefaultStorageFinder storageFinder) throws ConfigurationException {
        this(storageFinder.getDefaultPath());
    }

    public NIOLockProvider(DefaultStorageFinder storageFinder, int waitBeforeRetry, int maxLockAttempts) throws ConfigurationException {
        this.root = storageFinder.getDefaultPath();
        this.waitBeforeRetry = waitBeforeRetry;
        this.maxLockAttempts = maxLockAttempts;
    }

    public NIOLockProvider(String root) throws ConfigurationException {
        this.root = root;
        this.waitBeforeRetry = 20;
        this.maxLockAttempts = 120000 / this.waitBeforeRetry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LockProvider.Lock getLock(final String lockKey) throws GeoWebCacheException {
        LockProvider.Lock lock;
        File file = null;
        final LockProvider.Lock memoryLock = this.memoryProvider.getLock(lockKey);
        file = this.getFile(lockKey);
        FileOutputStream currFos = null;
        FileLock currLock = null;
        try {
            int count;
            for (count = 0; currLock == null && count < this.maxLockAttempts; ++count) {
                try {
                    currFos = new FileOutputStream(file);
                    currLock = currFos.getChannel().lock();
                    continue;
                }
                catch (IOException | OverlappingFileLockException e) {
                    IOUtils.closeQuietly(currFos);
                    try {
                        Thread.sleep(this.waitBeforeRetry);
                        continue;
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            if (count >= this.maxLockAttempts) {
                throw new GeoWebCacheException("Failed to get a lock on key " + lockKey + " after " + count + " attempts");
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Lock " + lockKey + " acquired by thread " + Thread.currentThread().getId() + " on file " + String.valueOf(file));
            }
            final FileOutputStream fos = currFos;
            final FileLock lock2 = currLock;
            currFos = null;
            currLock = null;
            final File lockFile = file;
            lock = new LockProvider.Lock(){
                boolean released;

                @Override
                public void release() throws GeoWebCacheException {
                    if (this.released) {
                        return;
                    }
                    try {
                        this.released = true;
                        if (!lock2.isValid() && LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Lock key " + lockKey + " for releasing lock is unkonwn, it means this lock was never acquired, or was released twice. Current thread is: " + Thread.currentThread().getId() + ". Are you running two GWC instances in the same JVM using NIO locks? This case is not supported and will generate exactly this error message");
                            return;
                        }
                        try {
                            lock2.release();
                            IOUtils.closeQuietly(fos);
                            lockFile.delete();
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.fine("Lock " + lockKey + " on file " + String.valueOf(lockFile) + " released by thread " + Thread.currentThread().getId());
                            }
                        }
                        catch (IOException e) {
                            throw new GeoWebCacheException("Failure while trying to release lock for key " + lockKey, e);
                        }
                    }
                    finally {
                        memoryLock.release();
                    }
                }
            };
        }
        catch (Throwable throwable) {
            try {
                try {
                    if (currLock != null) {
                        currLock.release();
                    }
                    IOUtils.closeQuietly(currFos);
                    file.delete();
                }
                finally {
                    memoryLock.release();
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new GeoWebCacheException("Failure while trying to get lock for key " + lockKey, e);
            }
        }
        try {
            if (currLock != null) {
                currLock.release();
            }
            IOUtils.closeQuietly(currFos);
            file.delete();
        }
        finally {
            memoryLock.release();
        }
        return lock;
    }

    private File getFile(String lockKey) {
        File locks = new File(this.root, "lockfiles");
        locks.mkdirs();
        String sha1 = DigestUtils.sha1Hex((String)lockKey);
        return new File(locks, sha1 + ".lck");
    }
}

