/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.mime;

import it.geosolutions.jaiext.JAIExt;
import it.geosolutions.jaiext.colorindexer.ColorIndexer;
import it.geosolutions.jaiext.colorindexer.Quantizer;
import java.awt.RenderingHints;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.ExtremaDescriptor;
import org.geotools.util.logging.Logging;
import org.geowebcache.io.Resource;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;

public class ImageMime
extends MimeType {
    public static final String NATIVE_PNG_WRITER_CLASS_NAME = "com.sun.media.imageioimpl.plugins.png.CLibPNGImageWriter";
    private static Logger log = Logging.getLogger((String)ImageMime.class.getName());
    boolean supportsAlphaChannel;
    boolean supportsAlphaBit;
    public static final ImageMime png;
    public static final ImageMime jpeg;
    public static final ImageMime gif;
    public static final ImageMime tiff;
    public static final ImageMime png8;
    public static final ImageMime png24;
    public static final ImageMime png_24;
    public static final ImageMime dds;
    public static final ImageMime jpegPng;
    public static final ImageMime jpegPng8;

    private ImageMime(String mimeType, String fileExtension, String internalName, String format, boolean tiled, boolean alphaChannel, boolean alphaBit) {
        super(mimeType, fileExtension, internalName, format, tiled);
        this.supportsAlphaChannel = alphaChannel;
        this.supportsAlphaBit = alphaBit;
    }

    protected static ImageMime checkForFormat(String formatStr) throws MimeException {
        String tmpStr;
        if (!formatStr.startsWith("image/")) {
            return null;
        }
        if (!formatStr.equals("image/png; mode=24bit") && formatStr.contains(";")) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Slicing off " + formatStr.split(";")[1]);
            }
            formatStr = formatStr.split(";")[0];
        }
        if ((tmpStr = formatStr.substring(6)).equalsIgnoreCase("png")) {
            return png;
        }
        if (tmpStr.equalsIgnoreCase("jpeg")) {
            return jpeg;
        }
        if (tmpStr.equalsIgnoreCase("gif")) {
            return gif;
        }
        if (tmpStr.equalsIgnoreCase("tiff")) {
            return tiff;
        }
        if (tmpStr.equalsIgnoreCase("png8")) {
            return png8;
        }
        if (tmpStr.equalsIgnoreCase("png24")) {
            return png24;
        }
        if (tmpStr.equalsIgnoreCase("png; mode=24bit")) {
            return png_24;
        }
        if (tmpStr.equalsIgnoreCase("png;%20mode=24bit")) {
            return png_24;
        }
        if (tmpStr.equalsIgnoreCase("vnd.jpeg-png")) {
            return jpegPng;
        }
        if (tmpStr.equalsIgnoreCase("vnd.jpeg-png8")) {
            return jpegPng8;
        }
        return null;
    }

    protected static ImageMime checkForExtension(String fileExtension) throws MimeException {
        if (fileExtension.equalsIgnoreCase("png")) {
            return png;
        }
        if (fileExtension.equalsIgnoreCase("jpeg") || fileExtension.equalsIgnoreCase("jpg")) {
            return jpeg;
        }
        if (fileExtension.equalsIgnoreCase("gif")) {
            return gif;
        }
        if (fileExtension.equalsIgnoreCase("tiff")) {
            return tiff;
        }
        if (fileExtension.equalsIgnoreCase("png8")) {
            return png8;
        }
        if (fileExtension.equalsIgnoreCase("png24")) {
            return png24;
        }
        if (fileExtension.equalsIgnoreCase("png_24")) {
            return png_24;
        }
        if (fileExtension.equalsIgnoreCase("jpeg-png")) {
            return jpegPng;
        }
        if (fileExtension.equalsIgnoreCase("jpeg-png8")) {
            return jpegPng8;
        }
        return null;
    }

    public boolean supportsAlphaBit() {
        return this.supportsAlphaBit;
    }

    public boolean supportsAlphaChannel() {
        return this.supportsAlphaChannel;
    }

    @Override
    protected boolean isBinary() {
        return true;
    }

    public ImageWriter getImageWriter(RenderedImage image) {
        int bitDepth;
        Iterator<ImageWriter> it = ImageIO.getImageWritersByFormatName(this.internalName);
        ImageWriter writer = it.next();
        if ((this.internalName.equals(ImageMime.png.internalName) || this.internalName.equals(ImageMime.png8.internalName)) && (bitDepth = image.getSampleModel().getSampleSize(0)) > 1 && bitDepth < 8 && writer.getClass().getName().equals(NATIVE_PNG_WRITER_CLASS_NAME)) {
            writer = it.next();
        }
        return writer;
    }

    public RenderedImage preprocess(RenderedImage tile) {
        return tile;
    }

    static {
        JAIExt.initJAIEXT((boolean)false, (boolean)false);
        png = new ImageMime("image/png", "png", "png", "image/png", true, true, true){

            @Override
            public boolean isCompatible(String otherMimeType) {
                return super.isCompatible(otherMimeType) || otherMimeType.startsWith("image/png");
            }
        };
        jpeg = new ImageMime("image/jpeg", "jpeg", "jpeg", "image/jpeg", true, false, false){

            @Override
            public RenderedImage preprocess(RenderedImage ri) {
                if (ri.getColorModel().hasAlpha()) {
                    int numBands = ri.getSampleModel().getNumBands();
                    int[] bands = new int[numBands - 1];
                    for (int i = 0; i < bands.length; ++i) {
                        bands[i] = i;
                    }
                    ParameterBlock pb = new ParameterBlock();
                    pb.setSource(ri, 0);
                    pb.set(bands, 0);
                    RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, new ImageLayout(ri));
                    ri = JAI.create((String)"BandSelect", (ParameterBlock)pb, (RenderingHints)hints);
                }
                return ri;
            }
        };
        gif = new ImageMime("image/gif", "gif", "gif", "image/gif", true, false, true);
        tiff = new ImageMime("image/tiff", "tiff", "tiff", "image/tiff", true, true, true);
        png8 = new ImageMime("image/png", "png8", "png", "image/png8", true, false, true){

            @Override
            public RenderedImage preprocess(RenderedImage canvas) {
                ColorIndexer indexer;
                if (!(canvas.getColorModel() instanceof IndexColorModel) && canvas.getColorModel() instanceof ComponentColorModel && canvas.getSampleModel().getDataType() == 0 && (indexer = new Quantizer(256).subsample().buildColorIndexer(canvas)) != null) {
                    ParameterBlock pb = new ParameterBlock();
                    pb.setSource(canvas, 0);
                    pb.set(indexer, 0);
                    canvas = JAI.create((String)"ColorIndexer", (ParameterBlock)pb, (RenderingHints)JAI.getDefaultInstance().getRenderingHints());
                }
                return canvas;
            }
        };
        png24 = new ImageMime("image/png", "png24", "png", "image/png24", true, true, true);
        png_24 = new ImageMime("image/png; mode=24bit", "png_24", "png", "image/png;%20mode=24bit", true, true, true);
        dds = new ImageMime("image/dds", "dds", "dds", "image/dds", false, false, false);
        jpegPng = new JpegPngMime("image/vnd.jpeg-png", "jpeg-png", "jpeg-png", "image/vnd.jpeg-png", jpeg, png);
        jpegPng8 = new JpegPngMime("image/vnd.jpeg-png8", "jpeg-png8", "jpeg-png8", "image/vnd.jpeg-png8", jpeg, png8);
    }

    private static class JpegPngMime
    extends ImageMime {
        private static final int JPEG_MAGIC_MASK = -2621440;
        private final ImageMime jpegDelegate;
        private final ImageMime pngDelegate;

        public JpegPngMime(String mimeType, String fileExtension, String internalName, String format, ImageMime jpegDelegate, ImageMime pngDelegate) {
            super(mimeType, fileExtension, internalName, format, true, true, true);
            this.jpegDelegate = jpegDelegate;
            this.pngDelegate = pngDelegate;
        }

        boolean isBestFormatJpeg(RenderedImage renderedImage) {
            int numBands = renderedImage.getSampleModel().getNumBands();
            if (numBands == 4 || numBands == 2) {
                RenderedOp extremaOp = ExtremaDescriptor.create((RenderedImage)renderedImage, null, (Integer)1, (Integer)1, (Boolean)false, (Integer)1, (RenderingHints)JAI.getDefaultInstance().getRenderingHints());
                double[][] extrema = (double[][])extremaOp.getProperty("Extrema");
                double[] mins = extrema[0];
                return mins[mins.length - 1] == 255.0;
            }
            if (renderedImage.getColorModel() instanceof IndexColorModel) {
                return false;
            }
            return numBands == 3 || numBands == 1;
        }

        @Override
        public ImageWriter getImageWriter(RenderedImage image) {
            if (this.isBestFormatJpeg(image)) {
                return this.jpegDelegate.getImageWriter(image);
            }
            return this.pngDelegate.getImageWriter(image);
        }

        @Override
        public String getMimeType(Resource resource) throws IOException {
            try (DataInputStream dis = new DataInputStream(resource.getInputStream());){
                int head = dis.readInt();
                if ((head & 0xFFFF0000) == -2621440) {
                    String string = this.jpegDelegate.getMimeType();
                    return string;
                }
                String string = this.pngDelegate.getMimeType();
                return string;
            }
        }

        @Override
        public boolean isCompatible(String otherMimeType) {
            return this.jpegDelegate.isCompatible(otherMimeType) || this.pngDelegate.isCompatible(otherMimeType);
        }

        @Override
        public RenderedImage preprocess(RenderedImage tile) {
            if (this.isBestFormatJpeg(tile)) {
                return this.jpegDelegate.preprocess(tile);
            }
            return this.pngDelegate.preprocess(tile);
        }
    }
}

