/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.proxy;

import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geotools.util.logging.Logging;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class ProxyDispatcher
extends AbstractController {
    private static Logger log = Logging.getLogger((String)ProxyDispatcher.class.getName());
    private static long lastRequest = System.currentTimeMillis();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String decodedUrl;
        URL url;
        HttpURLConnection wmsBackendCon;
        String methStr = request.getMethod();
        if (!methStr.equalsIgnoreCase("POST")) {
            throw new ServletException("Illegal method " + methStr + " for this proxy.");
        }
        String urlStr = request.getParameter("url");
        if (urlStr == null || urlStr.length() == 0 || !urlStr.startsWith("http://")) {
            throw new ServletException("Expected url parameter.");
        }
        ProxyDispatcher proxyDispatcher = this;
        synchronized (proxyDispatcher) {
            long time = System.currentTimeMillis();
            if (time - lastRequest < 1000L) {
                throw new ServletException("Only one request per second please.");
            }
            lastRequest = time;
        }
        log.info("Proxying request for " + request.getRemoteAddr() + " to  " + urlStr);
        String charEnc = request.getCharacterEncoding();
        if (charEnc == null) {
            charEnc = "UTF-8";
        }
        if ((wmsBackendCon = (HttpURLConnection)(url = new URL(decodedUrl = URLDecoder.decode(urlStr, charEnc))).openConnection()).getContentEncoding() != null) {
            response.setCharacterEncoding(wmsBackendCon.getContentEncoding());
        }
        response.setContentType(wmsBackendCon.getContentType());
        int read = 0;
        byte[] data = new byte[1024];
        while (read > -1) {
            read = wmsBackendCon.getInputStream().read(data);
            if (read <= -1) continue;
            response.getOutputStream().write(data, 0, read);
        }
        return null;
    }
}

