/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage;

import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.util.ApplicationContextProvider;
import org.geowebcache.util.GWCVars;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public class DefaultStorageFinder {
    public static final String GWC_CACHE_DIR = "GEOWEBCACHE_CACHE_DIR";
    public static final String GS_DATA_DIR = "GEOSERVER_DATA_DIR";
    public static final String GWC_METASTORE_DISABLED = "GWC_METASTORE_DISABLED";
    public static final String GWC_METASTORE_JDBC_URL = "GWC_METASTORE_JDBC_URL";
    public static final String GWC_METASTORE_USERNAME = "GWC_METASTORE_USERNAME";
    public static final String GWC_METASTORE_PASSWORD = "GWC_METASTORE_PASSWORD";
    public static final String GWC_METASTORE_DRIVER_CLASS = "GWC_METASTORE_DRIVER_CLASS";
    public static final String GWC_BLANK_TILE_PATH = "GWC_BLANK_TILE_PATH";
    private static Logger log = Logging.getLogger((String)DefaultStorageFinder.class.getName());
    private String defaultPrefix = null;
    private WebApplicationContext context = null;

    public DefaultStorageFinder(ApplicationContextProvider provider) {
        this.context = provider.getApplicationContext();
    }

    public synchronized String getDefaultPath() throws ConfigurationException {
        if (this.defaultPrefix == null) {
            this.determineDefaultPrefix();
            if (this.defaultPrefix == null) {
                throw new ConfigurationException("Unable to find writable path for cache.");
            }
        }
        return this.defaultPrefix;
    }

    public String findEnvVar(String varStr) {
        return GWCVars.findEnvVar((ApplicationContext)this.context, varStr);
    }

    private void determineDefaultPrefix() {
        Object logMsg;
        String[] varStrs = new String[]{GWC_CACHE_DIR, GS_DATA_DIR, "TEMP", "TMP"};
        String msgPrefix = null;
        int iVar = 0;
        for (int i = 0; i < varStrs.length && this.defaultPrefix == null; ++i) {
            String varStr = varStrs[i];
            List<GWCVars.Variable> found = GWCVars.findVariable((ApplicationContext)this.context, varStr);
            for (GWCVars.Variable v : found) {
                String typeStr = v.getType().getSource();
                String value = v.getValue();
                if (value == null || value.isEmpty()) {
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.fine(typeStr + varStr + " is unset");
                    continue;
                }
                File fh = new File(value);
                msgPrefix = "Found " + typeStr + varStr + " set to " + value;
                if (!fh.exists()) {
                    log.log(Level.SEVERE, msgPrefix + " , but this path does not exist");
                    continue;
                }
                if (!fh.isDirectory()) {
                    log.log(Level.SEVERE, msgPrefix + " , which is not a directory");
                    continue;
                }
                if (!fh.canWrite()) {
                    log.log(Level.SEVERE, msgPrefix + " , which is not writeable");
                    continue;
                }
                this.defaultPrefix = value;
                iVar = i;
            }
        }
        if (this.defaultPrefix == null) {
            String tmpDir = System.getProperty("java.io.tmpdir");
            if (tmpDir != null) {
                File temp = new File(tmpDir, "geowebcache");
                logMsg = "Reverting to java.io.tmpdir '" + temp.getAbsolutePath() + "' for storage. Please set GEOWEBCACHE_CACHE_DIR.";
                if (!temp.exists() && !temp.mkdirs()) {
                    throw new RuntimeException("Can't create " + temp.getAbsolutePath());
                }
                this.defaultPrefix = temp.getAbsolutePath();
            } else {
                logMsg = "Unable to determine temp directory. Proceeding with undefined results.";
            }
        } else {
            switch (iVar) {
                case 0: {
                    break;
                }
                case 1: {
                    this.defaultPrefix = this.defaultPrefix + File.separator + "gwc";
                    break;
                }
                case 2: 
                case 3: {
                    this.defaultPrefix = this.defaultPrefix + File.separator + "geowebcache";
                }
            }
            logMsg = msgPrefix + ", using it as the default prefix.";
        }
        log.config((String)logMsg);
    }
}

