/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage.blobstore.file;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FilenameFilter;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileRange;
import org.geowebcache.storage.blobstore.file.FilePathUtils;
import org.geowebcache.storage.blobstore.file.XYZFilePathGenerator;

public class XYZFilePathFilter
implements FilenameFilter {
    private final String gridSetPrefix;
    private final XYZFilePathGenerator generator;
    private String mimeExtension;
    private TileRange tr;
    private String layerPrefix;

    public XYZFilePathFilter(TileRange trObj, XYZFilePathGenerator generator) throws StorageException {
        this.tr = trObj;
        this.generator = generator;
        if (this.tr.getGridSetId() == null) {
            throw new StorageException("Specifying the grid set id is currently mandatory.");
        }
        String layerName = this.tr.getLayerName();
        Preconditions.checkNotNull((Object)layerName);
        this.layerPrefix = FilePathUtils.filteredLayerName(layerName);
        this.gridSetPrefix = FilePathUtils.filteredGridSetId(this.tr.getGridSetId());
        if (this.tr.getMimeType() != null) {
            this.mimeExtension = this.tr.getMimeType().getFileExtension();
        }
    }

    @Override
    public boolean accept(File parent, String fileName) {
        if (fileName.equals(this.gridSetPrefix)) {
            return this.acceptGridsetDir(fileName);
        }
        if (fileName.contains(".")) {
            return this.acceptFileName(parent, fileName);
        }
        if (!parent.getName().equals(this.layerPrefix)) {
            return this.acceptIntermediateDir(parent, fileName);
        }
        return false;
    }

    private boolean acceptGridsetDir(String name) {
        if (!name.startsWith(this.gridSetPrefix)) {
            return false;
        }
        String parameter = this.findParameter(this.gridSetPrefix, name);
        if (this.tr.getParametersId() == null) {
            return parameter == null;
        }
        return this.tr.getParametersId().equals(parameter);
    }

    String findParameter(String gridsetPrefix, String dirName) {
        String prefix = gridsetPrefix + "_";
        if (!dirName.startsWith(prefix) || dirName.length() <= prefix.length()) {
            return null;
        }
        return dirName.substring(prefix.length() + 1);
    }

    private boolean acceptIntermediateDir(File parent, String fileName) {
        try {
            if (this.acceptGridsetDir(parent.getName())) {
                int z = Integer.parseInt(fileName);
                return this.tr.getZoomStart() <= z && this.tr.getZoomStop() >= z;
            }
            if (this.acceptGridsetDir(parent.getParentFile().getName())) {
                int z = Integer.parseInt(parent.getName());
                long x = Long.parseLong(fileName);
                long[] xBounds = this.tr.rangeBounds(z);
                return xBounds[0] <= x && xBounds[2] >= x;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }

    private boolean acceptFileName(File parent, String name) {
        String[] parts = name.split("\\.");
        try {
            if (parts.length != 2) {
                return false;
            }
            if (!parts[parts.length - 1].equalsIgnoreCase(this.mimeExtension)) {
                return false;
            }
            long y = Long.parseLong(parts[0]);
            long x = Long.parseLong(parent.getName());
            int z = Integer.parseInt(parent.getParentFile().getName());
            y = this.generator.getY(this.tr.getLayerName(), this.tr.getGridSetId(), x, y, z);
            return this.tr.contains(x, y, z);
        }
        catch (Exception e) {
            return false;
        }
    }
}

