/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota;

import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.geowebcache.MockWepAppContextRule;
import org.geowebcache.config.BaseConfiguration;
import org.geowebcache.config.ConfigurationResourceProvider;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.config.GridSetConfiguration;
import org.geowebcache.config.MockConfigurationResourceProvider;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.diskquota.MockSystemUtils;
import org.geowebcache.diskquota.bdb.BDBQuotaStore;
import org.geowebcache.diskquota.storage.PageStats;
import org.geowebcache.diskquota.storage.PageStatsPayload;
import org.geowebcache.diskquota.storage.Quota;
import org.geowebcache.diskquota.storage.StorageUnit;
import org.geowebcache.diskquota.storage.SystemUtils;
import org.geowebcache.diskquota.storage.TilePage;
import org.geowebcache.diskquota.storage.TilePageCalculator;
import org.geowebcache.diskquota.storage.TileSet;
import org.geowebcache.filter.parameters.ParametersUtils;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.storage.DefaultStorageFinder;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.util.FileMatchers;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.springframework.context.ApplicationContext;

public class BDBQuotaStoreTest {
    private BDBQuotaStore store;
    private TilePageCalculator tilePageCalculator;
    private TileSet testTileSet;
    TileLayerDispatcher layerDispatcher;
    DefaultStorageFinder cacheDirFinder;
    StorageBroker storageBroker;
    @Rule
    public TemporaryFolder targetDir = new TemporaryFolder();
    @Rule
    public ExpectedException exception = ExpectedException.none();
    @Rule
    public MockWepAppContextRule context = new MockWepAppContextRule();
    Map<String, Set<String>> parameterIdsMap;
    Map<String, Set<Map<String, String>>> parametersMap;

    @Before
    public void setUp() throws Exception {
        this.cacheDirFinder = (DefaultStorageFinder)EasyMock.createMock(DefaultStorageFinder.class);
        EasyMock.expect((Object)this.cacheDirFinder.getDefaultPath()).andReturn((Object)this.targetDir.getRoot().getAbsolutePath()).anyTimes();
        EasyMock.expect((Object)this.cacheDirFinder.findEnvVar((String)EasyMock.eq((Object)"GWC_DISKQUOTA_DISABLED"))).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.cacheDirFinder});
        Capture layerNameCap = EasyMock.newCapture();
        this.storageBroker = (StorageBroker)EasyMock.createMock(StorageBroker.class);
        EasyMock.expect((Object)this.storageBroker.getCachedParameterIds((String)EasyMock.capture((Capture)layerNameCap))).andStubAnswer(() -> this.parameterIdsMap.getOrDefault(layerNameCap.getValue(), Collections.singleton(null)));
        EasyMock.replay((Object[])new Object[]{this.storageBroker});
        this.parametersMap = new HashMap<String, Set<Map<String, String>>>();
        this.parametersMap.put("topp:states", Stream.of("STYLE=&SOMEPARAMETER=", "STYLE=population&SOMEPARAMETER=2.0").map(ParametersUtils::getMap).collect(Collectors.toSet()));
        this.parameterIdsMap = this.parametersMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Set)e.getValue()).stream().map(ParametersUtils::getKvp).collect(Collectors.toSet())));
        XMLConfiguration xmlConfig = this.loadXMLConfig();
        this.context.addBean("xmlConfig", (Object)xmlConfig, (Class[])XMLConfiguration.class.getInterfaces());
        LinkedList<XMLConfiguration> configList = new LinkedList<XMLConfiguration>();
        configList.add(xmlConfig);
        this.context.addBean("DefaultGridsets", (Object)new DefaultGridsets(true, true), new Class[]{DefaultGridsets.class, GridSetConfiguration.class, BaseConfiguration.class});
        GridSetBroker gridSetBroker = new GridSetBroker();
        gridSetBroker.setApplicationContext((ApplicationContext)this.context.getMockContext());
        this.layerDispatcher = new TileLayerDispatcher(gridSetBroker, null);
        this.layerDispatcher.setApplicationContext((ApplicationContext)this.context.getMockContext());
        this.tilePageCalculator = new TilePageCalculator(this.layerDispatcher, this.storageBroker);
        xmlConfig.setGridSetBroker(gridSetBroker);
        xmlConfig.afterPropertiesSet();
        this.layerDispatcher.afterPropertiesSet();
        gridSetBroker.afterPropertiesSet();
        this.store = new BDBQuotaStore(this.cacheDirFinder, this.tilePageCalculator);
        this.store.startUp();
        this.testTileSet = (TileSet)this.tilePageCalculator.getTileSetsFor("topp:states2").iterator().next();
    }

    private XMLConfiguration loadXMLConfig() {
        XMLConfiguration xmlConfig = null;
        try {
            xmlConfig = new XMLConfiguration(this.context.getContextProvider(), (ConfigurationResourceProvider)new MockConfigurationResourceProvider(() -> XMLConfiguration.class.getResourceAsStream("geowebcache_130.xml")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return xmlConfig;
    }

    @Test
    public void testInitialization() throws Exception {
        String[] paramIds = this.parameterIdsMap.get("topp:states").toArray(new String[2]);
        Assert.assertThat((Object)this.store, (Matcher)Matchers.hasProperty((String)"tileSets", (Matcher)Matchers.containsInAnyOrder((Object[])new TileSet[]{new TileSet("topp:states", "EPSG:900913", "image/png", paramIds[0]), new TileSet("topp:states", "EPSG:900913", "image/jpeg", paramIds[0]), new TileSet("topp:states", "EPSG:900913", "image/gif", paramIds[0]), new TileSet("topp:states", "EPSG:900913", "application/vnd.google-earth.kml+xml", paramIds[0]), new TileSet("topp:states", "EPSG:4326", "image/png", paramIds[0]), new TileSet("topp:states", "EPSG:4326", "image/jpeg", paramIds[0]), new TileSet("topp:states", "EPSG:4326", "image/gif", paramIds[0]), new TileSet("topp:states", "EPSG:4326", "application/vnd.google-earth.kml+xml", paramIds[0]), new TileSet("topp:states", "EPSG:900913", "image/png", paramIds[1]), new TileSet("topp:states", "EPSG:900913", "image/jpeg", paramIds[1]), new TileSet("topp:states", "EPSG:900913", "image/gif", paramIds[1]), new TileSet("topp:states", "EPSG:900913", "application/vnd.google-earth.kml+xml", paramIds[1]), new TileSet("topp:states", "EPSG:4326", "image/png", paramIds[1]), new TileSet("topp:states", "EPSG:4326", "image/jpeg", paramIds[1]), new TileSet("topp:states", "EPSG:4326", "image/gif", paramIds[1]), new TileSet("topp:states", "EPSG:4326", "application/vnd.google-earth.kml+xml", paramIds[1]), new TileSet("topp:states2", "EPSG:2163", "image/png", null), new TileSet("topp:states2", "EPSG:2163", "image/jpeg", null)})));
        this.layerDispatcher.removeLayer("topp:states");
        this.store.close();
        this.store.startUp();
        Assert.assertThat((Object)this.store, (Matcher)Matchers.hasProperty((String)"tileSets", (Matcher)Matchers.containsInAnyOrder((Object[])new TileSet[]{new TileSet("topp:states2", "EPSG:2163", "image/png", null), new TileSet("topp:states2", "EPSG:2163", "image/jpeg", null)})));
    }

    @Test
    public void testPageStatsGathering() throws Exception {
        MockSystemUtils sysUtils = new MockSystemUtils();
        sysUtils.setCurrentTimeMinutes(10);
        sysUtils.setCurrentTimeMillis(600000L);
        SystemUtils.set((SystemUtils)sysUtils);
        TileSet tileSet = this.testTileSet;
        TilePage page = new TilePage(tileSet.getId(), 0, 0, 0);
        PageStatsPayload payload = new PageStatsPayload(page);
        int numHits = 100;
        payload.setLastAccessTime(sysUtils.currentTimeMillis() - 60000L);
        payload.setNumHits(numHits);
        payload.setNumTiles(1);
        this.store.addToQuotaAndTileCounts(tileSet, new Quota(1.0, StorageUnit.MiB), Collections.singleton(payload));
        Future result = this.store.addHitsAndSetAccesTime(Collections.singleton(payload));
        List allStats = (List)result.get();
        PageStats stats = (PageStats)allStats.get(0);
        Assert.assertThat((Object)stats, (Matcher)Matchers.hasProperty((String)"fillFactor", BDBQuotaStoreTest.closeTo(1.0f, 1.0E-6f)));
        Assert.assertThat((Object)stats, (Matcher)Matchers.hasProperty((String)"lastAccessTimeMinutes", (Matcher)Matchers.equalTo((Object)sysUtils.currentTimeMinutes())));
        Assert.assertThat((Object)stats, (Matcher)Matchers.hasProperty((String)"frequencyOfUsePerMinute", BDBQuotaStoreTest.closeTo(100.0f, 1.0E-6f)));
        sysUtils.setCurrentTimeMinutes(sysUtils.currentTimeMinutes() + 2);
        sysUtils.setCurrentTimeMillis(sysUtils.currentTimeMillis() + 120000L);
        numHits = 10;
        payload.setLastAccessTime(sysUtils.currentTimeMillis() - 60000L);
        payload.setNumHits(numHits);
        result = this.store.addHitsAndSetAccesTime(Collections.singleton(payload));
        allStats = (List)result.get();
        stats = (PageStats)allStats.get(0);
        Assert.assertThat((Object)stats, (Matcher)Matchers.hasProperty((String)"lastAccessTimeMinutes", (Matcher)Matchers.equalTo((Object)11)));
        Assert.assertThat((Object)stats, (Matcher)Matchers.hasProperty((String)"frequencyOfUsePerMinute", BDBQuotaStoreTest.closeTo(55.0f, 1.0E-6f)));
    }

    @Test
    public void testGetGloballyUsedQuota() throws InterruptedException {
        this.store.getGloballyUsedQuota().getBytes();
        Assert.assertThat((Object)this.store, (Matcher)Matchers.hasProperty((String)"globallyUsedQuota", BDBQuotaStoreTest.quotaEmpty()));
        String layerName = (String)this.tilePageCalculator.getLayerNames().iterator().next();
        TileSet tileSet = (TileSet)this.tilePageCalculator.getTileSetsFor(layerName).iterator().next();
        Quota quotaDiff = new Quota(BigInteger.valueOf(1000L));
        Set tileCountDiffs = Collections.emptySet();
        this.store.addToQuotaAndTileCounts(tileSet, quotaDiff, tileCountDiffs);
        Assert.assertThat((Object)this.store, (Matcher)Matchers.hasProperty((String)"globallyUsedQuota", BDBQuotaStoreTest.bytes(1000L)));
        quotaDiff = new Quota(BigInteger.valueOf(-500L));
        this.store.addToQuotaAndTileCounts(tileSet, quotaDiff, tileCountDiffs);
        Assert.assertThat((Object)this.store, (Matcher)Matchers.hasProperty((String)"globallyUsedQuota", BDBQuotaStoreTest.bytes(500L)));
    }

    @Test
    public void testDeleteGridset() throws InterruptedException {
        String layerName = "topp:states";
        String gridSetId = "EPSG:4326";
        long quotaToDelete = this.tilePageCalculator.getTileSetsFor(layerName).stream().filter(ts -> ts.getGridsetId().equals(gridSetId)).map(ts -> {
            Quota quotaDiff = new Quota(42.0, StorageUnit.MiB);
            try {
                this.store.addToQuotaAndTileCounts(ts, quotaDiff, Collections.emptySet());
                TilePage page = new TilePage(ts.getId(), 0, 0, 0);
                this.store.addHitsAndSetAccesTime(Collections.singleton(new PageStatsPayload(page)));
                return 42;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new AssertionError("Unexpected Exception", e);
            }
        }).collect(Collectors.summingLong(mb -> mb * 1024 * 1024));
        Assert.assertThat((Object)quotaToDelete, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        long quotaToKeep = this.tilePageCalculator.getTileSetsFor(layerName).stream().filter(ts -> !ts.getGridsetId().equals(gridSetId)).map(ts -> {
            Quota quotaDiff = new Quota(10.0, StorageUnit.MiB);
            try {
                this.store.addToQuotaAndTileCounts(ts, quotaDiff, Collections.emptySet());
                TilePage page = new TilePage(ts.getId(), 0, 0, 0);
                this.store.addHitsAndSetAccesTime(Collections.singleton(new PageStatsPayload(page)));
                return 10;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new AssertionError("Unexpected Exception", e);
            }
        }).collect(Collectors.summingLong(mb -> mb * 1024 * 1024));
        Assert.assertThat((Object)quotaToKeep, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        Assert.assertThat((Object)this.store.getUsedQuotaByLayerName(layerName), BDBQuotaStoreTest.bytes(quotaToDelete + quotaToKeep));
        this.store.deleteGridSubset(layerName, gridSetId);
        Assert.assertThat((Object)this.store.getUsedQuotaByLayerName(layerName), BDBQuotaStoreTest.bytes(quotaToKeep));
    }

    @Test
    public void testDeleteParameters() throws InterruptedException {
        String layerName = "topp:states";
        String parametersId = this.parameterIdsMap.get(layerName).iterator().next();
        long quotaToDelete = this.tilePageCalculator.getTileSetsFor(layerName).stream().filter(ts -> ts.getParametersId().equals(parametersId)).map(ts -> {
            Quota quotaDiff = new Quota(42.0, StorageUnit.MiB);
            try {
                this.store.addToQuotaAndTileCounts(ts, quotaDiff, Collections.emptySet());
                TilePage page = new TilePage(ts.getId(), 0, 0, 0);
                this.store.addHitsAndSetAccesTime(Collections.singleton(new PageStatsPayload(page)));
                return 42;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new AssertionError("Unexpected Exception", e);
            }
        }).collect(Collectors.summingLong(mb -> mb * 1024 * 1024));
        Assert.assertThat((Object)quotaToDelete, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        long quotaToKeep = this.tilePageCalculator.getTileSetsFor(layerName).stream().filter(ts -> !ts.getParametersId().equals(parametersId)).map(ts -> {
            Quota quotaDiff = new Quota(10.0, StorageUnit.MiB);
            try {
                this.store.addToQuotaAndTileCounts(ts, quotaDiff, Collections.emptySet());
                TilePage page = new TilePage(ts.getId(), 0, 0, 0);
                this.store.addHitsAndSetAccesTime(Collections.singleton(new PageStatsPayload(page)));
                return 10;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new AssertionError("Unexpected Exception", e);
            }
        }).collect(Collectors.summingLong(mb -> mb * 1024 * 1024));
        Assert.assertThat((Object)quotaToKeep, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        Assert.assertThat((Object)this.store.getUsedQuotaByLayerName(layerName), BDBQuotaStoreTest.bytes(quotaToDelete + quotaToKeep));
        this.store.deleteParameters(layerName, parametersId);
        Assert.assertThat((Object)this.store.getUsedQuotaByLayerName(layerName), BDBQuotaStoreTest.bytes(quotaToKeep));
    }

    @Test
    public void testRenameLayer() throws InterruptedException {
        String oldLayerName = (String)this.tilePageCalculator.getLayerNames().iterator().next();
        String newLayerName = "renamed_layer";
        BigInteger expectedBytes = BigInteger.valueOf(1024L);
        BigInteger emptyBytes = BigInteger.ZERO;
        Assert.assertThat((Object)this.store.getUsedQuotaByLayerName(oldLayerName), (Matcher)Matchers.notNullValue());
        TileSet tileSet = (TileSet)this.tilePageCalculator.getTileSetsFor(oldLayerName).iterator().next();
        TilePage page = new TilePage(tileSet.getId(), 0, 0, 0);
        this.store.addHitsAndSetAccesTime(Collections.singleton(new PageStatsPayload(page)));
        this.store.addToQuotaAndTileCounts(tileSet, new Quota(expectedBytes), Collections.emptyList());
        Assert.assertThat((Object)this.store.getUsedQuotaByLayerName(oldLayerName), BDBQuotaStoreTest.bytes(expectedBytes));
        Assert.assertThat((Object)this.store.getTileSetById(tileSet.getId()), (Matcher)Matchers.notNullValue());
        this.store.renameLayer(oldLayerName, "renamed_layer");
        Assert.assertThat((Object)this.store.getLeastRecentlyUsedPage(Collections.singleton(oldLayerName)), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)this.store.getUsedQuotaByLayerName(oldLayerName), BDBQuotaStoreTest.bytes(emptyBytes));
        Assert.assertThat((Object)this.store.getUsedQuotaByLayerName("renamed_layer"), BDBQuotaStoreTest.bytes(expectedBytes));
    }

    @Test
    public void testGetLeastFrequentlyUsedPage() throws Exception {
        String layerName = this.testTileSet.getLayerName();
        Set<String> layerNames = Collections.singleton(layerName);
        TilePage lfuPage = this.store.getLeastFrequentlyUsedPage(layerNames);
        Assert.assertThat((Object)lfuPage, (Matcher)Matchers.nullValue());
        TilePage page1 = new TilePage(this.testTileSet.getId(), 0, 1, 2);
        TilePage page2 = new TilePage(this.testTileSet.getId(), 1, 1, 2);
        PageStatsPayload payload1 = new PageStatsPayload(page1);
        PageStatsPayload payload2 = new PageStatsPayload(page2);
        payload1.setNumHits(100);
        payload2.setNumHits(10);
        List<PageStatsPayload> statsUpdates = Arrays.asList(payload1, payload2);
        this.store.addHitsAndSetAccesTime(statsUpdates).get();
        Assert.assertThat((Object)this.store.getLeastFrequentlyUsedPage(layerNames), (Matcher)Matchers.equalTo((Object)page2));
        payload2.setNumHits(1000);
        this.store.addHitsAndSetAccesTime(statsUpdates).get();
        Assert.assertThat((Object)this.store.getLeastFrequentlyUsedPage(layerNames), (Matcher)Matchers.equalTo((Object)page1));
    }

    @Test
    public void testGetLeastRecentlyUsedPage() throws Exception {
        MockSystemUtils mockSystemUtils = new MockSystemUtils();
        mockSystemUtils.setCurrentTimeMinutes(1000);
        mockSystemUtils.setCurrentTimeMillis(mockSystemUtils.currentTimeMinutes() * 60 * 1000);
        SystemUtils.set((SystemUtils)mockSystemUtils);
        String layerName = this.testTileSet.getLayerName();
        Set<String> layerNames = Collections.singleton(layerName);
        Assert.assertThat((Object)this.store.getLeastRecentlyUsedPage(layerNames), (Matcher)Matchers.nullValue());
        TilePage page1 = new TilePage(this.testTileSet.getId(), 0, 1, 2);
        TilePage page2 = new TilePage(this.testTileSet.getId(), 1, 1, 2);
        PageStatsPayload payload1 = new PageStatsPayload(page1);
        PageStatsPayload payload2 = new PageStatsPayload(page2);
        payload1.setLastAccessTime(mockSystemUtils.currentTimeMillis() + 60000L);
        payload2.setLastAccessTime(mockSystemUtils.currentTimeMillis() + 120000L);
        List<PageStatsPayload> statsUpdates = Arrays.asList(payload1, payload2);
        this.store.addHitsAndSetAccesTime(statsUpdates).get();
        Assert.assertThat((Object)this.store.getLeastRecentlyUsedPage(layerNames), (Matcher)Matchers.equalTo((Object)page1));
        payload1.setLastAccessTime(mockSystemUtils.currentTimeMillis() + 600000L);
        this.store.addHitsAndSetAccesTime(statsUpdates).get();
        Assert.assertThat((Object)this.store.getLeastRecentlyUsedPage(layerNames), (Matcher)Matchers.equalTo((Object)page2));
    }

    @Test
    public void testGetTileSetById() throws Exception {
        Assert.assertThat((Object)this.store.getTileSetById(this.testTileSet.getId()), (Matcher)Matchers.equalTo((Object)this.testTileSet));
        this.exception.expect(IllegalArgumentException.class);
        this.store.getTileSetById("NonExistentTileSetId");
    }

    @Test
    public void testGetTilesForPage() throws Exception {
        TilePage page = new TilePage(this.testTileSet.getId(), 0, 0, 0);
        long[][] expected = this.tilePageCalculator.toGridCoverage(this.testTileSet, page);
        long[][] tilesForPage = this.store.getTilesForPage(page);
        Assert.assertThat((Object)tilesForPage[0], (Matcher)Matchers.equalTo((Object)expected[0]));
        page = new TilePage(this.testTileSet.getId(), 0, 0, 1);
        expected = this.tilePageCalculator.toGridCoverage(this.testTileSet, page);
        tilesForPage = this.store.getTilesForPage(page);
        Assert.assertThat((Object)tilesForPage[1], (Matcher)Matchers.equalTo((Object)expected[1]));
    }

    @Test
    public void testGetUsedQuotaByLayerName() throws Exception {
        String layerName = "topp:states2";
        ArrayList tileSets = new ArrayList(this.tilePageCalculator.getTileSetsFor(layerName));
        Quota expected = new Quota();
        for (TileSet tset : tileSets) {
            Quota quotaDiff = new Quota(10.0, StorageUnit.MiB);
            expected.add(quotaDiff);
            this.store.addToQuotaAndTileCounts(tset, quotaDiff, (Collection)Collections.EMPTY_SET);
        }
        Assert.assertThat((Object)this.store.getUsedQuotaByLayerName(layerName), BDBQuotaStoreTest.bytes(expected.getBytes()));
    }

    @Test
    public void testGetUsedQuotaByTileSetId() throws Exception {
        String layerName = "topp:states2";
        ArrayList tileSets = new ArrayList(this.tilePageCalculator.getTileSetsFor(layerName));
        HashMap<String, Quota> expectedById = new HashMap<String, Quota>();
        for (TileSet tileSet : tileSets) {
            Quota quotaDiff = new Quota(10.0 * Math.random(), StorageUnit.MiB);
            this.store.addToQuotaAndTileCounts(tileSet, quotaDiff, (Collection)Collections.EMPTY_SET);
            this.store.addToQuotaAndTileCounts(tileSet, quotaDiff, (Collection)Collections.EMPTY_SET);
            Quota tsetQuota = new Quota(quotaDiff);
            tsetQuota.add(quotaDiff);
            expectedById.put(tileSet.getId(), tsetQuota);
        }
        for (Map.Entry entry : expectedById.entrySet()) {
            BigInteger expectedValue = ((Quota)entry.getValue()).getBytes();
            String tsetId = (String)entry.getKey();
            Assert.assertThat((Object)this.store.getUsedQuotaByTileSetId(tsetId), BDBQuotaStoreTest.bytes(expectedValue));
        }
    }

    @Test
    public void testSetTruncated() throws Exception {
        String tileSetId = this.testTileSet.getId();
        TilePage page = new TilePage(tileSetId, 0, 0, 2);
        PageStatsPayload payload = new PageStatsPayload(page);
        int numHits = 100;
        payload.setNumHits(numHits);
        payload.setNumTiles(5);
        this.store.addToQuotaAndTileCounts(this.testTileSet, new Quota(1.0, StorageUnit.MiB), Collections.singleton(payload));
        List stats = (List)this.store.addHitsAndSetAccesTime(Collections.singleton(payload)).get();
        Assert.assertThat((Object)stats, (Matcher)Matchers.contains((Matcher)Matchers.hasProperty((String)"fillFactor", (Matcher)Matchers.greaterThan((Comparable)Float.valueOf(0.0f)))));
        PageStats pageStats = this.store.setTruncated(page);
        Assert.assertThat((Object)pageStats, (Matcher)Matchers.hasProperty((String)"fillFactor", BDBQuotaStoreTest.closeTo(0.0f, 0.0f)));
    }

    @Test
    public void testCreatesVersion() throws Exception {
        File versionFile = new File(this.targetDir.getRoot(), "diskquota_page_store/version.txt");
        Assert.assertThat((Object)versionFile, (Matcher)FileMatchers.exists());
    }

    static Matcher<Float> closeTo(final float f, final float epsilon) {
        return new BaseMatcher<Float>(){
            Matcher<Double> doubleMatcher;
            {
                this.doubleMatcher = Matchers.closeTo((double)f, (double)epsilon);
            }

            public boolean matches(Object item) {
                if (item instanceof Float) {
                    item = (double)((Float)item).floatValue();
                }
                return this.doubleMatcher.matches(item);
            }

            public void describeTo(Description description) {
                this.doubleMatcher.describeTo(description);
            }
        };
    }

    static Matcher<Quota> bytes(BigInteger bytes) {
        return Matchers.hasProperty((String)"bytes", (Matcher)Matchers.equalTo((Object)bytes));
    }

    static Matcher<Quota> bytes(long bytes) {
        return Matchers.hasProperty((String)"bytes", (Matcher)Matchers.equalTo((Object)BigInteger.valueOf(bytes)));
    }

    static Matcher<Quota> quotaEmpty() {
        return BDBQuotaStoreTest.bytes(BigInteger.ZERO);
    }
}

