/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota.bdb;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.diskquota.QuotaStore;
import org.geowebcache.diskquota.QuotaStoreFactory;
import org.geowebcache.diskquota.bdb.BDBQuotaStore;
import org.geowebcache.diskquota.storage.TilePageCalculator;
import org.geowebcache.storage.DefaultStorageFinder;
import org.springframework.context.ApplicationContext;

public class BDBQuotaStoreFactory
implements QuotaStoreFactory {
    public static final String STORE_NAME = "BDB";

    public List<String> getSupportedStoreNames() {
        return Arrays.asList(STORE_NAME);
    }

    public QuotaStore getQuotaStore(ApplicationContext ctx, String quotaStoreName) throws IOException, ConfigurationException {
        if (!STORE_NAME.equals(quotaStoreName)) {
            return null;
        }
        DefaultStorageFinder cacheDirFinder = (DefaultStorageFinder)ctx.getBean("gwcDefaultStorageFinder");
        TilePageCalculator tilePageCalculator = (TilePageCalculator)ctx.getBean("gwcTilePageCalculator");
        try {
            BDBQuotaStore bdbQuotaStore = new BDBQuotaStore(cacheDirFinder, tilePageCalculator);
            bdbQuotaStore.startUp();
            return bdbQuotaStore;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Failed to startup the BDB store", e);
        }
    }
}

