/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota;

import java.util.concurrent.TimeUnit;
import org.geowebcache.diskquota.DiskQuotaConfig;
import org.geowebcache.diskquota.ExpirationPolicy;
import org.geowebcache.diskquota.storage.LayerQuota;
import org.geowebcache.diskquota.storage.Quota;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DiskQuotaConfigTest {
    private DiskQuotaConfig config;

    @Before
    public void setUp() throws Exception {
        this.config = new DiskQuotaConfig();
        this.config.setDefaults();
    }

    @Test
    public void testDiskQuotaConfig() {
        Assert.assertEquals((long)10L, (long)this.config.getCacheCleanUpFrequency().intValue());
        Assert.assertEquals((long)2L, (long)this.config.getMaxConcurrentCleanUps().intValue());
        Assert.assertEquals((Object)((Object)DiskQuotaConfig.DEFAULT_CLEANUP_UNITS), (Object)((Object)this.config.getCacheCleanUpUnits()));
    }

    @Test
    public void testSetCacheCleanUpFrequency() {
        try {
            this.config.setCacheCleanUpFrequency(-1);
            Assert.fail((String)"Expected IAE");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        this.config.setCacheCleanUpFrequency(10);
        Assert.assertEquals((long)10L, (long)this.config.getCacheCleanUpFrequency().intValue());
    }

    @Test
    public void testSetCacheCleanUpUnits() {
        try {
            this.config.setCacheCleanUpUnits(null);
            Assert.fail((String)"Expected IAE");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        this.config.setCacheCleanUpUnits(TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)((Object)TimeUnit.MILLISECONDS), (Object)((Object)this.config.getCacheCleanUpUnits()));
    }

    @Test
    public void testSetLayerQuotas() {
        Assert.assertNull((Object)this.config.getLayerQuotas());
        try {
            this.config.addLayerQuota(new LayerQuota("layer", ExpirationPolicy.LRU));
            Assert.fail((String)"Expected IAE");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        LayerQuota lq = new LayerQuota("layer", ExpirationPolicy.LFU, new Quota());
        this.config.addLayerQuota(lq);
        Assert.assertNotNull((Object)this.config.layerQuota("layer"));
    }

    @Test
    public void testRemove() {
        LayerQuota lq = new LayerQuota("layer", ExpirationPolicy.LFU, new Quota());
        this.config.addLayerQuota(lq);
        this.config.remove(lq);
        Assert.assertNull((Object)this.config.layerQuota("layer"));
    }

    @Test
    public void testSetMaxConcurrentCleanUps() {
        try {
            this.config.setMaxConcurrentCleanUps(-1);
            Assert.fail((String)"Expected IAE");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            this.config.setMaxConcurrentCleanUps(0);
            Assert.fail((String)"Expected IAE");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        this.config.setMaxConcurrentCleanUps(10);
        Assert.assertEquals((long)10L, (long)this.config.getMaxConcurrentCleanUps().intValue());
    }
}

