/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geowebcache.diskquota.QuotaStore;
import org.geowebcache.diskquota.UsageStats;
import org.geowebcache.diskquota.storage.PageStatsPayload;
import org.geowebcache.diskquota.storage.TilePage;
import org.geowebcache.diskquota.storage.TilePageCalculator;
import org.geowebcache.diskquota.storage.TileSet;
import org.springframework.util.Assert;

public class QueuedUsageStatsConsumer
implements Callable<Long> {
    private static final Logger log = Logging.getLogger((String)QueuedUsageStatsConsumer.class.getName());
    private static final long serialVersionUID = -625181087112272266L;
    private static final long DEFAULT_SYNC_TIMEOUT = 100L;
    private static final int MAX_AGGREGATES_BEFORE_COMMIT = 3000;
    private final QuotaStore quotaStore;
    private final BlockingQueue<UsageStats> usageStatsQueue;
    private final TilePageCalculator tilePageCalculator;
    private final TimedUsageUpdate aggregatedPendingUpdates;
    private final int[] pageIndexTarget = new int[3];
    private final StringBuilder pageIdTarget = new StringBuilder(128);
    private boolean terminate = false;

    public QueuedUsageStatsConsumer(QuotaStore quotaStore, BlockingQueue<UsageStats> queue, TilePageCalculator tilePageCalculator) {
        Assert.notNull((Object)quotaStore, (String)"quotaStore can't be null");
        Assert.notNull(queue, (String)"queue can't be null");
        Assert.notNull((Object)tilePageCalculator, (String)"tilePageCalculator can't be null");
        this.quotaStore = quotaStore;
        this.usageStatsQueue = queue;
        this.tilePageCalculator = tilePageCalculator;
        this.aggregatedPendingUpdates = new TimedUsageUpdate();
    }

    @Override
    public Long call() {
        while (true) {
            if (Thread.interrupted()) {
                log.fine("Job " + this.getClass().getSimpleName() + " finished due to interrupted thread.");
                break;
            }
            if (this.terminate) {
                log.fine("Exiting on explicit termination request: " + this.getClass().getSimpleName());
                break;
            }
            try {
                UsageStats requestedTile = this.usageStatsQueue.poll(100L, TimeUnit.MILLISECONDS);
                if (requestedTile == null) {
                    if (this.aggregatedPendingUpdates.pages.isEmpty()) continue;
                    this.commit();
                    continue;
                }
                this.performAggregatedUpdate(requestedTile);
                continue;
            }
            catch (InterruptedException e) {
                log.fine("Shutting down quota update background task due to interrupted exception");
                Thread.currentThread().interrupt();
            }
            catch (RuntimeException e) {
                log.log(Level.FINE, e.getMessage(), e);
                continue;
            }
            break;
        }
        return null;
    }

    private void performAggregatedUpdate(UsageStats requestedTile) throws InterruptedException {
        TileSet tileSet = requestedTile.getTileSet();
        String tileSetId = tileSet.getId();
        long[] tileIndex = requestedTile.getTileIndex();
        this.tilePageCalculator.pageIndexForTile(tileSet, tileIndex, this.pageIndexTarget);
        int pageX = this.pageIndexTarget[0];
        int pageY = this.pageIndexTarget[1];
        byte pageZ = (byte)this.pageIndexTarget[2];
        this.pageIdTarget.setLength(0);
        TilePage.computeId(tileSetId, pageX, pageY, pageZ, this.pageIdTarget);
        String pageKeyForTile = this.pageIdTarget.toString();
        PageStatsPayload timedUpdate = this.aggregatedPendingUpdates.pages.get(pageKeyForTile);
        if (timedUpdate == null) {
            timedUpdate = new PageStatsPayload(new TilePage(tileSetId, pageX, pageY, pageZ));
            timedUpdate.setTileSet(tileSet);
            this.aggregatedPendingUpdates.pages.put(pageKeyForTile, timedUpdate);
        } else {
            timedUpdate.setNumHits(timedUpdate.getNumHits() + 1);
        }
        timedUpdate.setNumHits(timedUpdate.getNumHits() + 1);
        timedUpdate.setLastAccessTime(System.currentTimeMillis());
        ++this.aggregatedPendingUpdates.numAggregations;
        this.checkAggregatedTimeout();
    }

    private void checkAggregatedTimeout() {
        boolean tooManyPendingCommits;
        long creationTime;
        long currTime = System.currentTimeMillis();
        boolean timeout = currTime - (creationTime = this.aggregatedPendingUpdates.lastCommitTime) >= 100L;
        int numAggregations = this.aggregatedPendingUpdates.numAggregations;
        boolean bl = tooManyPendingCommits = numAggregations >= 3000;
        if (timeout || tooManyPendingCommits) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Committing " + numAggregations + " aggregated usage stats to quota store due to " + (tooManyPendingCommits ? "too many pending commits" : "max wait time reached"));
            }
            this.commit();
        }
    }

    private void commit() {
        ArrayList<PageStatsPayload> pendingCommits = new ArrayList<PageStatsPayload>(this.aggregatedPendingUpdates.pages.values());
        this.quotaStore.addHitsAndSetAccesTime(pendingCommits);
        this.aggregatedPendingUpdates.lastCommitTime = System.currentTimeMillis();
        this.aggregatedPendingUpdates.numAggregations = 0;
        this.aggregatedPendingUpdates.pages.clear();
    }

    public void shutdown() {
        this.terminate = true;
    }

    private static class TimedUsageUpdate {
        private final Map<String, PageStatsPayload> pages = new HashMap<String, PageStatsPayload>();
        private long lastCommitTime = System.currentTimeMillis();
        private int numAggregations = 0;
    }
}

