/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota;

import java.util.concurrent.BlockingQueue;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.diskquota.QueuedQuotaUpdatesProducer;
import org.geowebcache.diskquota.UsageStats;
import org.geowebcache.diskquota.storage.TileSet;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerListener;
import org.springframework.util.Assert;

public class QueuedUsageStatsProducer
implements TileLayerListener {
    private static final Logger log = Logging.getLogger((String)QueuedQuotaUpdatesProducer.class.getName());
    private final BlockingQueue<UsageStats> usageStatsQueue;
    private volatile boolean cancelled;

    public QueuedUsageStatsProducer(BlockingQueue<UsageStats> usageStatsQueue) {
        Assert.notNull(usageStatsQueue, (String)"usageStatsQueue can't be null");
        this.usageStatsQueue = usageStatsQueue;
    }

    public void tileRequested(TileLayer layer, ConveyorTile tile) {
        String layerName = layer.getName();
        if (this.cancelled(layerName)) {
            return;
        }
        String gridsetId = tile.getGridSetId();
        String blobFormat = tile.getMimeType().getFormat();
        String parametersId = tile.getParametersId();
        TileSet tileSet = new TileSet(layerName, gridsetId, blobFormat, parametersId);
        long[] tileIndex = (long[])tile.getTileIndex().clone();
        UsageStats usageLog = new UsageStats(tileSet, tileIndex);
        try {
            this.usageStatsQueue.put(usageLog);
        }
        catch (InterruptedException e) {
            if (this.cancelled(layerName)) {
                return;
            }
            log.info("Quota usage stats gathering for " + layerName + " abruptly interrupted on thread " + Thread.currentThread().getName());
            Thread.currentThread().interrupt();
        }
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    private boolean cancelled(String layerName) {
        if (this.cancelled) {
            log.fine("Quota usage stats listener cancelled. Avoiding adding update for layer " + layerName + " to tile page store");
        }
        return this.cancelled;
    }
}

