/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota.jdbc;

import java.sql.Connection;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.geotools.util.factory.GeoTools;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.diskquota.jdbc.JDBCConfiguration;
import org.geowebcache.diskquota.jdbc.JDBCQuotaStoreFactory;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class JDBCQuotaStoreFactoryTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJNDILookup() throws Exception {
        InitialContext ctx = (InitialContext)Mockito.mock(InitialContext.class);
        DataSource dataSource = (DataSource)Mockito.mock(DataSource.class);
        Connection cx = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)dataSource.getConnection()).thenReturn((Object)cx);
        String javaName = "java://data/source";
        Mockito.when((Object)ctx.lookup(javaName)).thenReturn((Object)dataSource);
        String httpName = "http://data/source";
        Mockito.when((Object)ctx.lookup(httpName)).thenReturn((Object)dataSource);
        GeoTools.init((InitialContext)ctx);
        try {
            JDBCConfiguration javaConfiguration = new JDBCConfiguration();
            javaConfiguration.setJNDISource(javaName);
            JDBCConfiguration httpConfiguration = new JDBCConfiguration();
            httpConfiguration.setJNDISource(httpName);
            Assert.assertSame((Object)dataSource, (Object)new JDBCQuotaStoreFactory().getDataSource(javaConfiguration));
            try {
                new JDBCQuotaStoreFactory().getDataSource(httpConfiguration);
                Assert.fail((String)"Lookup should have failed with an exception");
            }
            catch (ConfigurationException exception) {
                Assert.assertEquals((Object)("Failed to get a datasource from: " + httpName), (Object)exception.getMessage());
            }
        }
        finally {
            GeoTools.clearInitialContext();
        }
    }
}

