/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota.jdbc;

import java.util.Arrays;
import org.geowebcache.diskquota.jdbc.SQLDialect;

public class HSQLDialect
extends SQLDialect {
    public HSQLDialect() {
        this.TABLE_CREATION_MAP.put("TILESET", Arrays.asList("CREATE CACHED TABLE ${schema}TILESET (\n  KEY VARCHAR(320) PRIMARY KEY,\n  LAYER_NAME VARCHAR(128),\n  GRIDSET_ID VARCHAR(32),\n  BLOB_FORMAT VARCHAR(64),\n  PARAMETERS_ID VARCHAR(41),\n  BYTES NUMERIC(21) DEFAULT 0 NOT NULL\n)", "CREATE INDEX TILESET_LAYER ON ${schema}TILESET(LAYER_NAME)"));
        this.TABLE_CREATION_MAP.put("TILEPAGE", Arrays.asList("CREATE CACHED TABLE ${schema}TILEPAGE (\n KEY VARCHAR(320) PRIMARY KEY,\n TILESET_ID VARCHAR(320) REFERENCES ${schema}TILESET(KEY) ON DELETE CASCADE,\n PAGE_Z SMALLINT,\n PAGE_X INTEGER,\n PAGE_Y INTEGER,\n CREATION_TIME_MINUTES INTEGER,\n FREQUENCY_OF_USE FLOAT,\n LAST_ACCESS_TIME_MINUTES INTEGER,\n FILL_FACTOR FLOAT,\n NUM_HITS NUMERIC(64)\n)", "CREATE INDEX TILEPAGE_TILESET ON ${schema}TILEPAGE(TILESET_ID, FILL_FACTOR)", "CREATE INDEX TILEPAGE_FREQUENCY ON ${schema}TILEPAGE(FREQUENCY_OF_USE DESC)", "CREATE INDEX TILEPAGE_LAST_ACCESS ON ${schema}TILEPAGE(LAST_ACCESS_TIME_MINUTES DESC)"));
    }

    @Override
    public String getCreateTileSetQuery(String schema, String keyParam, String layerNameParam, String gridSetIdParam, String blobFormatParam, String paramIdParam) {
        StringBuilder sb = new StringBuilder("INSERT INTO ");
        if (schema != null) {
            sb.append(schema).append(".");
        }
        sb.append("TILESET SELECT :").append(keyParam);
        sb.append(", :").append(layerNameParam);
        sb.append(", :").append(gridSetIdParam);
        sb.append(", :").append(blobFormatParam);
        sb.append(", :").append(paramIdParam);
        sb.append(", 0 ");
        this.addEmtpyTableReference(sb);
        sb.append(" FROM (VALUES(1)) AS dummy WHERE NOT EXISTS(SELECT 1 FROM ");
        if (schema != null) {
            sb.append(schema).append(".");
        }
        sb.append("TILESET WHERE KEY = :").append(keyParam).append(")");
        return sb.toString();
    }

    @Override
    public String contionalTilePageInsertStatement(String schema, String keyParam, String tileSetIdParam, String zParam, String xParam, String yParam, String creationParam, String frequencyParam, String lastAccessParam, String fillFactorParam, String numHitsParam) {
        StringBuilder sb = new StringBuilder("INSERT INTO ");
        if (schema != null) {
            sb.append(schema).append(".");
        }
        sb.append("TILEPAGE SELECT :").append(keyParam).append(", ");
        sb.append(":").append(tileSetIdParam).append(", ");
        sb.append(":").append(zParam).append(", ");
        sb.append(":").append(xParam).append(", ");
        sb.append(":").append(yParam).append(", ");
        sb.append(":").append(creationParam).append(", ");
        sb.append(":").append(frequencyParam).append(", ");
        sb.append(":").append(lastAccessParam).append(", ");
        sb.append(":").append(fillFactorParam).append(", ");
        sb.append(":").append(numHitsParam).append(" ");
        this.addEmtpyTableReference(sb);
        sb.append(" FROM (VALUES(1)) AS dummy WHERE NOT EXISTS(SELECT 1 FROM ");
        if (schema != null) {
            sb.append(schema).append(".");
        }
        sb.append("TILEPAGE WHERE KEY = :").append(keyParam).append(")");
        return sb.toString();
    }
}

