/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.blobstore.memory.distributed;

import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.HazelcastInstanceFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.geotools.util.logging.Logging;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.blobstore.memory.CacheProvider;
import org.geowebcache.storage.blobstore.memory.MemoryBlobStore;
import org.geowebcache.storage.blobstore.memory.NullBlobStore;
import org.geowebcache.storage.blobstore.memory.distributed.HazelcastCacheProvider;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class HazelcastCacheProviderTest {
    public static final Logger LOG = Logging.getLogger((String)HazelcastCacheProviderTest.class.getName());
    public static final String APP_CONTEXT_FILENAME = "applicationContextTest.xml";
    public static final String CACHE_1_NAME = "HazelCastCacheProvider1";
    public static final String CACHE_2_NAME = "HazelCastCacheProvider2";
    private static HazelcastCacheProvider cache1;
    private static HazelcastCacheProvider cache2;
    private static MemoryBlobStore mem1;
    private static MemoryBlobStore mem2;

    @BeforeClass
    public static void initialSetup() throws UnknownHostException {
        Config config = new Config();
        config.getMapConfig("default").setBackupCount(1).setAsyncBackupCount(0);
        HazelcastInstance h1 = HazelcastInstanceFactory.newHazelcastInstance((Config)new Config());
        HazelcastInstance h2 = HazelcastInstanceFactory.newHazelcastInstance((Config)new Config());
        NullBlobStore nbs = new NullBlobStore();
        mem1 = new MemoryBlobStore();
        mem1.setStore((BlobStore)nbs);
        cache1 = new HazelcastCacheProvider(h1.getMap("map1"), 16L);
        mem1.setCacheProvider((CacheProvider)cache1);
        mem2 = new MemoryBlobStore();
        mem2.setStore((BlobStore)nbs);
        cache2 = new HazelcastCacheProvider(h2.getMap("map1"), 16L);
        mem2.setCacheProvider((CacheProvider)cache2);
        Assert.assertTrue((boolean)cache1.isAvailable());
        Assert.assertTrue((boolean)cache1.isImmutable());
        Assert.assertTrue((boolean)cache2.isAvailable());
        Assert.assertTrue((boolean)cache2.isImmutable());
    }

    @Test
    public void testTilePut() throws Exception {
        cache1.clear();
        Assert.assertEquals((long)0L, (long)cache1.getStatistics().getActualSize());
        Assert.assertEquals((long)0L, (long)cache2.getStatistics().getActualSize());
        ByteArrayResource bytes = new ByteArrayResource("1 2 3 4 5 6 test".getBytes());
        long[] xyz = new long[]{1L, 2L, 3L};
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("a", "x");
        parameters.put("b", "\u00f8");
        TileObject to = TileObject.createCompleteTileObject((String)"test:123123 112", (long[])xyz, (String)"EPSG:4326", (String)"image/jpeg", parameters, (Resource)bytes);
        mem1.put(to);
        TileObject to2 = TileObject.createQueryTileObject((String)"test:123123 112", (long[])xyz, (String)"EPSG:4326", (String)"image/jpeg", parameters);
        Assert.assertTrue((boolean)mem2.get(to2));
        Assert.assertEquals((Object)to.getBlobFormat(), (Object)to2.getBlobFormat());
        try (InputStream is = to.getBlob().getInputStream();
             InputStream is2 = to2.getBlob().getInputStream();){
            this.checkInputStreams(is, is2);
        }
        TileObject to3 = cache1.getTileObj(to);
        Assert.assertNotNull((Object)to3);
        try (InputStream is = to.getBlob().getInputStream();
             InputStream is3 = to3.getBlob().getInputStream();){
            this.checkInputStreams(is, is3);
        }
        TileObject to4 = cache2.getTileObj(to);
        Assert.assertNotNull((Object)to4);
        try (InputStream is = to.getBlob().getInputStream();
             InputStream is4 = to4.getBlob().getInputStream();){
            this.checkInputStreams(is, is4);
        }
    }

    @Test
    public void testTileDelete() throws Exception {
        cache1.clear();
        Assert.assertEquals((long)0L, (long)cache1.getStatistics().getActualSize());
        Assert.assertEquals((long)0L, (long)cache2.getStatistics().getActualSize());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("a", "x");
        parameters.put("b", "y");
        ByteArrayResource bytes = new ByteArrayResource("1 2 3 4 5 6 test".getBytes());
        long[] xyz = new long[]{5L, 6L, 7L};
        TileObject to = TileObject.createCompleteTileObject((String)"test:123123 112", (long[])xyz, (String)"EPSG:4326", (String)"image/jpeg", parameters, (Resource)bytes);
        mem1.put(to);
        TileObject to2 = TileObject.createQueryTileObject((String)"test:123123 112", (long[])xyz, (String)"EPSG:4326", (String)"image/jpeg", parameters);
        Assert.assertTrue((boolean)mem2.get(to2));
        try (InputStream is = to2.getBlob().getInputStream();
             InputStream is2 = bytes.getInputStream();){
            this.checkInputStreams(is, is2);
        }
        TileObject to3 = TileObject.createQueryTileObject((String)"test:123123 112", (long[])xyz, (String)"EPSG:4326", (String)"image/jpeg", parameters);
        mem1.delete(to3);
        TileObject to4 = TileObject.createQueryTileObject((String)"test:123123 112", (long[])xyz, (String)"EPSG:4326", (String)"image/jpeg", parameters);
        Assert.assertFalse((boolean)mem1.get(to4));
        Assert.assertFalse((boolean)mem2.get(to4));
        TileObject to5 = cache1.getTileObj(to);
        Assert.assertNull((Object)to5);
        TileObject to6 = cache2.getTileObj(to);
        Assert.assertNull((Object)to6);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        mem1.destroy();
        mem2.destroy();
        cache1.destroy();
        cache2.destroy();
        Hazelcast.shutdownAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInputStreams(InputStream is, InputStream is2) throws IOException {
        try {
            Assert.assertTrue((boolean)IOUtils.contentEquals((InputStream)is, (InputStream)is2));
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, e.getMessage(), e);
                Assert.fail();
            }
            try {
                is2.close();
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, e.getMessage(), e);
                Assert.fail();
            }
        }
    }
}

