/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage.blobstore.memory.distributed;

import com.hazelcast.core.IMap;
import com.hazelcast.map.EntryBackupProcessor;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.query.EntryObject;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.PredicateBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.blobstore.memory.CacheConfiguration;
import org.geowebcache.storage.blobstore.memory.CacheProvider;
import org.geowebcache.storage.blobstore.memory.CacheStatistics;
import org.geowebcache.storage.blobstore.memory.distributed.HazelcastLoader;
import org.geowebcache.storage.blobstore.memory.guava.GuavaCacheProvider;
import org.springframework.beans.factory.DisposableBean;

public class HazelcastCacheProvider
implements CacheProvider,
DisposableBean {
    private static final Logger LOGGER = Logging.getLogger((String)HazelcastCacheProvider.class.getName());
    public static final String HAZELCAST_MAP_DEFINITION = "CacheProviderMap";
    public static final long MB_TO_BYTES = 0x100000L;
    private static final String HAZELCAST_NAME = "Hazelcast Cache";
    private final IMap<String, TileObject> map;
    private final boolean configured;
    private final long totalSize;

    public HazelcastCacheProvider(HazelcastLoader loader) {
        this.configured = loader.isConfigured();
        if (this.configured) {
            this.map = loader.getInstance().getMap(HAZELCAST_MAP_DEFINITION);
            this.totalSize = (long)loader.getInstance().getConfig().getMapConfig(HAZELCAST_MAP_DEFINITION).getMaxSizeConfig().getSize() * 0x100000L;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Configured Hazelcast Cache");
            }
        } else {
            this.map = null;
            this.totalSize = 0L;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Hazelcast Cache not configured");
            }
        }
    }

    public HazelcastCacheProvider(IMap<String, TileObject> map, long totalSize) {
        this.map = map;
        this.totalSize = totalSize;
        this.configured = true;
    }

    public TileObject getTileObj(TileObject obj) {
        if (this.configured) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Getting TileObject:" + String.valueOf(obj));
            }
            String key = GuavaCacheProvider.generateTileKey((TileObject)obj);
            return (TileObject)this.map.get((Object)key);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Cache not configured");
        }
        return null;
    }

    public void putTileObj(TileObject obj) {
        if (this.configured) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Adding TileObject:" + String.valueOf(obj));
            }
            String key = GuavaCacheProvider.generateTileKey((TileObject)obj);
            this.map.put((Object)key, (Object)obj);
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Cache not configured");
        }
    }

    public void removeTileObj(TileObject obj) {
        if (this.configured) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Removing TileObject:" + String.valueOf(obj));
            }
            String key = GuavaCacheProvider.generateTileKey((TileObject)obj);
            this.map.remove((Object)key);
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Cache not configured");
        }
    }

    public void removeLayer(String layername) {
        if (this.configured) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Removing Layer:" + layername);
            }
            EntryObject e = new PredicateBuilder().getEntryObject();
            PredicateBuilder predicate = e.get("layer_name").equal((Comparable)((Object)layername));
            CacheEntryProcessor entryProcessor = new CacheEntryProcessor();
            this.map.executeOnEntries((EntryProcessor)entryProcessor, (Predicate)predicate);
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Cache not configured");
        }
    }

    public void clear() {
        if (this.configured) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Clearing cache");
            }
            this.map.clear();
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Cache not configured");
        }
    }

    public void reset() {
        if (this.configured) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Resetting cache");
            }
            this.map.clear();
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Cache not configured");
        }
    }

    public void destroy() throws Exception {
        if (this.configured) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Destroying cache");
            }
            this.map.destroy();
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Cache not configured");
        }
    }

    public CacheStatistics getStatistics() {
        if (this.configured) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Getting cache statistics");
            }
            LocalMapStats localMapStats = this.map.getLocalMapStats();
            HazelcastCacheStatistics stats = new HazelcastCacheStatistics(localMapStats, this.totalSize);
            return stats;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Cache not configured");
        }
        return new CacheStatistics();
    }

    public void configure(CacheConfiguration configuration) {
    }

    public void addUncachedLayer(String layername) {
    }

    public void removeUncachedLayer(String layername) {
    }

    public boolean containsUncachedLayer(String layername) {
        return false;
    }

    public List<CacheConfiguration.EvictionPolicy> getSupportedPolicies() {
        return Collections.emptyList();
    }

    public boolean isImmutable() {
        return true;
    }

    public boolean isAvailable() {
        return this.configured;
    }

    public String getName() {
        return HAZELCAST_NAME;
    }

    static class CacheEntryProcessor
    implements EntryProcessor<String, TileObject> {
        CacheEntryProcessor() {
        }

        public Object process(Map.Entry<String, TileObject> entry) {
            entry.setValue(null);
            return null;
        }

        public EntryBackupProcessor<String, TileObject> getBackupProcessor() {
            return null;
        }
    }

    static class HazelcastCacheStatistics
    extends CacheStatistics {
        public HazelcastCacheStatistics(LocalMapStats localMapStats, long totalSize) {
            long hits = localMapStats.getHits();
            this.setHitCount(hits);
            long total = localMapStats.getGetOperationCount();
            this.setMissCount(-1L);
            this.setTotalCount(total);
            double hitRate = -1.0;
            double missRate = -1.0;
            this.setHitRate(hitRate);
            this.setMissRate(missRate);
            this.setTotalSize(totalSize);
            long actualSize = localMapStats.getOwnedEntryMemoryCost();
            this.setActualSize(actualSize);
            int currentMemoryOccupation = (int)(100.0 - 1.0 * (100.0 * (1.0 * (double)(totalSize - actualSize)) / (double)totalSize));
            if (currentMemoryOccupation < 0) {
                currentMemoryOccupation = 0;
            }
            this.setCurrentMemoryOccupation(currentMemoryOccupation);
            this.setEvictionCount(-1L);
        }
    }
}

