/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage.blobstore.memory.distributed;

import com.hazelcast.config.Config;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MaxSizeConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.geotools.util.logging.Logging;
import org.springframework.beans.factory.InitializingBean;

public class HazelcastLoader
implements InitializingBean {
    private static final Logger LOGGER = Logging.getLogger((String)HazelcastLoader.class.getName());
    public static final String HAZELCAST_CONFIG_DIR = "hazelcast.config.dir";
    public static final String HAZELCAST_NAME = "hazelcast.xml";
    private HazelcastInstance instance;

    public void afterPropertiesSet() throws Exception {
        if (this.instance == null) {
            NameFileFilter filter;
            File[] files;
            File hazelCastDir;
            String hazelDirPath = System.getProperty(HAZELCAST_CONFIG_DIR);
            if (hazelDirPath != null && (hazelCastDir = new File(hazelDirPath)).exists() && hazelCastDir.isDirectory() && hazelCastDir.canRead() && (files = hazelCastDir.listFiles((FileFilter)(filter = new NameFileFilter(HAZELCAST_NAME)))) != null && files.length > 0) {
                File hazelCastConf = files[0];
                Config config = null;
                try (FileInputStream stream = new FileInputStream(hazelCastConf);){
                    config = new XmlConfigBuilder((InputStream)stream).build();
                }
                if (this.configAccepted(config)) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Hazelcast instance validated");
                    }
                    this.instance = Hazelcast.newHazelcastInstance((Config)config);
                } else if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("No mapping for CacheProvider Map is present");
                }
            }
        } else if (!this.configAccepted(this.instance.getConfig())) {
            this.instance = null;
        }
        if (LOGGER.isLoggable(Level.FINE) && this.instance == null) {
            LOGGER.fine("Hazelcast instance invalid or not found");
        }
    }

    public boolean isConfigured() {
        return this.instance != null;
    }

    public void setInstance(HazelcastInstance instance) {
        this.instance = instance;
    }

    public HazelcastInstance getInstance() {
        return this.isConfigured() ? this.instance : null;
    }

    private boolean configAccepted(Config config) {
        boolean configAccepted = false;
        if (config != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Checking configuration");
            }
            if (config.getMapConfigs().containsKey("CacheProviderMap")) {
                MapConfig mapConfig = config.getMapConfig("CacheProviderMap");
                boolean sizeDefined = mapConfig.getMaxSizeConfig().getSize() > 0;
                boolean policyExists = mapConfig.getEvictionPolicy() != MapConfig.DEFAULT_EVICTION_POLICY;
                boolean sizeFromHeap = mapConfig.getMaxSizeConfig().getMaxSizePolicy() == MaxSizeConfig.MaxSizePolicy.USED_HEAP_SIZE;
                boolean nearCacheAccepted = true;
                if (mapConfig.getNearCacheConfig() != null) {
                    NearCacheConfig conf = mapConfig.getNearCacheConfig();
                    boolean bl = nearCacheAccepted = conf.getEvictionConfig().getSize() < Integer.MAX_VALUE;
                }
                if (sizeDefined && policyExists && sizeFromHeap && nearCacheAccepted) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Hazelcast config validated");
                    }
                    configAccepted = true;
                }
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("No configuration provided");
        }
        return configAccepted;
    }
}

