/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.georss;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.georss.GeoRSSReader;
import org.geowebcache.georss.GeoRSSTileRangeBuilder;
import org.geowebcache.georss.GeometryRasterMaskBuilder;
import org.geowebcache.georss.RasterMaskTestUtils;
import org.geowebcache.georss.StaxGeoRSSReader;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.util.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GeoRSSTileRangeBuilderTest {
    private static final boolean debugToDisk = Boolean.getBoolean("org.geowebcache.debugToDisk");
    private TileLayer layer;
    private String gridsetId;

    @Before
    public void setUp() {
        RasterMaskTestUtils.debugToDisk = debugToDisk;
        this.layer = TestUtils.createWMSLayer((String)"image/png", (GridSetBroker)new GridSetBroker(Collections.singletonList(new DefaultGridsets(false, false))), (int)3, (int)3, (BoundingBox)new BoundingBox(-180.0, -90.0, 180.0, 90.0));
        this.gridsetId = (String)this.layer.getGridSubsets().iterator().next();
    }

    @Test
    public void testBuildTileRangeMask() throws Exception {
        GeometryRasterMaskBuilder tileRangeMask = RasterMaskTestUtils.buildSampleFilterMatrix(this.layer, this.gridsetId);
        Assert.assertNotNull((Object)tileRangeMask);
        Assert.assertEquals((long)0L, (long)tileRangeMask.getStartLevel());
        Assert.assertEquals((long)11L, (long)tileRangeMask.getNumLevels());
        Assert.assertEquals((long)this.layer.getGridSubset(this.gridsetId).getCoverages().length, (long)tileRangeMask.getNumLevels());
    }

    @Test
    public void testCoveredBounds() throws Exception {
        GeometryRasterMaskBuilder tileRangeMask = RasterMaskTestUtils.buildSampleFilterMatrix(this.layer, this.gridsetId);
        long[][] coverages = this.layer.getGridSubset(this.gridsetId).getCoverages();
        long[][] expectedGridCoverages = new long[][]{{0L, 0L, 1L, 0L, 0L}, {0L, 0L, 3L, 1L, 1L}, {0L, 0L, 7L, 3L, 2L}, {0L, 0L, 15L, 7L, 3L}, {0L, 0L, 31L, 15L, 4L}, {0L, 0L, 63L, 31L, 5L}, {0L, 0L, 127L, 63L, 6L}, {0L, 0L, 255L, 127L, 7L}, {0L, 0L, 511L, 255L, 8L}, {0L, 0L, 1023L, 511L, 9L}, {0L, 0L, 2047L, 1023L, 10L}};
        TestUtils.assertEquals((long[][])expectedGridCoverages, (long[][])coverages);
        TestUtils.assertEquals((long[])new long[]{0L, 0L, 1L, 0L, 0L}, (long[])tileRangeMask.getCoveredBounds(0));
        TestUtils.assertEquals((long[])new long[]{0L, 0L, 3L, 1L, 1L}, (long[])tileRangeMask.getCoveredBounds(1));
        TestUtils.assertEquals((long[])new long[]{1L, 0L, 7L, 3L, 2L}, (long[])tileRangeMask.getCoveredBounds(2));
        TestUtils.assertEquals((long[])new long[]{3L, 0L, 15L, 6L, 3L}, (long[])tileRangeMask.getCoveredBounds(3));
        TestUtils.assertEquals((long[])new long[]{7L, 0L, 31L, 12L, 4L}, (long[])tileRangeMask.getCoveredBounds(4));
        TestUtils.assertEquals((long[])new long[]{15L, 0L, 63L, 24L, 5L}, (long[])tileRangeMask.getCoveredBounds(5));
        TestUtils.assertEquals((long[])new long[]{31L, 0L, 127L, 48L, 6L}, (long[])tileRangeMask.getCoveredBounds(6));
        TestUtils.assertEquals((long[])new long[]{63L, 0L, 255L, 96L, 7L}, (long[])tileRangeMask.getCoveredBounds(7));
        TestUtils.assertEquals((long[])new long[]{127L, 0L, 511L, 192L, 8L}, (long[])tileRangeMask.getCoveredBounds(8));
        TestUtils.assertEquals((long[])new long[]{255L, 0L, 1023L, 384L, 9L}, (long[])tileRangeMask.getCoveredBounds(9));
        TestUtils.assertEquals((long[])new long[]{511L, 0L, 2047L, 768L, 10L}, (long[])tileRangeMask.getCoveredBounds(10));
    }

    @Test
    public void testLatestUpdate() throws IOException, XMLStreamException, FactoryConfigurationError {
        this.assertLatestUpdate("2005-08-17T07:02:34Z", "point_feed.xml");
        this.assertLatestUpdate("2010-08-17T07:02:32Z", "mixedgeometries_feed.xml");
    }

    private void assertLatestUpdate(String expected, String fileName) throws IOException, XMLStreamException, FactoryConfigurationError {
        try (InputStream stream = this.getClass().getResourceAsStream("test-data/" + fileName);
             BufferedReader feed = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            StaxGeoRSSReader reader = new StaxGeoRSSReader((Reader)feed);
            GeoRSSTileRangeBuilder b = new GeoRSSTileRangeBuilder(this.layer, this.gridsetId, 10);
            b.buildTileRangeMask((GeoRSSReader)reader, null);
            Assert.assertEquals((Object)expected, (Object)b.getLastEntryUpdate());
        }
    }
}

