/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.georss;

import java.util.Collections;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.georss.GeometryRasterMaskBuilder;
import org.geowebcache.georss.RasterMaskTestUtils;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.storage.RasterMask;
import org.geowebcache.util.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RasterMaskTest {
    private static final boolean debugToDisk = Boolean.getBoolean("org.geowebcache.debugToDisk");
    private TileLayer layer;
    private String gridsetId;
    private long[][] fullCoverage;

    @Before
    public void setUp() {
        RasterMaskTestUtils.debugToDisk = debugToDisk;
        this.layer = TestUtils.createWMSLayer((String)"image/png", (GridSetBroker)new GridSetBroker(Collections.singletonList(new DefaultGridsets(false, false))), (int)3, (int)3, (BoundingBox)new BoundingBox(-180.0, -90.0, 180.0, 90.0));
        this.gridsetId = (String)this.layer.getGridSubsets().iterator().next();
        this.fullCoverage = this.layer.getGridSubset(this.gridsetId).getCoverages();
    }

    @Test
    public void testTileIsPresent() throws Exception {
        GeometryRasterMaskBuilder mask = RasterMaskTestUtils.buildSampleFilterMatrix(this.layer, this.gridsetId);
        RasterMask tileRangeMask = new RasterMask(mask.getByLevelMasks(), this.fullCoverage, mask.getCoveredBounds());
        Assert.assertTrue((boolean)tileRangeMask.lookup(0L, 0L, 0));
        Assert.assertTrue((boolean)tileRangeMask.lookup(1L, 0L, 0));
        Assert.assertTrue((boolean)tileRangeMask.lookup(1L, 1L, 1));
        Assert.assertTrue((boolean)tileRangeMask.lookup(1L, 0L, 1));
        Assert.assertFalse((boolean)tileRangeMask.lookup(0L, 0L, 2));
        Assert.assertFalse((boolean)tileRangeMask.lookup(0L, 1L, 2));
        Assert.assertTrue((boolean)tileRangeMask.lookup(1L, 0L, 2));
        Assert.assertFalse((boolean)tileRangeMask.lookup(0L, 3L, 2));
        Assert.assertTrue((boolean)tileRangeMask.lookup(7L, 0L, 2));
        Assert.assertFalse((boolean)tileRangeMask.lookup(0L, 0L, 9));
        Assert.assertFalse((boolean)tileRangeMask.lookup(0L, 511L, 9));
        Assert.assertFalse((boolean)tileRangeMask.lookup(1023L, 511L, 9));
        Assert.assertTrue((boolean)tileRangeMask.lookup(1023L, 0L, 9));
        Assert.assertTrue((boolean)tileRangeMask.lookup(511L, 127L, 9));
        Assert.assertTrue((boolean)tileRangeMask.lookup(255L, 127L, 9));
        Assert.assertTrue((boolean)tileRangeMask.lookup(767L, 383L, 9));
        Assert.assertTrue((boolean)tileRangeMask.lookup(511L, 255L, 9));
    }

    @Test
    public void testTileIsPresentBuffering() throws Exception {
        GeometryRasterMaskBuilder mask = RasterMaskTestUtils.buildSampleFilterMatrix(this.layer, this.gridsetId);
        RasterMask tileRangeMask = new RasterMask(mask.getByLevelMasks(), this.fullCoverage, mask.getCoveredBounds());
        Assert.assertTrue((boolean)tileRangeMask.lookup(32L, 23L, 5));
        Assert.assertTrue((boolean)tileRangeMask.lookup(31L, 23L, 5));
        Assert.assertTrue((boolean)tileRangeMask.lookup(32L, 24L, 5));
        Assert.assertTrue((boolean)tileRangeMask.lookup(31L, 24L, 5));
    }

    @Test
    public void testTileIsPresentWithSubSampling() throws Exception {
        int maxMaskLevel = 3;
        GeometryRasterMaskBuilder mask = RasterMaskTestUtils.buildSampleFilterMatrix(this.layer, this.gridsetId, 3);
        RasterMask tileRangeMask = new RasterMask(mask.getByLevelMasks(), this.fullCoverage, mask.getCoveredBounds());
        Assert.assertFalse((boolean)tileRangeMask.lookup(0L, 0L, 5));
        Assert.assertFalse((boolean)tileRangeMask.lookup(0L, 31L, 5));
        Assert.assertFalse((boolean)tileRangeMask.lookup(63L, 31L, 5));
        Assert.assertTrue((boolean)tileRangeMask.lookup(63L, 0L, 5));
        Assert.assertTrue((boolean)tileRangeMask.lookup(32L, 23L, 5));
        Assert.assertTrue((boolean)tileRangeMask.lookup(31L, 23L, 5));
        Assert.assertTrue((boolean)tileRangeMask.lookup(33L, 23L, 5));
        Assert.assertTrue((boolean)tileRangeMask.lookup(32L, 24L, 5));
        Assert.assertTrue((boolean)tileRangeMask.lookup(32L, 22L, 5));
        Assert.assertTrue((boolean)tileRangeMask.lookup(31L, 24L, 5));
        Assert.assertTrue((boolean)tileRangeMask.lookup(33L, 24L, 5));
        Assert.assertTrue((boolean)tileRangeMask.lookup(31L, 22L, 5));
        Assert.assertTrue((boolean)tileRangeMask.lookup(33L, 22L, 5));
    }
}

