/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.georss;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.geotools.util.logging.Logging;
import org.geowebcache.georss.GeometryRasterMaskBuilder;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileLayer;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class RasterMaskTestUtils {
    static final Logger LOG = Logging.getLogger((String)RasterMaskTestUtils.class.getName());
    public static boolean debugToDisk;

    public static GeometryRasterMaskBuilder buildSampleFilterMatrix(TileLayer layer, String gridsetId) throws Exception {
        return RasterMaskTestUtils.buildSampleFilterMatrix(layer, gridsetId, 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GeometryRasterMaskBuilder buildSampleFilterMatrix(TileLayer layer, String gridsetId, int maxMaskLevel) throws Exception {
        Geometry[] entries = RasterMaskTestUtils.createSampleEntries();
        GridSubset gridSubset = layer.getGridSubset((String)layer.getGridSubsets().iterator().next());
        int[] metaTilingFactors = layer.getMetaTilingFactors();
        GeometryRasterMaskBuilder matrix = new GeometryRasterMaskBuilder(gridSubset, metaTilingFactors, maxMaskLevel);
        try {
            for (Geometry geom : entries) {
                matrix.setMasksForGeometry(geom);
            }
        }
        finally {
            matrix.disposeGraphics();
        }
        RasterMaskTestUtils.logImages(new File("target"), matrix);
        return matrix;
    }

    public static void logImages(File target, GeometryRasterMaskBuilder matrix) throws IOException {
        if (debugToDisk) {
            BufferedImage[] byLevelMasks = matrix.getByLevelMasks();
            for (int i = 0; i < byLevelMasks.length; ++i) {
                File output = new File(target, "level_" + i + ".tiff");
                LOG.info("--- writing " + output.getAbsolutePath() + "---");
                ImageIO.write((RenderedImage)byLevelMasks[i], "TIFF", output);
            }
        }
    }

    private static Geometry[] createSampleEntries() throws Exception {
        Geometry[] entries = new Geometry[]{RasterMaskTestUtils.entry("POLYGON ((0 0, 0 -90, 180 -90, 180 0, 0 0))"), RasterMaskTestUtils.entry("POINT(0 45)"), RasterMaskTestUtils.entry("LINESTRING(-90 -45, 90 45)")};
        return entries;
    }

    private static Geometry entry(String wkt) throws ParseException {
        Geometry geometry = new WKTReader().read(wkt);
        return geometry;
    }
}

