/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.georss;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.geowebcache.georss.Entry;
import org.geowebcache.georss.StaxGeoRSSReader;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class StaxGeoRSSReaderTest {
    @Test
    public void testConstructor() throws Exception {
        try {
            new StaxGeoRSSReader((Reader)new StringReader("<not-a-feed/>"));
            Assert.fail((String)"expected IAE on not a georss feed argument");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testParsePointFeed() throws Exception {
        try (Reader feed = this.reader("point_feed.xml");){
            StaxGeoRSSReader reader = new StaxGeoRSSReader(feed);
            List<Entry> entries = this.read(reader);
            Assert.assertEquals((long)3L, (long)entries.size());
            this.assertRequiredMembers(entries);
            Assert.assertTrue((boolean)(entries.get(0).getWhere() instanceof Point));
            Assert.assertTrue((boolean)(entries.get(1).getWhere() instanceof Point));
            Assert.assertTrue((boolean)(entries.get(2).getWhere() instanceof Point));
        }
    }

    @Test
    public void testMultiGeometryTypesFeed() throws Exception {
        try (Reader feed = this.reader("mixedgeometries_feed.xml");){
            StaxGeoRSSReader reader = new StaxGeoRSSReader(feed);
            List<Entry> entries = this.read(reader);
            Assert.assertEquals((long)6L, (long)entries.size());
            this.assertRequiredMembers(entries);
            Assert.assertTrue((boolean)(entries.get(0).getWhere() instanceof Point));
            Assert.assertTrue((boolean)(entries.get(1).getWhere() instanceof MultiPoint));
            Assert.assertTrue((boolean)(entries.get(2).getWhere() instanceof Polygon));
            Assert.assertTrue((boolean)(entries.get(3).getWhere() instanceof MultiPolygon));
            Assert.assertTrue((boolean)(entries.get(4).getWhere() instanceof LineString));
            Assert.assertTrue((boolean)(entries.get(5).getWhere() instanceof MultiLineString));
        }
    }

    private void assertRequiredMembers(List<Entry> entries) {
        for (Entry e : entries) {
            Assert.assertNotNull((Object)e.getUpdated());
            Assert.assertNotNull((Object)e.getWhere());
        }
    }

    private List<Entry> read(StaxGeoRSSReader reader) throws IOException {
        Entry e;
        ArrayList<Entry> entries = new ArrayList<Entry>();
        while ((e = reader.nextEntry()) != null) {
            entries.add(e);
        }
        return entries;
    }

    private Reader reader(String fileName) throws FileNotFoundException, UnsupportedEncodingException {
        InputStream stream = this.getClass().getResourceAsStream("test-data/" + fileName);
        if (stream == null) {
            throw new FileNotFoundException("test-data/" + fileName);
        }
        return new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
    }
}

