/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.gmaps;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.filter.parameters.RegexParameterFilter;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.layer.TileLayerDispatcherMock;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.service.gmaps.GMapsConverter;
import org.geowebcache.storage.StorageBroker;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;

public class GMapsConverterTest {
    private static final String CQL_FILTER_PARAMETER_NAME = "CQL_FILTER";
    private static final String CQL_FILTER_PARAMETER_VALUE = "value='x'";
    private static final String TEST_LAYER_NAME = "testLayer";

    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testGMapsConverter() throws Exception {
        int x = 0;
        int y = 0;
        int z = 0;
        long[] gridLoc = GMapsConverter.convert((long)z, (long)x, (long)y);
        long[] solution = new long[]{0L, 0L, 0L};
        assert (Arrays.equals(gridLoc, solution));
        x = 0;
        y = 0;
        z = 1;
        solution[0] = 0L;
        solution[1] = 1L;
        solution[2] = 1L;
        gridLoc = GMapsConverter.convert((long)z, (long)x, (long)y);
        assert (Arrays.equals(gridLoc, solution));
        x = 1;
        y = 0;
        z = 1;
        solution[0] = 1L;
        solution[1] = 1L;
        solution[2] = 1L;
        gridLoc = GMapsConverter.convert((long)z, (long)x, (long)y);
        assert (Arrays.equals(gridLoc, solution));
        x = 3;
        y = 0;
        z = 2;
        solution[0] = 3L;
        solution[1] = 3L;
        solution[2] = 2L;
        gridLoc = GMapsConverter.convert((long)z, (long)x, (long)y);
        assert (Arrays.equals(gridLoc, solution));
        x = 2;
        y = 1;
        z = 2;
        solution[0] = 2L;
        solution[1] = 2L;
        solution[2] = 2L;
        gridLoc = GMapsConverter.convert((long)z, (long)x, (long)y);
        assert (Arrays.equals(gridLoc, solution));
    }

    @Test
    public void testConveyorCreation() {
        StorageBroker sb = null;
        ArrayList<RegexParameterFilter> filters = new ArrayList<RegexParameterFilter>();
        RegexParameterFilter parameterFilter = new RegexParameterFilter();
        parameterFilter.setKey(CQL_FILTER_PARAMETER_NAME);
        parameterFilter.setDefaultValue("");
        parameterFilter.setRegex("value='.*'");
        filters.add(parameterFilter);
        WMSLayer wmsLayer = new WMSLayer(TEST_LAYER_NAME, null, null, null, null, null, filters, null, null, true, null);
        TileLayerDispatcherMock tld = new TileLayerDispatcherMock((TileLayer)wmsLayer);
        GridSetBroker gsb = new GridSetBroker(Collections.singletonList(new DefaultGridsets(true, true)));
        wmsLayer.initialize(gsb);
        MockHttpServletRequest request = new MockHttpServletRequest();
        HttpServletResponse response = null;
        request.addParameter(CQL_FILTER_PARAMETER_NAME, CQL_FILTER_PARAMETER_VALUE);
        request.addParameter("layers", new String[]{TEST_LAYER_NAME});
        request.addParameter("zoom", "12");
        request.addParameter("x", "0");
        request.addParameter("y", "0");
        GMapsConverter converter = new GMapsConverter(sb, (TileLayerDispatcher)tld, gsb);
        try {
            ConveyorTile conveyorTile = converter.getConveyor((HttpServletRequest)request, response);
            Map parameters = conveyorTile.getParameters();
            Assert.assertNotNull((Object)parameters);
            Assert.assertEquals((Object)CQL_FILTER_PARAMETER_VALUE, (Object)URLDecoder.decode((String)parameters.get(CQL_FILTER_PARAMETER_NAME), "UTF8"));
        }
        catch (UnsupportedEncodingException | GeoWebCacheException e) {
            Assert.fail();
        }
    }
}

