/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.mbtiles.layer;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import no.ecc.vectortile.VectorTileDecoder;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.MockWepAppContextRule;
import org.geowebcache.config.TestXMLConfigurationSource;
import org.geowebcache.config.TileLayerConfiguration;
import org.geowebcache.config.XMLConfigurationProvider;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.OutsideCoverageException;
import org.geowebcache.layer.EmptyTileException;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.meta.LayerMetaInformation;
import org.geowebcache.layer.meta.TileJSON;
import org.geowebcache.layer.meta.VectorLayerMetadata;
import org.geowebcache.mbtiles.layer.MBTilesLayer;
import org.geowebcache.mbtiles.layer.MBTilesLayerXMLConfigurationProvider;
import org.geowebcache.mime.ApplicationMime;
import org.geowebcache.mime.MimeType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class MBTilesLayerTest {
    private static final double DELTA = 1.0E-6;
    private static final Set<String> TEST_FIELDS = new HashSet<String>(Arrays.asList("_zoom", "_row", "_col", "ID", "Costant", "Zeroval", "IntVal", "Double1", "Double2", "Double3"));
    private static final String TEST_POINTS_FILENAME = "manypoints_test.mbtiles";
    @Rule
    public MockWepAppContextRule extensions = new MockWepAppContextRule();
    @Rule
    public ExpectedException exception = ExpectedException.none();
    protected TileLayerConfiguration config;
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    protected File configDir;
    protected File configFile;
    TestXMLConfigurationSource configSource = new TestXMLConfigurationSource();

    @Before
    public void setUpTestUnit() throws Exception {
        this.config = this.getConfig();
    }

    protected TileLayerConfiguration getConfig() throws Exception {
        this.makeConfigFile();
        return this.getConfig(this.extensions);
    }

    private void makeConfigFile() throws Exception {
        if (this.configFile == null) {
            this.configDir = this.temp.getRoot();
            this.configFile = this.temp.newFile("geowebcache.xml");
            File lakesFile = this.temp.newFile("world_lakes.mbtiles");
            URL source = MBTilesLayerTest.class.getResource("world_lakes.mbtiles");
            Files.copy(Paths.get(source.toURI()), lakesFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            File pointsFile = this.temp.newFile(TEST_POINTS_FILENAME);
            source = MBTilesLayerTest.class.getResource(TEST_POINTS_FILENAME);
            Files.copy(Paths.get(source.toURI()), pointsFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            source = MBTilesLayerTest.class.getResource("geowebcache.xml");
            try (Stream<String> lines = Files.lines(Paths.get(source.toURI()));){
                List replaced = lines.map(line -> line.replace("world_lakes.mbtiles", lakesFile.getAbsolutePath()).replace(TEST_POINTS_FILENAME, pointsFile.getAbsolutePath()).replace("\\", "\\\\")).collect(Collectors.toList());
                Files.write(this.configFile.toPath(), replaced, new OpenOption[0]);
            }
        }
    }

    private TileLayerConfiguration getConfig(MockWepAppContextRule extensions) throws Exception {
        extensions.addBean("MBTilesLayerConfigProvider", (Object)new MBTilesLayerXMLConfigurationProvider(), new Class[]{XMLConfigurationProvider.class});
        return this.configSource.create(extensions, this.configDir);
    }

    @Test
    public void testLayerDefaultValues() {
        Optional layer = this.config.getLayer("World_Lakes");
        TileLayer worldLakesLayer = (TileLayer)layer.get();
        Assert.assertTrue((boolean)(worldLakesLayer instanceof MBTilesLayer));
        MBTilesLayer mbTilesLayer = (MBTilesLayer)worldLakesLayer;
        Assert.assertEquals((long)256L, (long)mbTilesLayer.getTileSize());
    }

    @Test
    public void testLayerConfigValues() throws GeoWebCacheException, IOException {
        Optional layer = this.config.getLayer("testName");
        TileLayer testLayer = (TileLayer)layer.get();
        Assert.assertTrue((boolean)(testLayer instanceof MBTilesLayer));
        MBTilesLayer mbTilesLayer = (MBTilesLayer)testLayer;
        Assert.assertEquals((long)256L, (long)mbTilesLayer.getTileSize());
        LayerMetaInformation metaInformation = mbTilesLayer.getMetaInformation();
        Assert.assertNotNull((Object)metaInformation);
        Assert.assertEquals((Object)"TestDescription", (Object)metaInformation.getDescription());
        Assert.assertEquals((Object)"TestTitle", (Object)metaInformation.getTitle());
        Set gridsubsets = mbTilesLayer.getGridSubsets();
        Assert.assertTrue((boolean)gridsubsets.contains("EPSG:900913"));
        GridSubset subset = mbTilesLayer.getGridSubset("EPSG:900913");
        Assert.assertEquals((long)6L, (long)subset.getZoomStop());
        Assert.assertEquals((long)0L, (long)subset.getZoomStart());
        Assert.assertEquals((Object)ApplicationMime.mapboxVector, mbTilesLayer.getMimeTypes().get(0));
        ConveyorTile conveyorTile = new ConveyorTile(null, testLayer.getId(), subset.getName(), new long[]{4L, 4L, 3L}, (MimeType)ApplicationMime.mapboxVector, null, null, null);
        conveyorTile = testLayer.getTile(conveyorTile);
        VectorTileDecoder decoder = new VectorTileDecoder();
        byte[] byteArray = null;
        try (InputStream inputStream = conveyorTile.getBlob().getInputStream();){
            byteArray = ByteStreams.toByteArray((InputStream)inputStream);
        }
        VectorTileDecoder.FeatureIterable decoded = decoder.decode(byteArray);
        List features = decoded.asList();
        Assert.assertEquals((long)433L, (long)features.size());
        VectorTileDecoder.Feature feature = (VectorTileDecoder.Feature)features.get(0);
        Assert.assertEquals((Object)"manypoints_test", (Object)feature.getLayerName());
        Map attribs = feature.getAttributes();
        Set keys = attribs.keySet();
        HashSet<String> expectedKeys = new HashSet<String>(TEST_FIELDS);
        expectedKeys.removeAll(keys);
        Assert.assertTrue((boolean)expectedKeys.isEmpty());
        Assert.assertEquals((Object)3L, attribs.get("_zoom"));
        Assert.assertEquals((Object)4L, attribs.get("_row"));
        Assert.assertEquals((Object)4L, attribs.get("_col"));
        Assert.assertEquals((Object)25180626L, attribs.get("ID"));
        Assert.assertEquals((Object)37L, attribs.get("IntVal"));
        Assert.assertEquals((double)3.25, (double)((Float)attribs.get("Double3")).floatValue(), (double)1.0E-6);
    }

    @Test
    public void testTileJson() {
        MBTilesLayer mbTilesLayer = (MBTilesLayer)this.config.getLayer("testName").get();
        Assert.assertTrue((boolean)mbTilesLayer.supportsTileJSON());
        TileJSON tileJson = mbTilesLayer.getTileJSON();
        Assert.assertEquals((Object)"testName", (Object)tileJson.getName());
        Assert.assertEquals((long)0L, (long)tileJson.getMinZoom().intValue());
        Assert.assertEquals((long)6L, (long)tileJson.getMaxZoom().intValue());
        Assert.assertArrayEquals((double[])new double[]{38.221435, 38.85682, 41.495361, 40.763901}, (double[])tileJson.getBounds(), (double)1.0E-6);
        Assert.assertArrayEquals((double[])new double[]{41.495361, 38.85682, 6.0}, (double[])tileJson.getCenter(), (double)1.0E-6);
        List layers = tileJson.getLayers();
        Assert.assertEquals((long)1L, (long)layers.size());
        VectorLayerMetadata pointLayer = (VectorLayerMetadata)layers.get(0);
        Assert.assertEquals((Object)"manypoints_test", (Object)pointLayer.getId());
        Assert.assertEquals((long)0L, (long)pointLayer.getMinZoom().intValue());
        Assert.assertEquals((long)6L, (long)pointLayer.getMaxZoom().intValue());
        Map fields = pointLayer.getFields();
        Set keys = fields.keySet();
        for (String key : TEST_FIELDS) {
            Assert.assertEquals((Object)"Number", fields.get(key));
        }
        keys.removeAll(TEST_FIELDS);
        Assert.assertTrue((boolean)keys.isEmpty());
    }

    @Test
    public void testOutsideRange() throws GeoWebCacheException, IOException {
        MBTilesLayer testLayer = (MBTilesLayer)this.config.getLayer("testName").get();
        ConveyorTile conveyorTile = new ConveyorTile(null, testLayer.getId(), "EPSG:900913", new long[]{38L, 42L, 6L}, (MimeType)ApplicationMime.mapboxVector, null, null, null);
        this.exception.expect(OutsideCoverageException.class);
        this.exception.expectMessage("Coverage [minx,miny,maxx,maxy] is [38, 39, 39, 39, 6], index [x,y,z] is [38, 42, 6]");
        testLayer.getTile(conveyorTile);
    }

    @Test
    public void testEmptyTile() throws GeoWebCacheException, IOException {
        try {
            MBTilesLayer testLayer = (MBTilesLayer)this.config.getLayer("testName").get();
            ConveyorTile conveyorTile = new ConveyorTile(null, testLayer.getId(), "EPSG:900913", new long[]{38L, 39L, 6L}, (MimeType)ApplicationMime.mapboxVector, null, null, null);
            testLayer.getTile(conveyorTile);
        }
        catch (EmptyTileException e) {
            Assert.assertEquals((Object)ApplicationMime.mapboxVector, (Object)e.getMime());
        }
    }
}

