/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.mbtiles.layer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.mbtiles.MBTilesFile;
import org.geotools.mbtiles.MBTilesMetadata;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.layer.meta.TileJSON;
import org.geowebcache.layer.meta.VectorLayerMetadata;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class MBTilesInfo {
    private static Logger log = Logging.getLogger((String)MBTilesInfo.class.getName());
    private static final CoordinateReferenceSystem WGS_84;
    private static final BoundingBox WORLD_MERCATOR_WGS_84_BOUNDS;
    private MBTilesMetadata metadata;
    private BoundingBox bounds;
    private BoundingBox wgs84Bounds;
    private final MBTilesMetadata.t_format format;
    private int minZoom;
    private int maxZoom;
    private String metadataName;

    public MBTilesMetadata.t_format getFormat() {
        return this.format;
    }

    public int getMinZoom() {
        return this.minZoom;
    }

    public int getMaxZoom() {
        return this.maxZoom;
    }

    public BoundingBox getBounds() {
        return this.bounds;
    }

    public String getMetadataName() {
        return this.metadataName;
    }

    public MBTilesInfo(MBTilesFile file) throws IOException {
        this.metadata = file.loadMetaData();
        this.metadataName = this.metadata.getName();
        this.format = this.metadata.getFormat();
        this.minZoom = this.metadata.getMinZoom();
        this.maxZoom = this.metadata.getMaxZoom();
        Envelope env = this.metadata.getBounds();
        ReferencedEnvelope envelope = null;
        if (env != null) {
            try {
                this.wgs84Bounds = this.getBBoxFromEnvelope(env);
                envelope = ReferencedEnvelope.create((Envelope)env, (CoordinateReferenceSystem)WGS_84).transform(MBTilesFile.SPHERICAL_MERCATOR, true);
            }
            catch (FactoryException | TransformException e) {
                throw new IllegalArgumentException("Exception occurred while transforming the bound of: " + file.getFile().getAbsolutePath(), e);
            }
        } else {
            if (log.isLoggable(Level.WARNING)) {
                log.warning("Provided MBTile has a Null Envelope: " + file.getFile().getAbsolutePath() + ". Using full GridSet extent ");
            }
            envelope = MBTilesFile.WORLD_ENVELOPE;
            this.wgs84Bounds = WORLD_MERCATOR_WGS_84_BOUNDS;
        }
        this.bounds = this.getBBoxFromEnvelope((Envelope)envelope);
    }

    private BoundingBox getBBoxFromEnvelope(Envelope envelope) {
        BoundingBox bbox = null;
        if (envelope != null) {
            bbox = new BoundingBox(envelope.getMinimum(0), envelope.getMinimum(1), envelope.getMaximum(0), envelope.getMaximum(1));
        }
        return bbox;
    }

    public void decorateTileJSON(TileJSON tileJSON) {
        tileJSON.setMinZoom(Integer.valueOf(this.minZoom));
        tileJSON.setMaxZoom(Integer.valueOf(this.maxZoom));
        tileJSON.setBounds(new double[]{this.wgs84Bounds.getMinX(), this.wgs84Bounds.getMinY(), this.wgs84Bounds.getMaxX(), this.wgs84Bounds.getMaxY()});
        if (this.metadata != null) {
            String description = this.metadata.getDescription();
            if (description != null) {
                tileJSON.setDescription(description);
            }
            tileJSON.setCenter(this.metadata.getCenter());
            tileJSON.setAttribution(this.metadata.getAttribution());
            String json = this.metadata.getJson();
            int index = -1;
            if (json != null && (index = json.indexOf("[")) > 0) {
                json = json.substring(index, json.length() - 1).trim();
                ObjectMapper mapper = new ObjectMapper();
                List layers = null;
                try {
                    layers = (List)mapper.readValue(json, (TypeReference)new TypeReference<List<VectorLayerMetadata>>(){});
                }
                catch (JsonProcessingException e) {
                    throw new IllegalArgumentException("Exception occurred while parsing the layers metadata. " + String.valueOf((Object)e));
                }
                tileJSON.setLayers(layers);
            }
        }
    }

    static {
        try {
            WGS_84 = CRS.decode((String)"EPSG:4326", (boolean)true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        WORLD_MERCATOR_WGS_84_BOUNDS = new BoundingBox(-180.0, -85.0, 180.0, 85.0);
    }
}

