/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.mbtiles.layer;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.geotools.mbtiles.MBTilesFile;
import org.geotools.mbtiles.MBTilesMetadata;
import org.geotools.mbtiles.MBTilesTile;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.GridSubsetFactory;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.AbstractTileLayer;
import org.geowebcache.layer.EmptyTileException;
import org.geowebcache.layer.ExpirationRule;
import org.geowebcache.layer.TileJSONProvider;
import org.geowebcache.layer.meta.TileJSON;
import org.geowebcache.mbtiles.layer.MBTilesInfo;
import org.geowebcache.mime.ApplicationMime;
import org.geowebcache.mime.ImageMime;
import org.geowebcache.mime.MimeType;

public class MBTilesLayer
extends AbstractTileLayer
implements TileJSONProvider {
    private static final String UNZIP_CONTENT_KEY = "gwc.mbtiles.pbf.unzip.debug";
    private static final boolean UNZIP_CONTENT = Boolean.valueOf(System.getProperty("gwc.mbtiles.pbf.unzip.debug", "true"));
    private static final int TILE_SIZE_256 = 256;
    private static final int TILE_SIZE_512 = 512;
    private static final int DEFAULT_TILE_SIZE = 256;
    private static final Logger log = Logging.getLogger((String)MBTilesLayer.class.getName());
    private Boolean enabled;
    private File tilesPath;
    private int tileSize = 256;
    private transient MBTilesInfo tilesInfo;
    private transient BoundingBox layerBounds;
    private MimeType mimeType;
    private MBTilesFile mbTilesFile;
    private boolean vectorTiles;

    @VisibleForTesting
    MBTilesLayer(String name) {
        this.name = name;
    }

    public String getBlobStoreId() {
        return null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public File getTilesPath() {
        return this.tilesPath;
    }

    public void setTilesPath(File tilesPath) {
        this.tilesPath = tilesPath;
    }

    public int getTileSize() {
        return this.tileSize;
    }

    public void setTileSize(int tileSize) {
        this.tileSize = tileSize;
    }

    public boolean isVectorTiles() {
        return this.vectorTiles;
    }

    protected boolean initializeInternal(GridSetBroker gridSetBroker) {
        if (this.enabled == null) {
            this.enabled = true;
        }
        String specifiedName = this.getName();
        if (!(this.tilesPath == null || this.tilesPath.exists() && this.tilesPath.canRead())) {
            throw new IllegalStateException("tilesPath property for this layer " + (specifiedName != null ? specifiedName : "") + " is set to '" + String.valueOf(this.tilesPath) + "' but the file either does not exist or is not readable");
        }
        try {
            this.mbTilesFile = new MBTilesFile(this.tilesPath);
            this.tilesInfo = new MBTilesInfo(this.mbTilesFile);
            this.layerBounds = this.tilesInfo.getBounds();
            if (StringUtils.isEmpty((CharSequence)specifiedName)) {
                this.name = this.tilesInfo.getMetadataName();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to open the Provided MBTile: " + String.valueOf(this.tilesPath));
        }
        this.subSets = this.createGridSubsets(gridSetBroker);
        this.formats = this.loadMimeTypes();
        return true;
    }

    private List<MimeType> loadMimeTypes() {
        MBTilesMetadata.t_format metadataFormat = this.tilesInfo.getFormat();
        switch (metadataFormat) {
            case PNG: {
                this.mimeType = ImageMime.png;
                break;
            }
            case JPEG: 
            case JPG: {
                this.mimeType = ImageMime.jpeg;
                break;
            }
            case PBF: {
                this.mimeType = ApplicationMime.mapboxVector;
                this.vectorTiles = true;
            }
        }
        return Collections.singletonList(this.mimeType);
    }

    private HashMap<String, GridSubset> createGridSubsets(GridSetBroker gridSetBroker) {
        GridSet gridSet;
        DefaultGridsets defaultGridSet = new DefaultGridsets(true, true);
        if (this.tileSize <= 0) {
            this.tileSize = 256;
        }
        switch (this.tileSize) {
            case 256: {
                gridSet = defaultGridSet.worldEpsg3857();
                break;
            }
            case 512: {
                gridSet = defaultGridSet.worldEpsg3857x2();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported tileSize: " + this.tileSize);
            }
        }
        Integer minZoom = this.tilesInfo.getMinZoom();
        Integer maxZoom = this.tilesInfo.getMaxZoom();
        GridSubset subSet = GridSubsetFactory.createGridSubSet((GridSet)gridSet, (BoundingBox)this.layerBounds, (Integer)minZoom, (Integer)maxZoom);
        HashMap<String, GridSubset> subsets = new HashMap<String, GridSubset>();
        subsets.put(gridSet.getName(), subSet);
        return subsets;
    }

    public ConveyorTile getTile(ConveyorTile tile) throws IOException, GeoWebCacheException {
        long[] tileIndex = tile.getTileIndex();
        String tileGridSetId = tile.getGridSetId();
        GridSubset gridSubset = this.getGridSubset(tileGridSetId);
        gridSubset.checkCoverage(tileIndex);
        int zl = (int)tileIndex[2];
        int row = (int)tileIndex[1];
        int column = (int)tileIndex[0];
        MBTilesTile loadedTile = this.mbTilesFile.loadTile((long)zl, (long)column, (long)row);
        byte[] content = loadedTile.getData();
        if (content != null) {
            if (this.tilesInfo.getFormat() == MBTilesMetadata.t_format.PBF) {
                content = this.getPbfFromTile(content);
            }
        } else {
            tile.setCacheResult(Conveyor.CacheResult.MISS);
            throw new EmptyTileException(this.getLayerMime());
        }
        tile.setBlob((Resource)new ByteArrayResource(content));
        tile.setCacheResult(Conveyor.CacheResult.HIT);
        this.saveExpirationInformation((int)(tile.getExpiresHeader() / 1000L));
        return tile;
    }

    private MimeType getLayerMime() {
        switch (this.tilesInfo.getFormat()) {
            case PNG: {
                return ImageMime.png;
            }
            case JPEG: 
            case JPG: {
                return ImageMime.jpeg;
            }
            case PBF: {
                return ApplicationMime.mapboxVector;
            }
        }
        return null;
    }

    private byte[] getPbfFromTile(byte[] raw) throws IOException {
        if (!UNZIP_CONTENT) {
            return raw;
        }
        byte[] byteArray = raw;
        if (raw != null && raw.length >= 2 && raw[0] == 31 && raw[1] == -117) {
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();
                 ByteArrayInputStream bin = new ByteArrayInputStream(raw);
                 GZIPInputStream in = new GZIPInputStream(bin);){
                int noRead;
                byte[] buffer = new byte[1024];
                while ((noRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, noRead);
                }
                byteArray = out.toByteArray();
            }
        }
        return byteArray;
    }

    protected void saveExpirationInformation(int backendExpire) {
        block12: {
            this.saveExpirationHeaders = false;
            try {
                if (this.getExpireCache(0) == -4) {
                    if (backendExpire == -1) {
                        this.expireCacheList.set(0, new ExpirationRule(0, 7200));
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Layer profile wants MaxAge from backend, but backend does not provide this. Setting to 7200 seconds.");
                        }
                    } else {
                        this.expireCacheList.set(backendExpire, new ExpirationRule(0, 7200));
                    }
                    if (log.isLoggable(Level.FINER)) {
                        log.finer("Setting expireCache to: " + this.expireCache);
                    }
                }
                if (this.getExpireCache(0) == -4) {
                    if (backendExpire == -1) {
                        this.expireClientsList.set(0, new ExpirationRule(0, 7200));
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.SEVERE, "Layer profile wants MaxAge from backend, but backend does not provide this. Setting to 7200 seconds.");
                        }
                    } else {
                        this.expireClientsList.set(0, new ExpirationRule(0, backendExpire));
                        if (log.isLoggable(Level.FINER)) {
                            log.finer("Setting expireClients to: " + this.expireClients);
                        }
                    }
                }
            }
            catch (Exception e) {
                if (!log.isLoggable(Level.FINE)) break block12;
                log.log(Level.FINE, e.getMessage(), e);
            }
        }
    }

    public ConveyorTile getNoncachedTile(ConveyorTile tile) throws GeoWebCacheException {
        throw new UnsupportedOperationException();
    }

    public void seedTile(ConveyorTile tile, boolean tryCache) throws GeoWebCacheException, IOException {
        throw new UnsupportedOperationException();
    }

    public ConveyorTile doNonMetatilingRequest(ConveyorTile tile) throws GeoWebCacheException {
        throw new UnsupportedOperationException();
    }

    public String getStyles() {
        return null;
    }

    public void setExpirationHeader(HttpServletResponse response, int zoomLevel) {
    }

    public boolean supportsTileJSON() {
        return true;
    }

    public TileJSON getTileJSON() {
        TileJSON tileJSON = new TileJSON();
        tileJSON.setName(this.name);
        if (this.metaInformation != null) {
            tileJSON.setDescription(this.metaInformation.getDescription());
        }
        this.tilesInfo.decorateTileJSON(tileJSON);
        return tileJSON;
    }
}

