/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.reload;

import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.MockGridSetConfiguration;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSetFactory;
import org.geowebcache.grid.SRS;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.rest.controller.ReloadController;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(value={"file*:/webapp/WEB-INF/web.xml", "file*:/webapp/WEB-INF/geowebcache-servlet.xml"})
public class ReloadTest {
    private MockMvc mockMvc;
    ReloadController reload;
    TileLayerDispatcher tld;

    @Before
    public void setup() throws GeoWebCacheException {
        BoundingBox extent = new BoundingBox(0.0, 0.0, 1.0E7, 1.0E7);
        boolean alignTopLeft = false;
        int levels = 10;
        Double metersPerUnit = 1.0;
        double pixelSize = 0.0028;
        int tileWidth = 256;
        int tileHeight = 256;
        boolean yCoordinateFirst = false;
        GridSet gridSet = GridSetFactory.createGridSet((String)"EPSG:3395", (SRS)SRS.getSRS((String)"EPSG:3395"), (BoundingBox)extent, (boolean)alignTopLeft, (int)levels, (Double)metersPerUnit, (double)pixelSize, (int)tileWidth, (int)tileHeight, (boolean)yCoordinateFirst);
        GridSetBroker gridSetBroker = new GridSetBroker(MockGridSetConfiguration.withDefaults((GridSet[])new GridSet[]{gridSet}));
        this.tld = new TileLayerDispatcher(gridSetBroker, null);
        this.reload = new ReloadController();
        this.reload.setTileLayerDispatcher(this.tld);
        this.mockMvc = MockMvcBuilders.standaloneSetup((Object[])new Object[]{this.reload}).build();
    }

    @Test
    public void testReloadConfiguration() throws Exception {
        String content = "reload_configuration=1";
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/rest/reload", (Object[])new Object[0]).contentType("application/x-www-form-urlencoded").content(content).contextPath("")).andExpect(MockMvcResultMatchers.status().is2xxSuccessful());
    }
}

