/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.service;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections4.iterators.EmptyIterator;
import org.easymock.EasyMock;
import org.geowebcache.MockWepAppContextRule;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.filter.parameters.RegexParameterFilter;
import org.geowebcache.filter.parameters.StringParameterFilter;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.mime.ImageMime;
import org.geowebcache.rest.service.FormService;
import org.geowebcache.seed.TileBreeder;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class FormServiceTest {
    FormService service;
    public MockWepAppContextRule context = new MockWepAppContextRule();
    private TileBreeder breeder;

    @Before
    public void setUp() throws Exception {
        this.service = new FormService();
        this.breeder = (TileBreeder)EasyMock.createNiceMock((String)"breeder", TileBreeder.class);
        this.service.setTileBreeder(this.breeder);
    }

    @Test
    public void testEscaping() throws Exception {
        String unescapedLayer = "layer\"><";
        String escapedLayer = "layer&quot;&gt;&lt;";
        String unescapedString = "string\"><";
        String escapedString = "string&quot;&gt;&lt;";
        String unescapedRegex = "regex\"><";
        String escapedRegex = "regex&quot;&gt;&lt;";
        StringParameterFilter stringFilter = new StringParameterFilter();
        stringFilter.setKey(unescapedString);
        RegexParameterFilter regexFilter = new RegexParameterFilter();
        regexFilter.setKey(unescapedRegex);
        List<ParameterFilter> filters = Arrays.asList(stringFilter, regexFilter);
        TileLayer tl = (TileLayer)EasyMock.createMock((String)"tl", TileLayer.class);
        EasyMock.expect((Object)this.breeder.findTileLayer(unescapedLayer)).andReturn((Object)tl);
        EasyMock.expect((Object)tl.getName()).andStubReturn((Object)unescapedLayer);
        EasyMock.expect((Object)this.breeder.getRunningAndPendingTasks()).andReturn(Collections.emptyIterator()).times(2);
        EasyMock.expect((Object)tl.getGridSubsets()).andReturn(Collections.emptySet()).times(4);
        EasyMock.expect((Object)tl.getMimeTypes()).andReturn(Collections.emptyList());
        EasyMock.expect((Object)tl.getParameterFilters()).andReturn(filters);
        EasyMock.replay((Object[])new Object[]{tl, this.breeder});
        ResponseEntity response = this.service.handleGet(null, unescapedLayer);
        EasyMock.verify((Object[])new Object[]{tl, this.breeder});
        Assert.assertEquals((Object)HttpStatus.OK, (Object)response.getStatusCode());
        String body = (String)response.getBody();
        Assert.assertThat((Object)body, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)unescapedLayer)));
        Assert.assertThat((Object)body, (Matcher)Matchers.containsString((String)escapedLayer));
        Assert.assertThat((Object)body, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)unescapedString)));
        Assert.assertThat((Object)body, (Matcher)Matchers.containsString((String)escapedString));
        Assert.assertThat((Object)body, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)unescapedRegex)));
        Assert.assertThat((Object)body, (Matcher)Matchers.containsString((String)escapedRegex));
    }

    @Test
    public void testKill() {
        HashMap<String, String> form = new HashMap<String, String>();
        form.put("kill_thread", "1");
        form.put("thread_id", "2");
        TileLayer tl = (TileLayer)EasyMock.createMock((String)"tl", TileLayer.class);
        EasyMock.expect((Object)this.breeder.terminateGWCTask(2L)).andReturn((Object)true);
        EasyMock.expect((Object)tl.getName()).andStubReturn((Object)"testLayer");
        EasyMock.replay((Object[])new Object[]{tl, this.breeder});
        ResponseEntity response = this.service.handleKillThreadPost(form, tl);
        EasyMock.verify((Object[])new Object[]{tl, this.breeder});
        Assert.assertThat((Object)response, (Matcher)Matchers.hasProperty((String)"statusCode", (Matcher)Matchers.equalTo((Object)HttpStatus.OK)));
        Assert.assertThat((Object)response, (Matcher)Matchers.hasProperty((String)"body", (Matcher)Matchers.containsString((String)"Requested to terminate task 2")));
    }

    @Test
    public void testThreads() {
        EasyMock.expect((Object)this.breeder.getPendingTasks()).andReturn((Object)EmptyIterator.emptyIterator()).anyTimes();
        EasyMock.expect((Object)this.breeder.getRunningAndPendingTasks()).andReturn((Object)EmptyIterator.emptyIterator()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.breeder});
        HashSet<String> layer1GridSet = new HashSet<String>(Arrays.asList("test_grid1"));
        GridSubset gs = (GridSubset)EasyMock.createMock(GridSubset.class);
        EasyMock.expect((Object)gs.getOriginalExtent()).andReturn((Object)new BoundingBox(0.0, 0.0, 10.0, 10.0)).anyTimes();
        EasyMock.expect((Object)gs.getZoomStart()).andReturn((Object)0).anyTimes();
        EasyMock.expect((Object)gs.getZoomStop()).andReturn((Object)20).anyTimes();
        EasyMock.replay((Object[])new Object[]{gs});
        TileLayer tl1 = (TileLayer)EasyMock.createMock(TileLayer.class);
        EasyMock.expect((Object)tl1.getGridSubsets()).andReturn(layer1GridSet).anyTimes();
        EasyMock.expect((Object)tl1.getGridSubset("test_grid1")).andReturn((Object)gs).anyTimes();
        EasyMock.expect((Object)tl1.getMimeTypes()).andReturn(Arrays.asList(ImageMime.png));
        EasyMock.expect((Object)tl1.getParameterFilters()).andReturn(Collections.emptyList()).anyTimes();
        EasyMock.expect((Object)tl1.getName()).andStubReturn((Object)"testLayer");
        EasyMock.replay((Object[])new Object[]{tl1});
        String html = this.service.makeFormPage(tl1, false);
        Assert.assertTrue((boolean)html.contains("<select name=\"threadCount\">\n<option value=\"01\">01</option>\n<option value=\"02\">02</option>\n<option value=\"03\">03</option>\n<option value=\"04\">04</option>\n<option value=\"05\">05</option>\n<option value=\"06\">06</option>\n<option value=\"07\">07</option>\n<option value=\"08\">08</option>\n<option value=\"09\">09</option>\n<option value=\"10\">10</option>\n<option value=\"11\">11</option>\n<option value=\"12\">12</option>\n<option value=\"13\">13</option>\n<option value=\"14\">14</option>\n<option value=\"15\">15</option>"));
    }
}

