/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.statistics;

import java.util.Collections;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.ConfigurationResourceProvider;
import org.geowebcache.config.DefaultGridsets;
import org.geowebcache.config.MockConfigurationResourceProvider;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.rest.controller.MemoryCacheController;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.blobstore.memory.CacheConfiguration;
import org.geowebcache.storage.blobstore.memory.CacheProvider;
import org.geowebcache.storage.blobstore.memory.MemoryBlobStore;
import org.geowebcache.storage.blobstore.memory.NullBlobStore;
import org.geowebcache.storage.blobstore.memory.guava.GuavaCacheProvider;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(value={"file*:/webapp/WEB-INF/web.xml", "file*:/webapp/WEB-INF/geowebcache-servlet.xml"})
public class MemoryCacheControllerTest {
    private MockMvc mockMvc;
    MemoryCacheController mcc;

    @Before
    public void setup() throws GeoWebCacheException {
        GridSetBroker gridSetBroker = new GridSetBroker(Collections.singletonList(new DefaultGridsets(false, false)));
        XMLConfiguration xmlConfig = this.loadXMLConfig();
        xmlConfig.setGridSetBroker(gridSetBroker);
        xmlConfig.afterPropertiesSet();
        this.mcc = new MemoryCacheController(null);
        this.mockMvc = MockMvcBuilders.standaloneSetup((Object[])new Object[]{this.mcc}).setUseSuffixPatternMatch(true).build();
    }

    @Test
    public void testStatisticsXml() throws Exception {
        GuavaCacheProvider cache = new GuavaCacheProvider(new CacheConfiguration());
        NullBlobStore nbs = new NullBlobStore();
        cache.clear();
        MemoryBlobStore mbs = new MemoryBlobStore();
        mbs.setStore((BlobStore)nbs);
        this.mcc.setBlobStore((BlobStore)mbs);
        mbs.setCacheProvider((CacheProvider)cache);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/statistics", (Object[])new Object[0]).accept(new String[]{"application/xml"}).contextPath("")).andExpect(MockMvcResultMatchers.status().is2xxSuccessful());
    }

    @Test
    public void testStatisticsJson() throws Exception {
        GuavaCacheProvider cache = new GuavaCacheProvider(new CacheConfiguration());
        NullBlobStore nbs = new NullBlobStore();
        cache.clear();
        MemoryBlobStore mbs = new MemoryBlobStore();
        mbs.setStore((BlobStore)nbs);
        this.mcc.setBlobStore((BlobStore)mbs);
        mbs.setCacheProvider((CacheProvider)cache);
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/rest/statistics", (Object[])new Object[0]).accept(new String[]{"application/json"}).contextPath("")).andExpect(MockMvcResultMatchers.status().is2xxSuccessful());
    }

    private XMLConfiguration loadXMLConfig() {
        XMLConfiguration xmlConfig = null;
        try {
            xmlConfig = new XMLConfiguration(null, (ConfigurationResourceProvider)new MockConfigurationResourceProvider(() -> XMLConfiguration.class.getResourceAsStream("geowebcache_125.xml")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return xmlConfig;
    }
}

