/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.converter;

import java.io.IOException;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.GeoWebCacheExtensions;
import org.geowebcache.config.ServerConfiguration;
import org.geowebcache.config.meta.ServiceInformation;
import org.geowebcache.locks.LockProvider;
import org.geowebcache.locks.MemoryLockProvider;

public class ServerConfigurationPOJO
implements ServerConfiguration {
    private ServiceInformation serviceInformation;
    private Boolean runtimeStatsEnabled;
    private String lockProvider;
    private Boolean fullWMS;
    private Boolean wmtsCiteCompliant;
    private Integer backendTimeout;
    private Boolean cacheBypassAllowed;
    private final String version;
    private final String identifier;
    private final String location;

    public ServerConfigurationPOJO(ServerConfiguration template) throws IOException {
        this.serviceInformation = template.getServiceInformation();
        this.runtimeStatsEnabled = template.isRuntimeStatsEnabled();
        this.setLockProvider(template.getLockProvider());
        this.fullWMS = template.isFullWMS();
        this.wmtsCiteCompliant = template.isWmtsCiteCompliant();
        this.backendTimeout = template.getBackendTimeout();
        this.cacheBypassAllowed = template.isCacheBypassAllowed();
        this.version = template.getVersion();
        this.identifier = template.getIdentifier();
        this.location = template.getLocation();
    }

    public void apply(ServerConfiguration config) throws IOException {
        if (this.getServiceInformation() != null) {
            config.setServiceInformation(this.getServiceInformation());
        }
        if (this.isRuntimeStatsEnabled() != null) {
            config.setRuntimeStatsEnabled(this.isRuntimeStatsEnabled());
        }
        if (this.getLockProvider() != null) {
            config.setLockProvider(this.getLockProvider());
        }
        if (this.isFullWMS() != null) {
            config.setFullWMS(this.isFullWMS());
        }
        if (this.isWmtsCiteCompliant() != null) {
            config.setWmtsCiteCompliant(this.isWmtsCiteCompliant());
        }
        if (this.getBackendTimeout() != null) {
            config.setBackendTimeout(this.getBackendTimeout());
        }
        if (this.isCacheBypassAllowed() != null) {
            config.setCacheBypassAllowed(this.isCacheBypassAllowed());
        }
    }

    public ServiceInformation getServiceInformation() {
        return this.serviceInformation;
    }

    public void setServiceInformation(ServiceInformation serviceInfo) throws IOException {
        this.serviceInformation = serviceInfo;
    }

    public Boolean isRuntimeStatsEnabled() {
        return this.runtimeStatsEnabled;
    }

    public void setRuntimeStatsEnabled(Boolean isEnabled) throws IOException {
        this.runtimeStatsEnabled = isEnabled;
    }

    public LockProvider getLockProvider() {
        LockProvider lockProviderBean;
        if (this.lockProvider != null && (lockProviderBean = (LockProvider)GeoWebCacheExtensions.bean((String)this.lockProvider)) != null) {
            return lockProviderBean;
        }
        return new MemoryLockProvider();
    }

    public void setLockProvider(LockProvider lockProvider) throws IOException {
        this.lockProvider = null;
        if (lockProvider != null) {
            String[] lockProviderNames;
            for (String beanName : lockProviderNames = GeoWebCacheExtensions.getBeansNamesOrderedByPriority(LockProvider.class)) {
                if (!lockProvider.equals(GeoWebCacheExtensions.bean((String)beanName))) continue;
                this.lockProvider = beanName;
            }
        }
    }

    public Boolean isFullWMS() {
        return this.fullWMS;
    }

    public void setFullWMS(Boolean fullWMS) throws IOException {
        this.fullWMS = fullWMS;
    }

    public Boolean isWmtsCiteCompliant() {
        return this.wmtsCiteCompliant;
    }

    public void setWmtsCiteCompliant(Boolean wmtsCiteStrictCompliant) throws IOException {
        this.wmtsCiteCompliant = wmtsCiteStrictCompliant;
    }

    public Integer getBackendTimeout() {
        return this.backendTimeout;
    }

    public void setBackendTimeout(Integer backendTimeout) throws IOException {
        this.backendTimeout = backendTimeout;
    }

    public Boolean isCacheBypassAllowed() {
        return this.cacheBypassAllowed;
    }

    public void setCacheBypassAllowed(Boolean cacheBypassAllowed) throws IOException {
        this.cacheBypassAllowed = cacheBypassAllowed;
    }

    public String getVersion() {
        return this.version;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getLocation() {
        return this.location;
    }

    public void reinitialize() throws GeoWebCacheException {
        throw new UnsupportedOperationException("reinitialize() not supported for ServerConfigurationPOJO");
    }

    public void deinitialize() throws Exception {
        throw new UnsupportedOperationException("deinitialize() not supported for ServerConfigurationPOJO");
    }

    public void afterPropertiesSet() throws Exception {
        throw new UnsupportedOperationException("afterPropertiesSet() not supported for ServerConfigurationPOJO");
    }
}

