/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.rest.service;

import com.google.common.base.Splitter;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.copy.HierarchicalStreamCopier;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import com.thoughtworks.xstream.io.json.JsonHierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.ContextualConfigurationProvider;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.io.GeoWebCacheXStream;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.rest.exception.RestException;
import org.geowebcache.seed.GWCTask;
import org.geowebcache.seed.SeedRequest;
import org.geowebcache.seed.TileBreeder;
import org.geowebcache.util.ApplicationContextProvider;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.context.WebApplicationContext;

@Service
public class SeedService {
    static final Logger LOG = Logging.getLogger((String)SeedService.class.getName());
    @Autowired
    TileBreeder seeder;
    private final WebApplicationContext context;

    @Autowired
    public SeedService(ApplicationContextProvider appCtx) {
        this.context = appCtx.getApplicationContext();
    }

    public ResponseEntity<?> getRunningTasks(HttpServletRequest request) {
        try {
            GeoWebCacheXStream xs = new GeoWebCacheXStream((HierarchicalStreamDriver)new JsonHierarchicalStreamDriver());
            long[][] list = this.seeder.getStatusList();
            JSONObject obj = new JSONObject(xs.toXML((Object)list));
            return this.constructResponse(MediaType.APPLICATION_JSON, obj.toString(), HttpStatus.OK);
        }
        catch (JSONException jse) {
            return this.constructResponse(MediaType.TEXT_PLAIN, "error", HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity<?> getRunningLayerTasks(String layer) {
        try {
            long[][] list;
            GeoWebCacheXStream xs = new GeoWebCacheXStream((HierarchicalStreamDriver)new JsonHierarchicalStreamDriver());
            try {
                list = this.findTileLayer(layer);
            }
            catch (GeoWebCacheException e) {
                return this.constructResponse(MediaType.TEXT_PLAIN, e.getMessage(), HttpStatus.BAD_REQUEST);
            }
            JSONObject obj = new JSONObject(xs.toXML((Object)list));
            return this.constructResponse(MediaType.APPLICATION_JSON, obj.toString(), HttpStatus.OK);
        }
        catch (JSONException jse) {
            LOG.log(Level.SEVERE, jse.getMessage(), jse);
            return this.constructResponse(MediaType.TEXT_PLAIN, "error", HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity<?> getRunningLayerTasksXml(String layer) {
        long[][] list;
        GeoWebCacheXStream xs = new GeoWebCacheXStream();
        try {
            list = this.findTileLayer(layer);
        }
        catch (GeoWebCacheException e) {
            return this.constructResponse(MediaType.TEXT_PLAIN, e.getMessage(), HttpStatus.BAD_REQUEST);
        }
        return this.constructResponse(MediaType.APPLICATION_XML, xs.toXML((Object)list), HttpStatus.OK);
    }

    private ResponseEntity<?> constructResponse(MediaType mediaType, String message, HttpStatus status) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(mediaType);
        return new ResponseEntity((Object)message, (MultiValueMap)headers, status);
    }

    private long[][] findTileLayer(String layer) throws GeoWebCacheException {
        if (null == layer) {
            return this.seeder.getStatusList();
        }
        this.seeder.findTileLayer(layer);
        return this.seeder.getStatusList(layer);
    }

    public String handleKillAllThreads(HttpServletRequest request, String layer) {
        TileLayer tl;
        if (layer != null) {
            try {
                tl = this.seeder.findTileLayer(layer);
            }
            catch (GeoWebCacheException e) {
                throw new RestException(e.getMessage(), HttpStatus.BAD_REQUEST);
            }
        } else {
            tl = null;
        }
        try {
            boolean allLayers;
            StringBuilder doc = new StringBuilder();
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)request.getInputStream(), (Writer)writer, (String)"UTF-8");
            String body = writer.toString();
            Map<String, String> commandMap = this.splitToMap(body);
            boolean bl = allLayers = tl == null;
            if (commandMap.containsKey("kill_all")) {
                Iterator tasks;
                String killCode = commandMap.get("kill_all");
                if ("1".equals(killCode) || "running".equalsIgnoreCase(killCode)) {
                    killCode = "running";
                    tasks = this.seeder.getRunningTasks();
                } else if ("pending".equalsIgnoreCase(killCode)) {
                    tasks = this.seeder.getPendingTasks();
                } else if ("all".equalsIgnoreCase(killCode)) {
                    tasks = this.seeder.getRunningAndPendingTasks();
                } else {
                    throw new RestException("Unknown kill_all code: '" + killCode + "'. One of all|running|pending is expected.", HttpStatus.BAD_REQUEST);
                }
                LinkedList<GWCTask> terminatedTasks = new LinkedList<GWCTask>();
                LinkedList<GWCTask> nonTerminatedTasks = new LinkedList<GWCTask>();
                while (tasks.hasNext()) {
                    GWCTask task = (GWCTask)tasks.next();
                    String layerName = task.getLayerName();
                    if (!allLayers && !tl.getName().equals(layerName)) continue;
                    long taskId = task.getTaskId();
                    boolean terminated = this.seeder.terminateGWCTask(taskId);
                    if (terminated) {
                        terminatedTasks.add(task);
                        continue;
                    }
                    nonTerminatedTasks.add(task);
                }
                doc.append("<p>Requested to terminate ").append(killCode).append(" tasks.");
                doc.append("Terminated tasks: <ul>");
                for (GWCTask t : terminatedTasks) {
                    doc.append("<li>").append(t).append("</li>");
                }
                doc.append("</ul>Tasks already finished: <ul>");
                for (GWCTask t : nonTerminatedTasks) {
                    doc.append("<li>").append(t).append("</li>");
                }
                if (tl != null) {
                    doc.append("</ul><p><a href=\"./" + tl.getName() + "\">Go back</a></p>\n");
                }
            }
            return doc.toString();
        }
        catch (IOException e) {
            return "error";
        }
    }

    public ResponseEntity<?> doSeeding(HttpServletRequest request, String layer, String extension, String body) {
        XStream xs = this.configXStream((XStream)new GeoWebCacheXStream((HierarchicalStreamDriver)new DomDriver()));
        Object obj = null;
        try {
            if (extension == null || extension.equalsIgnoreCase("xml")) {
                obj = xs.fromXML(body);
            } else if (extension.equalsIgnoreCase("json")) {
                obj = xs.fromXML(this.convertJson(body));
            } else {
                throw new RestException("Format extension unknown or not specified: " + extension, HttpStatus.BAD_REQUEST);
            }
            this.handleRequest(layer, obj);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.TEXT_PLAIN);
            return new ResponseEntity((MultiValueMap)headers, HttpStatus.OK);
        }
        catch (IOException e) {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.TEXT_PLAIN);
            return new ResponseEntity((MultiValueMap)headers, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    protected void handleRequest(String layerName, Object obj) {
        SeedRequest sr = (SeedRequest)obj;
        try {
            this.seeder.seed(layerName, sr);
        }
        catch (IllegalArgumentException e) {
            throw new RestException(e.getMessage(), HttpStatus.BAD_REQUEST);
        }
        catch (GeoWebCacheException e) {
            throw new RestException(e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    protected XStream configXStream(XStream xs) {
        return XMLConfiguration.getConfiguredXStreamWithContext((XStream)xs, (WebApplicationContext)this.context, (ContextualConfigurationProvider.Context)ContextualConfigurationProvider.Context.REST);
    }

    private Map<String, String> splitToMap(String data) {
        if (data.contains("&")) {
            return Splitter.on((String)"&").withKeyValueSeparator("=").split((CharSequence)data);
        }
        return Splitter.on((String)" ").withKeyValueSeparator("=").split((CharSequence)data);
    }

    protected String convertJson(String entityText) throws IOException {
        JettisonMappedXmlDriver driver = new JettisonMappedXmlDriver();
        try (StringReader reader = new StringReader(entityText);){
            String string;
            try (StringWriter writer = new StringWriter();){
                HierarchicalStreamReader hsr = driver.createReader((Reader)reader);
                new HierarchicalStreamCopier().copy(hsr, (HierarchicalStreamWriter)new PrettyPrintWriter((Writer)writer));
                string = writer.toString();
            }
            return string;
        }
    }
}

