/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.sqlite;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.geowebcache.mime.MimeType;
import org.geowebcache.sqlite.FileManager;
import org.geowebcache.sqlite.TestSupport;
import org.geowebcache.sqlite.Utils;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.TileRange;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public final class FileManagerTest
extends TestSupport {
    @Test
    public void testGetLayerAssociatedFilesWithMultipleLevels() throws Exception {
        String pathTemplate = Utils.buildPath((String[])new String[]{"tiles", "{format}", "{style}", "zoom-{z}", "{layer}", "ranges-{x}-{y}.sqlite"});
        File fileAsiaA = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"tiles", "png", "default", "zoom-10", "asia", "ranges-0-500.sqlite"}));
        File fileAsiaB = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"tiles", "png", "default", "zoom-11", "asia", "ranges-100-500.sqlite"}));
        File fileAsiaC = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"tiles", "png", "dark-borders", "zoom-10", "asia", "ranges-0-500.sqlite"}));
        File fileAsiaD = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"tiles", "jpeg", "dark-borders", "zoom-10", "asia", "ranges-0-500.sqlite"}));
        File fileAfricaA = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"tiles", "png", "default", "zoom-10", "africa", "ranges-0-500.sqlite"}));
        File fileAmericaA = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"tiles", "png", "dark-borders", "zoom-10", "america", "ranges-0-500.sqlite"}));
        File fileAmericaB = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"tiles", "jpeg", "dark-borders", "zoom-10", "america", "ranges-0-500.sqlite"}));
        File fileEuropeA = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"tiles", "gif", "dark-borders", "zoom-15", "europe", "ranges-4000-500.sqlite"}));
        FileManager fileManager = new FileManager(this.getRootDirectory(), pathTemplate, 500L, 500L);
        List asiaFiles = fileManager.getFiles("asia");
        Assert.assertThat((Object)asiaFiles, (Matcher)Matchers.containsInAnyOrder((Object[])new File[]{fileAsiaA, fileAsiaB, fileAsiaC, fileAsiaD}));
        List africaFiles = fileManager.getFiles("africa");
        Assert.assertThat((Object)africaFiles, (Matcher)Matchers.containsInAnyOrder((Object[])new File[]{fileAfricaA}));
        List americaFiles = fileManager.getFiles("america");
        Assert.assertThat((Object)americaFiles, (Matcher)Matchers.containsInAnyOrder((Object[])new File[]{fileAmericaA, fileAmericaB}));
        List europeFiles = fileManager.getFiles("europe");
        Assert.assertThat((Object)europeFiles, (Matcher)Matchers.containsInAnyOrder((Object[])new File[]{fileEuropeA}));
    }

    @Test
    public void testGetLayerAssociatedFilesWithNoLayer() throws Exception {
        String pathTemplate = Utils.buildPath((String[])new String[]{"tiles", "{z}", "tiles-{x}.sqlite"});
        File fileA = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"tiles", "10", "tiles-0.sqlite"}));
        File fileB = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"tiles", "10", "tiles-500.sqlite"}));
        File fileC = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"tiles", "11", "tiles-0.sqlite"}));
        File fileD = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"tiles", "11", "tiles-500.sqlite"}));
        FileManager fileManager = new FileManager(this.getRootDirectory(), pathTemplate, 1000L, 1000L);
        List filesA = fileManager.getFiles((String)null);
        Assert.assertThat((Object)filesA, (Matcher)Matchers.containsInAnyOrder((Object[])new File[]{fileA, fileB, fileC, fileD}));
        List filesB = fileManager.getFiles("something");
        Assert.assertThat((Object)filesB, (Matcher)Matchers.containsInAnyOrder((Object[])new File[]{fileA, fileB, fileC, fileD}));
    }

    @Test
    public void testLayerAssociatedFilesWithOnlyOneLevel() throws Exception {
        String pathTemplate = "{layer}.sqlite";
        File asiaFile = this.createFileInRootDir("asia.sqlite");
        File americaFile = this.createFileInRootDir("america.sqlite");
        File africaFile = this.createFileInRootDir("africa.sqlite");
        File australiaFile = this.createFileInRootDir("australia.sqlite");
        FileManager fileManager = new FileManager(this.getRootDirectory(), pathTemplate, 1000L, 1000L);
        List asiaFiles = fileManager.getFiles("asia");
        Assert.assertThat((Object)asiaFiles, (Matcher)Matchers.containsInAnyOrder((Object[])new File[]{asiaFile}));
        List americaFiles = fileManager.getFiles("america");
        Assert.assertThat((Object)americaFiles, (Matcher)Matchers.containsInAnyOrder((Object[])new File[]{americaFile}));
        List africaFiles = fileManager.getFiles("africa");
        Assert.assertThat((Object)africaFiles, (Matcher)Matchers.containsInAnyOrder((Object[])new File[]{africaFile}));
        List australiaFiles = fileManager.getFiles("australia");
        Assert.assertThat((Object)australiaFiles, (Matcher)Matchers.containsInAnyOrder((Object[])new File[]{australiaFile}));
    }

    @Test
    public void testGetGridSetAndLayerAssociatedFiles() throws Exception {
        String pathTemplate = Utils.buildPath((String[])new String[]{"tiles", "{grid}", "{format}", "{style}", "zoom-{z}", "{layer}", "ranges-{x}-{y}.sqlite"});
        File fileAsiaGrid1A = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"tiles", "grid1", "png", "default", "zoom-10", "asia", "ranges-0-500.sqlite"}));
        File fileAsiaGrid2B = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"tiles", "grid2", "png", "default", "zoom-11", "asia", "ranges-100-500.sqlite"}));
        File fileAsiaGrid3C = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"tiles", "grid3", "png", "dark-borders", "zoom-10", "asia", "ranges-0-500.sqlite"}));
        File fileAsiaGrid3D = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"tiles", "grid3", "jpeg", "dark-borders", "zoom-10", "asia", "ranges-0-500.sqlite"}));
        File fileAfricaGrid1A = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"tiles", "grid1", "png", "default", "zoom-10", "africa", "ranges-0-500.sqlite"}));
        File fileAmericaGrid1A = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"tiles", "grid1", "png", "dark-borders", "zoom-10", "america", "ranges-0-500.sqlite"}));
        File fileAmericaGrid2B = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"tiles", "grid2", "jpeg", "dark-borders", "zoom-10", "america", "ranges-0-500.sqlite"}));
        File fileEuropeGrid1A = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"tiles", "grid1", "gif", "dark-borders", "zoom-15", "europe", "ranges-4000-500.sqlite"}));
        FileManager fileManager = new FileManager(this.getRootDirectory(), pathTemplate, 500L, 500L);
        List asiaFilesGrid1 = fileManager.getFiles("asia", "grid1");
        Assert.assertThat((Object)asiaFilesGrid1, (Matcher)Matchers.containsInAnyOrder((Object[])new File[]{fileAsiaGrid1A}));
        List asiaFilesGrid2 = fileManager.getFiles("asia", "grid2");
        Assert.assertThat((Object)asiaFilesGrid2, (Matcher)Matchers.containsInAnyOrder((Object[])new File[]{fileAsiaGrid2B}));
        List asiaFilesGrid3 = fileManager.getFiles("asia", "grid3");
        Assert.assertThat((Object)asiaFilesGrid3, (Matcher)Matchers.containsInAnyOrder((Object[])new File[]{fileAsiaGrid3C, fileAsiaGrid3D}));
        List africaFilesGrid1 = fileManager.getFiles("africa", "grid1");
        Assert.assertThat((Object)africaFilesGrid1, (Matcher)Matchers.containsInAnyOrder((Object[])new File[]{fileAfricaGrid1A}));
        List americaFilesGrid1 = fileManager.getFiles("america", "grid1");
        Assert.assertThat((Object)americaFilesGrid1, (Matcher)Matchers.containsInAnyOrder((Object[])new File[]{fileAmericaGrid1A}));
        List americaFilesGrid2 = fileManager.getFiles("america", "grid2");
        Assert.assertThat((Object)americaFilesGrid2, (Matcher)Matchers.containsInAnyOrder((Object[])new File[]{fileAmericaGrid2B}));
        List europeFilesGrid1 = fileManager.getFiles("europe", "grid1");
        Assert.assertThat((Object)europeFilesGrid1, (Matcher)Matchers.containsInAnyOrder((Object[])new File[]{fileEuropeGrid1A}));
    }

    @Test
    public void testSimplePathTemplate() throws Exception {
        this.genericTestPath(Utils.buildPath((String[])new String[]{"tiles", "{grid}", "layers", "{layer}.sqlite"}), Utils.buildPath((String[])new String[]{"tiles", "wgs84", "layers", "europe.sqlite"}), null, null, "europe", "wgs84", null, new Utils.Tuple[0]);
    }

    @Test
    public void testPathTemplateWithRanges() throws Exception {
        this.genericTestPath(Utils.buildPath((String[])new String[]{"{grid}", "tiles", "{layer}", "zoom-{z}", "ranges_{x}-{y}.sqlite"}), Utils.buildPath((String[])new String[]{"wgs84", "tiles", "usa", "zoom-15", "ranges_3000-1000.sqlite"}), null, new long[]{3024L, 1534L, 15L}, "usa", "wgs84", null, new Utils.Tuple[0]);
    }

    @Test
    public void testPathTemplateWithParameters() throws Exception {
        this.genericTestPath(Utils.buildPath((String[])new String[]{"{background}-tiles", "{grid}", "{layer}-{style}", "zoom-{z}", "ranges{x}{y}.sqlite"}), Utils.buildPath((String[])new String[]{"blue-tiles", "wgs84", "america-default", "zoom-15", "ranges30001000.sqlite"}), null, new long[]{3024L, 1534L, 15L}, "america", "wgs84", null, Utils.Tuple.tuple((Object)"style", (Object)"default"), Utils.Tuple.tuple((Object)"background", (Object)"blue"));
    }

    @Test
    public void testPathTemplateWithTileObject() throws Exception {
        TileObject tile = TileObject.createCompleteTileObject((String)"africa", (long[])new long[]{7050L, 5075L, 11L}, (String)"wgs84", (String)"jpeg", (Map)Utils.tuplesToMap((Utils.Tuple[])new Utils.Tuple[]{Utils.Tuple.tuple((Object)"style", (Object)"dark borders"), Utils.Tuple.tuple((Object)"background", (Object)"blue")}), null);
        String pathTemplate = Utils.buildPath((String[])new String[]{"{format}-tiles", "{grid}", "{layer}-{style}", "zoom-{z}", "ranges-{x}_{y}.sqlite"});
        String expectedPath = Utils.buildPath((String[])new String[]{"jpeg-tiles", "wgs84", "africa-dark_borders", "zoom-11", "ranges-7000_4000.sqlite"});
        FileManager fileManager = new FileManager(this.getRootDirectory(), pathTemplate, 2000L, 1000L);
        File file = fileManager.getFile(tile);
        Assert.assertThat((Object)file.getCanonicalPath(), (Matcher)Matchers.is((Object)(this.getRootDirectoryPath() + File.separator + expectedPath)));
    }

    @Test
    public void testPathTemplateWithInvalidChars() throws Exception {
        this.genericTestPath(Utils.buildPath((String[])new String[]{"{grid}", "{format}", "{layer}.sqlite"}), Utils.buildPath((String[])new String[]{"epsg_4326", "image_png", "europe_borders.sqlite"}), null, null, "europe\\borders", "epsg:4326", "image/png", new Utils.Tuple[0]);
    }

    @Test
    public void testGetFilesByTileRange() throws Exception {
        String pathTemplate = Utils.buildPath((String[])new String[]{"tiles", "{z}", "tiles-{x}-{y}.sqlite"});
        FileManager fileManager = new FileManager(this.getRootDirectory(), pathTemplate, 10L, 10L);
        File file1 = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"tiles", "5", "tiles-0-0.sqlite"}));
        File file2 = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"tiles", "5", "tiles-10-0.sqlite"}));
        File file3 = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"tiles", "5", "tiles-0-10.sqlite"}));
        File file4 = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"tiles", "5", "tiles-10-10.sqlite"}));
        File file5 = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"tiles", "6", "tiles-10-0.sqlite"}));
        long[][] rangeBounds = new long[][]{{9L, 9L, 12L, 13L, 5L}, {16L, 5L, 16L, 5L, 6L}};
        TileRange tileRange = new TileRange("layer", "EPSG:4326", 5, 6, (long[][])rangeBounds, MimeType.createFromExtension((String)"png"), Collections.emptyMap());
        Map files = fileManager.getFiles(tileRange);
        Assert.assertThat((Object)files, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)files.size(), (Matcher)Matchers.is((Object)5));
        this.checkFileExistsAndContainsTiles(files, file1, new long[][]{{9L, 9L, 9L, 9L, 5L}});
        this.checkFileExistsAndContainsTiles(files, file2, new long[][]{{10L, 9L, 12L, 9L, 5L}});
        this.checkFileExistsAndContainsTiles(files, file3, new long[][]{{9L, 10L, 9L, 13L, 5L}});
        this.checkFileExistsAndContainsTiles(files, file4, new long[][]{{10L, 10L, 12L, 13L, 5L}});
        this.checkFileExistsAndContainsTiles(files, file5, new long[][]{{16L, 5L, 16L, 5L, 6L}});
    }

    @Test
    public void testPathSeparatorsAreConvertedToOsOnes() {
        String pathTemplate = "something-{layer}\\{grid-something}-something{grid}\\-el/se{format}/something-{params}";
        FileManager fileManager = new FileManager(this.getRootDirectory(), pathTemplate, 250L, 250L);
        File file = fileManager.getFile("parameters_id", new long[]{0L, 0L, 0L}, "layer_name", "grid_set", "format_name", Collections.emptyMap());
        Assert.assertThat((Object)file.toString(), (Matcher)Matchers.is((Object)this.buildRootFile("something-layer_name", "null-somethinggrid_set", "-el", "seformat_name", "something-parameters_id").toString()));
    }

    private void checkFileExistsAndContainsTiles(Map<File, List<long[]>> files, File file, long[] ... expectedTiles) {
        List<long[]> tiles = files.get(file);
        Assert.assertThat(tiles, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)tiles.size(), (Matcher)Matchers.is((Object)expectedTiles.length));
        Assert.assertThat(tiles, (Matcher)Matchers.containsInAnyOrder((Object[])expectedTiles));
    }

    @SafeVarargs
    private final void genericTestPath(String pathTemplate, String expectedPath, String parametersId, long[] xyz, String layerName, String gridSetId, String format, Utils.Tuple<String, String> ... tuples) {
        this.genericTestPath(pathTemplate, expectedPath, parametersId, xyz, layerName, gridSetId, format, Utils.tuplesToMap(tuples));
    }

    private void genericTestPath(String pathTemplate, String expectedPath, String parametersId, long[] xyz, String layerName, String gridSetId, String format, Map<String, String> parameters) {
        FileManager fileManager = new FileManager(this.getRootDirectory(), pathTemplate, 1000L, 1000L);
        File file = fileManager.getFile(parametersId, xyz, layerName, gridSetId, format, parameters);
        Assert.assertThat((Object)file.getPath(), (Matcher)Matchers.is((Object)new File(this.getRootDirectory(), expectedPath).getPath()));
    }
}

