/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.sqlite;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import org.geowebcache.io.Resource;
import org.geowebcache.mime.MimeType;
import org.geowebcache.sqlite.MbtilesBlobStore;
import org.geowebcache.sqlite.MbtilesInfo;
import org.geowebcache.sqlite.SqliteConnectionManager;
import org.geowebcache.sqlite.SqliteInfo;
import org.geowebcache.sqlite.TestSupport;
import org.geowebcache.sqlite.Utils;
import org.geowebcache.storage.CompositeBlobStore;
import org.geowebcache.storage.SuitabilityCheckRule;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.TileRange;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public final class MbtilesBlobStoreTest
extends TestSupport {
    @Rule
    public SuitabilityCheckRule suitability = SuitabilityCheckRule.system((CompositeBlobStore.StoreSuitabilityCheck)CompositeBlobStore.StoreSuitabilityCheck.NONE);

    @Test
    public void testTilePutGetDeleteOperations() throws Exception {
        MbtilesInfo configuration = this.getDefaultConfiguration();
        MbtilesBlobStore store = new MbtilesBlobStore(configuration);
        this.addStoresToClean(store);
        TileObject putTile = TileObject.createCompleteTileObject((String)"africa", (long[])new long[]{10L, 50L, 5L}, (String)"EPSG:4326", (String)"image/png", null, (Resource)MbtilesBlobStoreTest.stringToResource("IMAGE-10-50-5"));
        store.put(putTile);
        TileObject getTile = TileObject.createQueryTileObject((String)"africa", (long[])new long[]{10L, 50L, 5L}, (String)"EPSG:4326", (String)"image/png", null);
        Assert.assertThat((Object)store.get(getTile), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)getTile.getBlob(), (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)MbtilesBlobStoreTest.resourceToString(getTile.getBlob()), (Matcher)Matchers.is((Object)"IMAGE-10-50-5"));
        Assert.assertThat((Object)getTile.getCreated(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(System.currentTimeMillis() - 60000L)));
        Assert.assertThat((Object)store.delete(putTile), (Matcher)Matchers.is((Object)true));
        getTile = TileObject.createQueryTileObject((String)"africa", (long[])new long[]{10L, 50L, 5L}, (String)"EPSG:4326", (String)"image/png", null);
        Assert.assertThat((Object)store.get(getTile), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)getTile.getBlob(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testTileMetadataOperations() throws Exception {
        MbtilesInfo configuration = this.getDefaultConfiguration();
        MbtilesBlobStore store = new MbtilesBlobStore(configuration);
        this.addStoresToClean(store);
        store.putLayerMetadata("america", "background", "blue");
        store.putLayerMetadata("america", "style", "america-style");
        store.putLayerMetadata("australia", "background", "green");
        store.putLayerMetadata("australia", "style", "australia-style");
        Assert.assertThat((Object)store.getLayerMetadata("america", "background"), (Matcher)Matchers.is((Object)"blue"));
        Assert.assertThat((Object)store.getLayerMetadata("america", "style"), (Matcher)Matchers.is((Object)"america-style"));
        Assert.assertThat((Object)store.getLayerMetadata("australia", "background"), (Matcher)Matchers.is((Object)"green"));
        Assert.assertThat((Object)store.getLayerMetadata("australia", "style"), (Matcher)Matchers.is((Object)"australia-style"));
    }

    @Test
    public void testTileMetadataOperationsWithNull() throws Exception {
        MbtilesInfo configuration = this.getDefaultConfiguration();
        MbtilesBlobStore store = new MbtilesBlobStore(configuration);
        this.addStoresToClean(store);
        store.putLayerMetadata(null, null, null);
        store.putLayerMetadata("america", "style", null);
        store.putLayerMetadata("australia", null, "green");
        Assert.assertThat((Object)store.getLayerMetadata("america", "style"), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)store.getLayerMetadata("australia", null), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)store.getLayerMetadata(null, null), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testDeleteLayerOperation() throws Exception {
        MbtilesInfo configuration = this.getDefaultConfiguration();
        MbtilesBlobStore store = new MbtilesBlobStore(configuration);
        this.addStoresToClean(store);
        File asia1 = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"grid1", "asia", "image_png", "10", "tiles-0-500.sqlite"}));
        File asia2 = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"grid2", "asia", "image_png", "11", "tiles-100-500.sqlite"}));
        File asia3 = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"grid3", "asia", "image_png", "10", "tiles-0-500.sqlite"}));
        File asia4 = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"grid3", "asia", "image_jpeg", "10", "tiles-0-500.sqlite"}));
        File africa1 = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"grid1", "africa", "image_png", "10", "tiles-0-500.sqlite"}));
        File america1 = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"grid1", "america", "image_png", "10", "tiles-0-500.sqlite"}));
        File america2 = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"grid2", "america", "image_jpeg", "10", "tiles-0-500.sqlite"}));
        File europe1 = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"grid1", "europe", "image_gif", "15", "tiles-4000-500.sqlite"}));
        store.delete("asia");
        store.delete("europe");
        Assert.assertThat((Object)asia1.exists(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)asia2.exists(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)asia3.exists(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)asia4.exists(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)africa1.exists(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)america1.exists(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)america2.exists(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)europe1.exists(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testDeleteLayerWithGridSetOperation() throws Exception {
        MbtilesInfo configuration = this.getDefaultConfiguration();
        MbtilesBlobStore store = new MbtilesBlobStore(configuration);
        this.addStoresToClean(store);
        File asia1 = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"grid1", "asia", "image_png", "10", "tiles-0-500.sqlite"}));
        File asia2 = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"grid2", "asia", "image_png", "11", "tiles-100-500.sqlite"}));
        File asia3 = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"grid3", "asia", "image_png", "10", "tiles-0-500.sqlite"}));
        File asia4 = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"grid3", "asia", "image_jpeg", "10", "tiles-0-500.sqlite"}));
        File africa1 = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"grid1", "africa", "image_png", "10", "tiles-0-500.sqlite"}));
        File america1 = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"grid1", "america", "image_png", "10", "tiles-0-500.sqlite"}));
        File america2 = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"grid2", "america", "image_jpeg", "10", "tiles-0-500.sqlite"}));
        File europe1 = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"grid1", "europe", "image_gif", "15", "tiles-4000-500.sqlite"}));
        store.deleteByGridsetId("asia", "grid3");
        store.deleteByGridsetId("america", "grid2");
        Assert.assertThat((Object)asia1.exists(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)asia2.exists(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)asia3.exists(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)asia4.exists(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)africa1.exists(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)america1.exists(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)america2.exists(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)europe1.exists(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testDeleteLayerWithTileRangeEager() throws Exception {
        MbtilesInfo configuration = this.getDefaultConfiguration();
        configuration.setEagerDelete(true);
        MbtilesBlobStore store = new MbtilesBlobStore(configuration);
        this.addStoresToClean(store);
        long[][] rangeBounds = new long[][]{{0L, 490L, 10L, 500L, 10L}, {800L, 950L, 1005L, 1020L, 11L}};
        TileRange tileRange = new TileRange("asia", "grid1", 10, 11, (long[][])rangeBounds, MimeType.createFromExtension((String)"png"), Collections.emptyMap());
        File asia1 = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"grid1", "asia", "image_png", "10", "tiles-0-0.sqlite"}));
        File asia2 = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"grid1", "asia", "image_png", "10", "tiles-0-500.sqlite"}));
        File asia3 = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"grid1", "asia", "image_png", "10", "tiles-500-0.sqlite"}));
        File asia4 = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"grid1", "asia", "image_png", "10", "tiles-500-500.sqlite"}));
        File asia5 = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"grid1", "asia", "image_png", "11", "tiles-1000-1000.sqlite"}));
        store.delete(tileRange);
        Assert.assertThat((Object)asia1.exists(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)asia2.exists(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)asia3.exists(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)asia4.exists(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)asia5.exists(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testDeleteLayerWithTileRangeNoEager() throws Exception {
        MbtilesInfo configuration = this.getDefaultConfiguration();
        MbtilesBlobStore store = new MbtilesBlobStore(configuration);
        this.addStoresToClean(store);
        long[][] rangeBounds = new long[][]{{0L, 10L, 5L, 15L, 10L}, {980L, 950L, 1005L, 1020L, 11L}};
        TileRange tileRange = new TileRange("asia", "grid1", 10, 11, (long[][])rangeBounds, MimeType.createFromExtension((String)"png"), Collections.emptyMap());
        File asia1 = this.buildRootFile(Utils.buildPath((String[])new String[]{"grid1", "asia", "image_png", "10", "tiles-0-0.sqlite"}));
        File asia2 = this.buildRootFile(Utils.buildPath((String[])new String[]{"grid1", "asia", "image_png", "10", "tiles-500-500.sqlite"}));
        store.put(TileObject.createCompleteTileObject((String)"asia", (long[])new long[]{3L, 12L, 10L}, (String)"grid1", (String)"image/png", null, (Resource)MbtilesBlobStoreTest.stringToResource("IMAGE-10-50-10")));
        store.put(TileObject.createCompleteTileObject((String)"asia", (long[])new long[]{510L, 550L, 10L}, (String)"grid1", (String)"image/png", null, (Resource)MbtilesBlobStoreTest.stringToResource("IMAGE-510-550-10")));
        store.delete(tileRange);
        Assert.assertThat((Object)asia1.exists(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)asia2.exists(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)store.get(TileObject.createQueryTileObject((String)"asia", (long[])new long[]{10L, 50L, 10L}, (String)"grid1", (String)"image/png", null)), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)store.get(TileObject.createQueryTileObject((String)"asia", (long[])new long[]{510L, 550L, 10L}, (String)"grid1", (String)"image/png", null)), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testLayerExistsOperation() throws Exception {
        MbtilesInfo configuration = this.getDefaultConfiguration();
        MbtilesBlobStore store = new MbtilesBlobStore(configuration);
        this.addStoresToClean(store);
        this.createFileInRootDir(Utils.buildPath((String[])new String[]{"grid1", "europe", "image_png", "10", "tiles-0-0.sqlite"}));
        Assert.assertThat((Object)store.layerExists("europe"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)store.layerExists("asia"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testRenameOperation() throws Exception {
        MbtilesInfo configuration = this.getDefaultConfiguration();
        MbtilesBlobStore store = new MbtilesBlobStore(configuration);
        this.addStoresToClean(store);
        File asia1 = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"grid1", "asia", "image_png", "10", "tiles-0-0.sqlite"}));
        File asia2 = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"grid1", "asia", "image_png", "10", "tiles-0-500.sqlite"}));
        File europe1 = this.createFileInRootDir(Utils.buildPath((String[])new String[]{"grid1", "europe", "image_png", "10", "tiles-500-0.sqlite"}));
        store.rename("asia", "australia");
        Assert.assertThat((Object)asia1.exists(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)asia2.exists(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)europe1.exists(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.buildRootFile("grid1", "australia", "image_png", "10", "tiles-0-0.sqlite").exists(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.buildRootFile("grid1", "australia", "image_png", "10", "tiles-0-500.sqlite").exists(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testOpeningDatabaseFileWithMbtilesMetadata() throws Exception {
        File mbtilesMetadataDirectory = this.buildRootFile("mbtiles-metadata");
        File mbtilesMetadataFile = new File(mbtilesMetadataDirectory, "europe_asia.properties");
        String mbtilesMetadata = "attribution=some attribution" + System.lineSeparator() + "bounds=-180,-90,180,90" + System.lineSeparator() + "description=some description" + System.lineSeparator() + "maxZoom=10" + System.lineSeparator() + "minZoom=0" + System.lineSeparator() + "type=base_layer" + System.lineSeparator() + "version=1.0" + System.lineSeparator();
        this.writeToFile(mbtilesMetadataFile, mbtilesMetadata);
        MbtilesInfo configuration = this.getDefaultConfiguration();
        configuration.setMbtilesMetadataDirectory(mbtilesMetadataDirectory.getPath());
        SqliteConnectionManager connectionManager = new SqliteConnectionManager((SqliteInfo)configuration);
        MbtilesBlobStore store = new MbtilesBlobStore(configuration, connectionManager);
        this.addStoresToClean(store);
        TileObject putTile = TileObject.createCompleteTileObject((String)"europe:asia", (long[])new long[]{5L, 5L, 5L}, (String)"EPSG:4326", (String)"image/png", null, (Resource)MbtilesBlobStoreTest.stringToResource("IMAGE-5-5-5"));
        store.put(putTile);
        File file = this.buildRootFile("EPSG_4326", "europe_asia", "image_png", "5", "tiles-0-0.sqlite");
        Assert.assertThat((Object)file.exists(), (Matcher)Matchers.is((Object)true));
        connectionManager.executeQuery(file, resultSet -> {
            ArrayList<Utils.Tuple> foundMetadata = new ArrayList<Utils.Tuple>();
            while (resultSet.next()) {
                foundMetadata.add(Utils.Tuple.tuple((Object)resultSet.getString(1), (Object)resultSet.getString(2)));
            }
            Assert.assertThat((Object)foundMetadata.size(), (Matcher)Matchers.is((Object)10));
            Assert.assertThat(foundMetadata, (Matcher)Matchers.containsInAnyOrder((Object[])new Utils.Tuple[]{Utils.Tuple.tuple((Object)"name", (Object)"europe:asia"), Utils.Tuple.tuple((Object)"version", (Object)"1.0"), Utils.Tuple.tuple((Object)"description", (Object)"some description"), Utils.Tuple.tuple((Object)"attribution", (Object)"some attribution"), Utils.Tuple.tuple((Object)"type", (Object)"base_layer"), Utils.Tuple.tuple((Object)"format", (Object)"png"), Utils.Tuple.tuple((Object)"bounds", (Object)"-180.0,-90.0,180.0,90.0"), Utils.Tuple.tuple((Object)"minzoom", (Object)"5"), Utils.Tuple.tuple((Object)"maxzoom", (Object)"5"), Utils.Tuple.tuple((Object)"json", (Object)"null")}));
            return null;
        }, "SELECT name, value FROM metadata;", new Object[0]);
    }
}

