/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.sqlite;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.geotools.mbtiles.MBTilesFileVectorTileTest;
import org.geowebcache.mime.ApplicationMime;
import org.geowebcache.sqlite.MbtilesBlobStore;
import org.geowebcache.sqlite.MbtilesInfo;
import org.geowebcache.sqlite.TestSupport;
import org.geowebcache.storage.CompositeBlobStore;
import org.geowebcache.storage.SuitabilityCheckRule;
import org.geowebcache.storage.TileObject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class MbtilesPBFTest
extends TestSupport {
    File file;
    String layer;
    @Rule
    public SuitabilityCheckRule suitability = SuitabilityCheckRule.system((CompositeBlobStore.StoreSuitabilityCheck)CompositeBlobStore.StoreSuitabilityCheck.NONE);

    @Before
    public void copyData() throws Exception {
        this.file = this.buildRootFile("planet.mbtiles");
        URL template = MBTilesFileVectorTileTest.class.getResource("planet.mbtiles");
        try (InputStream in = template.openStream();
             FileOutputStream out = new FileOutputStream(this.file);){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        this.layer = "planet";
    }

    @Test
    public void testGetTileDefaultUnzip() throws Exception {
        MbtilesInfo configuration = this.getDefaultConfiguration();
        MbtilesBlobStore store = new MbtilesBlobStore(configuration);
        this.addStoresToClean(store);
        TileObject tile = TileObject.createQueryTileObject((String)this.layer, (long[])new long[]{0L, 0L, 0L}, (String)"EPSG:900913", (String)ApplicationMime.mapboxVector.getFormat(), null);
        Assert.assertThat((Object)store.get(tile), (Matcher)Matchers.is((Object)true));
        try (InputStream is = MBTilesFileVectorTileTest.class.getResourceAsStream("tile_data.pbf.gz");){
            Assert.assertTrue((boolean)IOUtils.contentEquals((InputStream)tile.getBlob().getInputStream(), (InputStream)is));
        }
    }

    @Test
    public void testGetTileDoUnzip() throws Exception {
        MbtilesInfo configuration = this.getDefaultConfiguration();
        configuration.setGzipVector(true);
        MbtilesBlobStore store = new MbtilesBlobStore(configuration);
        this.addStoresToClean(store);
        TileObject tile = TileObject.createQueryTileObject((String)this.layer, (long[])new long[]{0L, 0L, 0L}, (String)"EPSG:900913", (String)ApplicationMime.mapboxVector.getFormat(), null);
        Assert.assertThat((Object)store.get(tile), (Matcher)Matchers.is((Object)true));
        try (InputStream is = MBTilesFileVectorTileTest.class.getResourceAsStream("tile_data.pbf");){
            Assert.assertTrue((boolean)IOUtils.contentEquals((InputStream)tile.getBlob().getInputStream(), (InputStream)is));
        }
    }

    @Test
    public void testGetTileNoUnzip() throws Exception {
        MbtilesInfo configuration = this.getDefaultConfiguration();
        configuration.setGzipVector(false);
        MbtilesBlobStore store = new MbtilesBlobStore(configuration);
        this.addStoresToClean(store);
        TileObject tile = TileObject.createQueryTileObject((String)this.layer, (long[])new long[]{0L, 0L, 0L}, (String)"EPSG:900913", (String)ApplicationMime.mapboxVector.getFormat(), null);
        Assert.assertThat((Object)store.get(tile), (Matcher)Matchers.is((Object)true));
        try (InputStream is = MBTilesFileVectorTileTest.class.getResourceAsStream("tile_data.pbf.gz");){
            Assert.assertTrue((boolean)IOUtils.contentEquals((InputStream)tile.getBlob().getInputStream(), (InputStream)is));
        }
    }

    @Override
    protected MbtilesInfo getDefaultConfiguration() {
        MbtilesInfo config = super.getDefaultConfiguration();
        config.setTemplatePath("{layer}.mbtiles");
        return config;
    }
}

