/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.sqlite;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.geowebcache.config.BlobStoreInfo;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.io.Resource;
import org.geowebcache.sqlite.MbtilesBlobStore;
import org.geowebcache.sqlite.MbtilesInfo;
import org.geowebcache.sqlite.OperationsRestWebConfig;
import org.geowebcache.sqlite.SqliteInfo;
import org.geowebcache.sqlite.TestSupport;
import org.geowebcache.sqlite.Utils;
import org.geowebcache.storage.CompositeBlobStore;
import org.geowebcache.storage.SuitabilityCheckRule;
import org.geowebcache.storage.TileObject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@WebAppConfiguration
@ContextConfiguration(classes={OperationsRestWebConfig.class})
@RunWith(value=SpringJUnit4ClassRunner.class)
@ActiveProfiles(value={"test"})
public class OperationsRestTest
extends TestSupport {
    @Autowired
    private WebApplicationContext webApplicationContext;
    @Rule
    public SuitabilityCheckRule suitability = SuitabilityCheckRule.system((CompositeBlobStore.StoreSuitabilityCheck)CompositeBlobStore.StoreSuitabilityCheck.NONE);

    @After
    public void afterClass() throws Exception {
        this.closeSqliteStoresConnections();
        super.afterTest();
        FileUtils.deleteQuietly((File)OperationsRestWebConfig.ROOT_DIRECTORY);
    }

    @Test
    public void testMultipleFilesUploadReplace() throws Exception {
        Utils.Tuple<File, Utils.Tuple<String, String>> testFiles = this.createTestFiles();
        File rootDirectory = (File)testFiles.first;
        try (FileInputStream fileA = new FileInputStream(new File(rootDirectory, (String)((Utils.Tuple)testFiles.second).first));
             FileInputStream fileB = new FileInputStream(new File(rootDirectory, (String)((Utils.Tuple)testFiles.second).second));){
            MockMultipartFile fileUploadA = new MockMultipartFile("file", (InputStream)fileA);
            MockMultipartFile fileUploadB = new MockMultipartFile("file", (InputStream)fileB);
            MockMvc mockMvc = MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.webApplicationContext).build();
            mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)"/sqlite/replace", (Object[])new Object[0]).file(fileUploadA).param("layer", new String[]{"europe"}).param("destination", new String[]{(String)((Utils.Tuple)testFiles.second).first})).andExpect(MockMvcResultMatchers.status().is(200));
            mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)"/sqlite/replace", (Object[])new Object[0]).file(fileUploadB).param("layer", new String[]{"europe"}).param("destination", new String[]{(String)((Utils.Tuple)testFiles.second).second})).andExpect(MockMvcResultMatchers.status().is(200));
            this.checkThatStoreContainsReplacedTiles((String)((Utils.Tuple)testFiles.second).first, (String)((Utils.Tuple)testFiles.second).second);
        }
    }

    @Test
    public void testZipFileUploadReplace() throws Exception {
        Utils.Tuple<File, Utils.Tuple<String, String>> testFiles = this.createTestFiles();
        File rootDirectory = (File)testFiles.first;
        File tempDirectory = Files.createTempDirectory("gwc-", new FileAttribute[0]).toFile();
        this.addFilesToDelete(tempDirectory);
        File zipFile = new File(tempDirectory, "replace.zip");
        this.zipDirectory(Paths.get(rootDirectory.getPath(), new String[0]), zipFile);
        try (FileInputStream zipFileInputStream = new FileInputStream(zipFile);){
            MockMultipartFile zipUpload = new MockMultipartFile("file", (InputStream)zipFileInputStream);
            MockMvc mockMvc = MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.webApplicationContext).build();
            mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)"/sqlite/replace", (Object[])new Object[0]).file(zipUpload).param("layer", new String[]{"europe"})).andExpect(MockMvcResultMatchers.status().is(200));
            this.checkThatStoreContainsReplacedTiles((String)((Utils.Tuple)testFiles.second).first, (String)((Utils.Tuple)testFiles.second).second);
        }
    }

    @Test
    public void testLocalDirectoryReplace() throws Exception {
        Utils.Tuple<File, Utils.Tuple<String, String>> testFiles = this.createTestFiles();
        File rootDirectory = (File)testFiles.first;
        MockMvc mockMvc = MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.webApplicationContext).build();
        mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.multipart((String)"/sqlite/replace", (Object[])new Object[0]).param("layer", new String[]{"europe"}).param("source", new String[]{rootDirectory.getPath()})).andExpect(MockMvcResultMatchers.status().is(200));
        this.checkThatStoreContainsReplacedTiles((String)((Utils.Tuple)testFiles.second).first, (String)((Utils.Tuple)testFiles.second).second);
    }

    private Utils.Tuple<File, Utils.Tuple<String, String>> createTestFiles() throws Exception {
        File rootDirectoryA = OperationsRestWebConfig.ROOT_DIRECTORY;
        this.addFilesToDelete(rootDirectoryA);
        if (Files.exists(OperationsRestWebConfig.ROOT_DIRECTORY.toPath(), new LinkOption[0])) {
            Files.delete(OperationsRestWebConfig.ROOT_DIRECTORY.toPath());
        }
        Files.createDirectories(OperationsRestWebConfig.ROOT_DIRECTORY.toPath(), new FileAttribute[0]);
        File rootDirectoryB = Files.createTempDirectory("gwc-", new FileAttribute[0]).toFile();
        this.addFilesToDelete(rootDirectoryB);
        MbtilesInfo configurationA = new MbtilesInfo();
        configurationA.setRootDirectory(rootDirectoryA.getPath());
        configurationA.setTemplatePath(Utils.buildPath((String[])new String[]{"{grid}", "{layer}", "{format}", "{z}", "tiles-{x}-{y}.sqlite"}));
        MbtilesInfo configurationB = new MbtilesInfo();
        configurationB.setRootDirectory(rootDirectoryB.getPath());
        configurationB.setTemplatePath(Utils.buildPath((String[])new String[]{"{grid}", "{layer}", "{format}", "{z}", "tiles-{x}-{y}.sqlite"}));
        MbtilesBlobStore storeA = new MbtilesBlobStore(configurationA);
        MbtilesBlobStore storeB = new MbtilesBlobStore(configurationB);
        this.addStoresToClean(storeA, storeB);
        TileObject putTileA = TileObject.createCompleteTileObject((String)"africa", (long[])new long[]{10L, 50L, 5L}, (String)"EPSG:4326", (String)"image/png", null, (Resource)TestSupport.stringToResource("IMAGE-10-50-5-A"));
        TileObject putTileB = TileObject.createCompleteTileObject((String)"africa", (long[])new long[]{10L, 50L, 5L}, (String)"EPSG:4326", (String)"image/png", null, (Resource)TestSupport.stringToResource("IMAGE-10-50-5-B"));
        TileObject putTileC = TileObject.createCompleteTileObject((String)"africa", (long[])new long[]{10L, 5050L, 15L}, (String)"EPSG:4326", (String)"image/png", null, (Resource)TestSupport.stringToResource("IMAGE-15-5050-5-B"));
        storeA.put(putTileA);
        storeB.put(putTileB);
        storeB.put(putTileC);
        storeA.clear();
        storeB.clear();
        String relativePathA = Utils.buildPath((String[])new String[]{"EPSG_4326", "africa", "image_png", "5", "tiles-0-0.sqlite"});
        String relativePathB = Utils.buildPath((String[])new String[]{"EPSG_4326", "africa", "image_png", "15", "tiles-0-5000.sqlite"});
        return Utils.Tuple.tuple((Object)rootDirectoryB, (Object)Utils.Tuple.tuple((Object)relativePathA, (Object)relativePathB));
    }

    private void checkThatStoreContainsReplacedTiles(String relativePathA, String relativePathB) throws Exception {
        File rootDirectory = OperationsRestWebConfig.ROOT_DIRECTORY;
        MbtilesInfo configuration = new MbtilesInfo();
        configuration.setRootDirectory(rootDirectory.getPath());
        configuration.setTemplatePath(Utils.buildPath((String[])new String[]{"{grid}", "{layer}", "{format}", "{z}", "tiles-{x}-{y}.sqlite"}));
        MbtilesBlobStore store = new MbtilesBlobStore(configuration);
        this.addStoresToClean(store);
        File fileA = new File(OperationsRestWebConfig.ROOT_DIRECTORY, relativePathA);
        File fileB = new File(OperationsRestWebConfig.ROOT_DIRECTORY, relativePathB);
        Assert.assertThat((Object)fileA.exists(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)fileB.exists(), (Matcher)Matchers.is((Object)true));
        TileObject getTile = TileObject.createQueryTileObject((String)"africa", (long[])new long[]{10L, 50L, 5L}, (String)"EPSG:4326", (String)"image/png", null);
        Assert.assertThat((Object)store.get(getTile), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)getTile.getBlob(), (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)TestSupport.resourceToString(getTile.getBlob()), (Matcher)Matchers.is((Object)"IMAGE-10-50-5-B"));
        getTile = TileObject.createQueryTileObject((String)"africa", (long[])new long[]{10L, 5050L, 15L}, (String)"EPSG:4326", (String)"image/png", null);
        Assert.assertThat((Object)store.get(getTile), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)getTile.getBlob(), (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)TestSupport.resourceToString(getTile.getBlob()), (Matcher)Matchers.is((Object)"IMAGE-15-5050-5-B"));
    }

    private void zipDirectory(final Path directoryToZip, File outputZipFile) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(outputZipFile);
             final ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);){
            Files.walkFileTree(directoryToZip, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes fileAttributes) throws IOException {
                    zipOutputStream.putNextEntry(new ZipEntry(directoryToZip.relativize(file).toString()));
                    Files.copy(file, zipOutputStream);
                    zipOutputStream.closeEntry();
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path directory, BasicFileAttributes attrs) throws IOException {
                    if (directory.equals(directoryToZip)) {
                        return FileVisitResult.CONTINUE;
                    }
                    zipOutputStream.putNextEntry(new ZipEntry(directoryToZip.relativize(directory).toString() + "/"));
                    zipOutputStream.closeEntry();
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private void closeSqliteStoresConnections() {
        XMLConfiguration configuration = (XMLConfiguration)this.webApplicationContext.getBean(XMLConfiguration.class);
        Assert.assertThat((Object)configuration, (Matcher)Matchers.notNullValue());
        List blobStoresConfig = configuration.getBlobStores();
        Assert.assertThat((Object)blobStoresConfig, (Matcher)Matchers.notNullValue());
        for (BlobStoreInfo blobStoreConfig : blobStoresConfig) {
            if (!(blobStoreConfig instanceof SqliteInfo)) continue;
            ((MbtilesInfo)blobStoreConfig).getConnectionManager().reapAllConnections();
        }
    }
}

