/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.sqlite;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.sqlite.MbtilesInfo;
import org.geowebcache.sqlite.Utils;
import org.mockito.Mockito;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;

@Configuration
@ComponentScan(value={"org.geowebcache.sqlite"})
@EnableWebMvc
@Profile(value={"test"})
public class OperationsRestWebConfig
extends WebMvcConfigurationSupport {
    static File ROOT_DIRECTORY;

    @Bean
    public MultipartResolver multipartResolver() {
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver();
        return multipartResolver;
    }

    @Bean
    public TileLayerDispatcher tileLayerDispatcher() throws GeoWebCacheException {
        TileLayerDispatcher tileLayerDispatcher = (TileLayerDispatcher)Mockito.mock(TileLayerDispatcher.class);
        TileLayer tileLayer = (TileLayer)Mockito.mock(TileLayer.class);
        Mockito.when((Object)tileLayer.getBlobStoreId()).thenReturn((Object)"mbtiles-store");
        Mockito.when((Object)tileLayerDispatcher.getTileLayer("europe")).thenReturn((Object)tileLayer);
        return tileLayerDispatcher;
    }

    @Bean
    public XMLConfiguration xmlConfiguration() {
        XMLConfiguration gwcConfiguration = (XMLConfiguration)Mockito.mock(XMLConfiguration.class);
        ArrayList<MbtilesInfo> mbtilesStoreConfig = new ArrayList<MbtilesInfo>();
        MbtilesInfo configuration = new MbtilesInfo("mbtiles-store");
        configuration.setRootDirectory(ROOT_DIRECTORY.getPath());
        mbtilesStoreConfig.add(configuration);
        Mockito.when((Object)gwcConfiguration.getBlobStores()).thenReturn(mbtilesStoreConfig);
        return gwcConfiguration;
    }

    @Bean
    public GridSetBroker gwcGridSetBroker() {
        return (GridSetBroker)Mockito.mock(GridSetBroker.class);
    }

    static {
        try {
            ROOT_DIRECTORY = Files.createTempDirectory("gwc-", new FileAttribute[0]).toFile();
        }
        catch (Exception exception) {
            throw Utils.exception((Exception)exception, (String)"Error creating temporary directory.", (Object[])new Object[0]);
        }
    }
}

