/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.sqlite;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.geowebcache.io.Resource;
import org.geowebcache.sqlite.MbtilesBlobStore;
import org.geowebcache.sqlite.MbtilesInfo;
import org.geowebcache.sqlite.TestSupport;
import org.geowebcache.sqlite.Utils;
import org.geowebcache.storage.TileObject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public final class SqliteBlobStoreTest
extends TestSupport {
    @Test
    public void testFileReplaceOperation() throws Exception {
        File rootDirectoryA = Files.createTempDirectory("gwc-", new FileAttribute[0]).toFile();
        File rootDirectoryB = Files.createTempDirectory("gwc-", new FileAttribute[0]).toFile();
        this.addFilesToDelete(rootDirectoryA, rootDirectoryB);
        MbtilesInfo configurationA = this.getDefaultConfiguration();
        configurationA.setRootDirectory(rootDirectoryA.getPath());
        MbtilesInfo configurationB = this.getDefaultConfiguration();
        configurationB.setRootDirectory(rootDirectoryB.getPath());
        MbtilesBlobStore storeA = new MbtilesBlobStore(configurationA);
        MbtilesBlobStore storeB = new MbtilesBlobStore(configurationB);
        this.addStoresToClean(storeA, storeB);
        TileObject putTileA = TileObject.createCompleteTileObject((String)"africa", (long[])new long[]{10L, 50L, 5L}, (String)"EPSG:4326", (String)"image/png", null, (Resource)SqliteBlobStoreTest.stringToResource("IMAGE-10-50-5-A"));
        TileObject putTileB = TileObject.createCompleteTileObject((String)"africa", (long[])new long[]{10L, 50L, 5L}, (String)"EPSG:4326", (String)"image/png", null, (Resource)SqliteBlobStoreTest.stringToResource("IMAGE-10-50-5-B"));
        storeA.put(putTileA);
        storeB.put(putTileB);
        storeA.clear();
        storeB.clear();
        String relativePath = Utils.buildPath((String[])new String[]{"EPSG_4326", "africa", "image_png", "5", "tiles-0-0.sqlite"});
        File fileA = new File(rootDirectoryA, relativePath);
        File fileB = new File(rootDirectoryB, relativePath);
        Assert.assertThat((Object)fileA.exists(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)fileB.exists(), (Matcher)Matchers.is((Object)true));
        storeA.replace(fileB, relativePath);
        TileObject getTile = TileObject.createQueryTileObject((String)"africa", (long[])new long[]{10L, 50L, 5L}, (String)"EPSG:4326", (String)"image/png", null);
        Assert.assertThat((Object)storeA.get(getTile), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)getTile.getBlob(), (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)SqliteBlobStoreTest.resourceToString(getTile.getBlob()), (Matcher)Matchers.is((Object)"IMAGE-10-50-5-B"));
        FileUtils.deleteQuietly((File)rootDirectoryA);
        FileUtils.deleteQuietly((File)rootDirectoryB);
    }

    @Test
    public void testDirectoryReplaceOperation() throws Exception {
        File rootDirectoryA = Files.createTempDirectory("replace-tests-a-", new FileAttribute[0]).toFile();
        File rootDirectoryB = Files.createTempDirectory("replace-tests-a-", new FileAttribute[0]).toFile();
        this.addFilesToDelete(rootDirectoryA, rootDirectoryB);
        MbtilesInfo configurationA = this.getDefaultConfiguration();
        configurationA.setRootDirectory(rootDirectoryA.getPath());
        MbtilesInfo configurationB = this.getDefaultConfiguration();
        configurationB.setRootDirectory(rootDirectoryB.getPath());
        MbtilesBlobStore storeA = new MbtilesBlobStore(configurationA);
        MbtilesBlobStore storeB = new MbtilesBlobStore(configurationB);
        this.addStoresToClean(storeA, storeB);
        TileObject putTileA = TileObject.createCompleteTileObject((String)"africa", (long[])new long[]{10L, 50L, 5L}, (String)"EPSG:4326", (String)"image/png", null, (Resource)SqliteBlobStoreTest.stringToResource("IMAGE-10-50-5-A"));
        TileObject putTileB = TileObject.createCompleteTileObject((String)"africa", (long[])new long[]{10L, 50L, 5L}, (String)"EPSG:4326", (String)"image/png", null, (Resource)SqliteBlobStoreTest.stringToResource("IMAGE-10-50-5-B"));
        TileObject putTileC = TileObject.createCompleteTileObject((String)"africa", (long[])new long[]{10L, 5050L, 15L}, (String)"EPSG:4326", (String)"image/png", null, (Resource)SqliteBlobStoreTest.stringToResource("IMAGE-15-5050-5-B"));
        storeA.put(putTileA);
        storeB.put(putTileB);
        storeB.put(putTileC);
        storeA.clear();
        storeB.clear();
        String relativePathA = Utils.buildPath((String[])new String[]{"EPSG_4326", "africa", "image_png", "5", "tiles-0-0.sqlite"});
        String relativePathB = Utils.buildPath((String[])new String[]{"EPSG_4326", "africa", "image_png", "15", "tiles-0-5000.sqlite"});
        File fileA = new File(rootDirectoryA, relativePathA);
        File fileB = new File(rootDirectoryB, relativePathA);
        File fileC = new File(rootDirectoryB, relativePathB);
        Assert.assertThat((Object)fileA.exists(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)fileB.exists(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)fileC.exists(), (Matcher)Matchers.is((Object)true));
        storeA.replace(rootDirectoryB);
        TileObject getTile = TileObject.createQueryTileObject((String)"africa", (long[])new long[]{10L, 50L, 5L}, (String)"EPSG:4326", (String)"image/png", null);
        Assert.assertThat((Object)storeA.get(getTile), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)getTile.getBlob(), (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)SqliteBlobStoreTest.resourceToString(getTile.getBlob()), (Matcher)Matchers.is((Object)"IMAGE-10-50-5-B"));
        getTile = TileObject.createQueryTileObject((String)"africa", (long[])new long[]{10L, 5050L, 15L}, (String)"EPSG:4326", (String)"image/png", null);
        Assert.assertThat((Object)storeA.get(getTile), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)getTile.getBlob(), (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)SqliteBlobStoreTest.resourceToString(getTile.getBlob()), (Matcher)Matchers.is((Object)"IMAGE-15-5050-5-B"));
        FileUtils.deleteQuietly((File)rootDirectoryA);
        FileUtils.deleteQuietly((File)rootDirectoryB);
    }
}

