/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.sqlite;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geowebcache.sqlite.SqliteConnectionManager;
import org.geowebcache.sqlite.TestSupport;
import org.geowebcache.sqlite.Utils;
import org.geowebcache.storage.StorageException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public final class SqliteConnectionManagerTest
extends TestSupport {
    private static Logger LOGGER = Logging.getLogger((String)SqliteConnectionManagerTest.class.getName());
    private List<SqliteConnectionManager> connectionManagersToClean;

    @Override
    @Before
    public void beforeTest() throws Exception {
        super.beforeTest();
        this.connectionManagersToClean = new ArrayList<SqliteConnectionManager>();
    }

    @Override
    @After
    public void afterTest() throws Exception {
        for (SqliteConnectionManager connectionManager : this.connectionManagersToClean) {
            try {
                connectionManager.reapAllConnections();
                connectionManager.stopPoolReaper();
            }
            catch (Exception exception) {}
        }
        super.afterTest();
    }

    @Test
    public void testGetConnection() throws StorageException {
        SqliteConnectionManager connectionManager = new SqliteConnectionManager(Integer.MAX_VALUE, 1000L);
        this.connectionManagersToClean.add(connectionManager);
        connectionManager.doWork(this.buildRootFile("tiles", "data_base.sqlite"), true, connection -> SqliteConnectionManagerTest.insertInTestTable(connection, "name", "europe"));
        connectionManager.reapAllConnections();
        Assert.assertThat((Object)connectionManager.getPool().size(), (Matcher)Matchers.is((Object)0));
        connectionManager.doWork(this.buildRootFile("tiles", "data_base.sqlite"), true, connection -> {
            String value = SqliteConnectionManagerTest.getFromTestTable(connection, "name");
            Assert.assertThat((Object)value, (Matcher)Matchers.notNullValue());
            Assert.assertThat((Object)value, (Matcher)Matchers.is((Object)"europe"));
            SqliteConnectionManagerTest.closeConnectionQuietly(connection);
        });
    }

    @Test
    @Ignore
    public void testMultiThreadsWithSingleFile() throws Exception {
        this.genericMultiThreadsTest(10, 500, Integer.MAX_VALUE, this.buildRootFile("data_base_a.sqlite"));
    }

    @Test
    @Ignore
    public void testMultiThreadsWithMultipleFiles() throws Exception {
        this.genericMultiThreadsTest(10, 500, 10L, this.buildRootFile("data_base_a.sqlite"), this.buildRootFile("data_base_b.sqlite"), this.buildRootFile("data_base_c.sqlite"), this.buildRootFile("data_base_d.sqlite"), this.buildRootFile("data_base_e.sqlite"));
    }

    @Test
    @Ignore
    public void testMultiThreadsWithMultipleFilesWithCacheLimit() throws Exception {
        this.genericMultiThreadsTest(10, 500, 1L, this.buildRootFile("data_base_a.sqlite"), this.buildRootFile("data_base_b.sqlite"), this.buildRootFile("data_base_c.sqlite"), this.buildRootFile("data_base_d.sqlite"), this.buildRootFile("data_base_e.sqlite"));
    }

    @Test
    @Ignore
    public void testReplaceOperation() throws Exception {
        SqliteConnectionManager connectionManager = new SqliteConnectionManager(Integer.MAX_VALUE, 1000L);
        this.connectionManagersToClean.add(connectionManager);
        File file1 = this.buildRootFile("tiles", "data_base_1.sqlite");
        Utils.createFileParents((File)file1);
        File file2 = this.buildRootFile("tiles", "data_base_2.sqlite");
        Utils.createFileParents((File)file2);
        connectionManager.doWork(file1, false, connection -> {
            SqliteConnectionManagerTest.insertInTestTable(connection, "name", "europe");
            SqliteConnectionManagerTest.closeConnectionQuietly(connection);
        });
        file2.createNewFile();
        connectionManager.replace(file1, file2);
        connectionManager.doWork(file1, false, connection -> {
            SqliteConnectionManagerTest.createTestTable(connection);
            String value = SqliteConnectionManagerTest.getFromTestTable(connection, "name");
            Assert.assertThat((Object)value, (Matcher)Matchers.nullValue());
            SqliteConnectionManagerTest.closeConnectionQuietly(connection);
        });
    }

    private void genericMultiThreadsTest(int threadsNumber, int workersNumber, long poolSize, File ... files) throws Exception {
        SqliteConnectionManager connectionManager = new SqliteConnectionManager(poolSize, 10L);
        this.connectionManagersToClean.add(connectionManager);
        ExecutorService executor = Executors.newFixedThreadPool(threadsNumber);
        Random random = new Random();
        ArrayList results = new ArrayList();
        for (int i = 0; i < workersNumber; ++i) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("Submitted worker '%d'\\'%d'.", i, workersNumber));
            }
            executor.submit(() -> {
                File file = files[random.nextInt(files.length)];
                String key = UUID.randomUUID().toString();
                return (Utils.Tuple)connectionManager.doWork(file, false, connection -> {
                    SqliteConnectionManagerTest.insertInTestTable(connection, key, "value-" + key);
                    SqliteConnectionManagerTest.closeConnectionQuietly(connection);
                    return Utils.Tuple.tuple((Object)file, (Object)key);
                });
            });
        }
        executor.shutdown();
        executor.awaitTermination(60L, TimeUnit.SECONDS);
        connectionManager.reapAllConnections();
        Assert.assertThat((Object)connectionManager.getPool().size(), (Matcher)Matchers.is((Object)0));
        for (Future result : results) {
            File file = (File)((Utils.Tuple)result.get()).first;
            String key = (String)((Utils.Tuple)result.get()).second;
            connectionManager.doWork(file, true, connection -> {
                String value = SqliteConnectionManagerTest.getFromTestTable(connection, key);
                Assert.assertThat((Object)value, (Matcher)Matchers.notNullValue());
                Assert.assertThat((Object)value, (Matcher)Matchers.is((Object)("value-" + key)));
                SqliteConnectionManagerTest.closeConnectionQuietly(connection);
            });
        }
    }

    private static void closeConnectionQuietly(Connection connection) {
        try {
            connection.close();
        }
        catch (Exception exception) {
            throw Utils.exception((Exception)exception, (String)"Error closing connection.", (Object[])new Object[0]);
        }
    }

    private static void createTestTable(Connection connection) {
        SqliteConnectionManagerTest.execute(connection, "CREATE TABLE IF NOT EXISTS test (key text, value text, CONSTRAINT pk_metadata PRIMARY KEY(key));", new Object[0]);
    }

    private static void insertInTestTable(Connection connection, String key, String value) {
        SqliteConnectionManagerTest.createTestTable(connection);
        SqliteConnectionManagerTest.execute(connection, "INSERT INTO test VALUES ('%s', '%s');", key, value);
    }

    private static String getFromTestTable(Connection connection, String key) {
        return new ExecuteQuery((Connection)connection, (String)"SELECT value FROM test WHERE key = '%s' ORDER BY key;", (Object[])new Object[]{key}){
            String result;

            @Override
            public void extract(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    this.result = resultSet.getString(1);
                }
            }
        }.result;
    }

    private static void execute(Connection connection, String sql, Object ... arguments) {
        String finalSql = String.format(sql, arguments);
        try (PreparedStatement statement = connection.prepareStatement(finalSql);){
            statement.execute();
        }
        catch (Exception exception) {
            throw Utils.exception((Exception)exception, (String)"Error executing SQL '%s'.", (Object[])new Object[]{finalSql});
        }
    }

    private static abstract class ExecuteQuery {
        public abstract void extract(ResultSet var1) throws Exception;

        public ExecuteQuery(Connection connection, String query, Object ... arguments) {
            String finalQuery = String.format(query, arguments);
            try (PreparedStatement statement = connection.prepareStatement(finalQuery);){
                this.extract(statement.executeQuery());
            }
            catch (Exception exception) {
                throw Utils.exception((Exception)exception, (String)"Error executing query '%s'.", (Object[])new Object[]{finalQuery});
            }
        }
    }
}

