/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.sqlite;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.geotools.util.logging.Logging;
import org.geowebcache.io.Resource;
import org.geowebcache.sqlite.MbtilesBlobStore;
import org.geowebcache.sqlite.MbtilesInfo;
import org.geowebcache.sqlite.SqliteConnectionManager;
import org.geowebcache.sqlite.Utils;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.blobstore.file.FileBlobStore;

final class SqlitlePerf {
    private static Logger LOGGER = Logging.getLogger((String)SqlitlePerf.class.getName());
    static final int WORKERS = 10;
    static final int TILES = 1000000;

    SqlitlePerf() {
    }

    public static void main(String[] args) throws Exception {
        Class.forName("org.sqlite.JDBC");
        File rootDirectory = Files.createTempDirectory("gwc-", new FileAttribute[0]).toFile();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info(String.format("Root directory '%s'.", rootDirectory));
        }
        long[][] tiles = new long[1000000][3];
        File seedDirectory = SqlitlePerf.seedFileSystem(rootDirectory, tiles);
        SqlitlePerf.fileStore(seedDirectory, tiles);
        FileUtils.deleteDirectory((File)seedDirectory);
        File seedFile = SqlitlePerf.createSeedFile(rootDirectory, tiles);
        SqlitlePerf.rawSqlitle(rootDirectory, seedFile, tiles);
        SqlitlePerf.pooledSqlitle(rootDirectory, seedFile, tiles);
        SqlitlePerf.mbtilesStore(rootDirectory, seedFile, tiles);
        FileUtils.deleteDirectory((File)rootDirectory);
    }

    private static void rawSqlitle(File rootDirectory, File seedFile, long[][] tiles) throws Exception {
        File databaseFile = new File(rootDirectory, "raw_perf_test.sqlite");
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info(String.format("Start raw select from file '%s'.", databaseFile));
        }
        FileUtils.copyFile((File)seedFile, (File)databaseFile);
        ExecutorService executor = Executors.newFixedThreadPool(10);
        long startTime = System.currentTimeMillis();
        try (Connection connection = DriverManager.getConnection("jdbc:sqlite:" + seedFile.getPath());){
            for (int i = 0; i < tiles.length; ++i) {
                long[] tile = tiles[i];
                executor.submit(() -> SqlitlePerf.getTile(connection, tile));
                if (i == 0 || i % 10000 != 0 || !LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.fine(String.format("Submitted %d select tasks.", i));
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("Submitted %d select tasks.", 1000000));
            }
            executor.shutdown();
            executor.awaitTermination(5L, TimeUnit.MINUTES);
            long endTime = System.currentTimeMillis();
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info(String.format("Tiles raw select time '%d'.", endTime - startTime));
            }
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info(String.format("Tiles raw selected per second '%f'.", Float.valueOf(1000000.0f / (float)(endTime - startTime) * 1000.0f)));
            }
        }
        FileUtils.deleteQuietly((File)databaseFile);
    }

    private static void pooledSqlitle(File rootDirectory, File seedFile, long[][] tiles) throws Exception {
        File databaseFile = new File(rootDirectory, "pooled_perf_test.sqlite");
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info(String.format("Start pooled select from file '%s'.", databaseFile));
        }
        FileUtils.copyFile((File)seedFile, (File)databaseFile);
        ExecutorService executor = Executors.newFixedThreadPool(10);
        SqliteConnectionManager connectionManager = new SqliteConnectionManager(10L, 2000L);
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < tiles.length; ++i) {
            long[] tile = tiles[i];
            executor.submit(() -> connectionManager.doWork(databaseFile, true, connection -> SqlitlePerf.getTile(connection, tile)));
            if (i == 0 || i % 10000 != 0 || !LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.fine(String.format("Submitted %d select tasks.", i));
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("Submitted %d select tasks.", 1000000));
        }
        executor.shutdown();
        executor.awaitTermination(5L, TimeUnit.MINUTES);
        long endTime = System.currentTimeMillis();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info(String.format("Tiles pooled select time '%d'.", endTime - startTime));
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info(String.format("Tiles pooled selected per second '%f'.", Float.valueOf(1000000.0f / (float)(endTime - startTime) * 1000.0f)));
        }
        connectionManager.reapAllConnections();
        connectionManager.stopPoolReaper();
        FileUtils.deleteQuietly((File)databaseFile);
    }

    private static void mbtilesStore(File rootDirectory, File seedFile, long[][] tiles) throws Exception {
        File databaseFile = new File(rootDirectory, Utils.buildPath((String[])new String[]{"grid", "layer", "image_png", "mbtiles_perf_test.sqlite"}));
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info(String.format("Start mbtiles select from file '%s'.", databaseFile));
        }
        FileUtils.copyFile((File)seedFile, (File)databaseFile);
        ExecutorService executor = Executors.newFixedThreadPool(10);
        long startTime = System.currentTimeMillis();
        MbtilesInfo configuration = new MbtilesInfo();
        configuration.setRootDirectory(rootDirectory.getPath());
        configuration.setTemplatePath(Utils.buildPath((String[])new String[]{"{grid}", "{layer}", "{format}", "mbtiles_perf_test.sqlite"}));
        configuration.setUseCreateTime(false);
        SqliteConnectionManager connectionManager = new SqliteConnectionManager(10L, 2000L);
        MbtilesBlobStore mbtilesBlobStore = new MbtilesBlobStore(configuration, connectionManager);
        for (int i = 0; i < tiles.length; ++i) {
            long[] tile = tiles[i];
            executor.submit(() -> {
                TileObject mbtile = TileObject.createQueryTileObject((String)"layer", (long[])tile, (String)"grid", (String)"image/png", null);
                try {
                    mbtilesBlobStore.get(mbtile);
                }
                catch (Exception exception) {
                    throw Utils.exception((Exception)exception, (String)"Error retrieving tile '%s'.", (Object[])new Object[]{mbtile});
                }
            });
            if (i == 0 || i % 10000 != 0 || !LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.fine(String.format("Submitted %d select tasks.", i));
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("Submitted %d select tasks.", 1000000));
        }
        executor.shutdown();
        executor.awaitTermination(5L, TimeUnit.MINUTES);
        long endTime = System.currentTimeMillis();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info(String.format("Tiles mbtiles blobstore select time '%d'.", endTime - startTime));
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info(String.format("Tiles mbtiles blobstore selected per second '%f'.", Float.valueOf(1000000.0f / (float)(endTime - startTime) * 1000.0f)));
        }
        connectionManager.reapAllConnections();
        connectionManager.stopPoolReaper();
        FileUtils.deleteQuietly((File)databaseFile);
    }

    private static void fileStore(File seedDirectory, long[][] tiles) throws Exception {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info(String.format("Start reading from directory'%s'.", seedDirectory));
        }
        ExecutorService executor = Executors.newFixedThreadPool(10);
        long startTime = System.currentTimeMillis();
        FileBlobStore fileBlobStore = new FileBlobStore(seedDirectory.getPath());
        for (int i = 0; i < tiles.length; ++i) {
            long[] tile = tiles[i];
            executor.submit(() -> SqlitlePerf.lambda$fileStore$4(tile, (BlobStore)fileBlobStore));
            if (i == 0 || i % 10000 != 0 || !LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.fine(String.format("Submitted %d read tasks.", i));
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("Submitted %d read tasks.", 1000000));
        }
        executor.shutdown();
        executor.awaitTermination(5L, TimeUnit.MINUTES);
        long endTime = System.currentTimeMillis();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info(String.format("Tiles file blobstore read time '%d'.", endTime - startTime));
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info(String.format("Tiles file blobstore reads per second '%f'.", Float.valueOf(1000000.0f / (float)(endTime - startTime) * 1000.0f)));
        }
    }

    private static File seedFileSystem(File rootDirectory, long[][] tiles) throws Exception {
        File seedDirectory = new File(rootDirectory, "tiles");
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info(String.format("Start seeding file system '%s'.", seedDirectory));
        }
        FileBlobStore fileBlobStore = new FileBlobStore(seedDirectory.getPath());
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            Tile tile = Tile.random();
            tiles[i][0] = tile.x;
            tiles[i][1] = tile.y;
            tiles[i][2] = tile.z;
            fileBlobStore.put(TileObject.createCompleteTileObject((String)"layer", (long[])new long[]{tile.x, tile.y, tile.z}, (String)"epsg:4326", (String)"image/png", null, (Resource)Utils.byteArrayToResource((byte[])tile.data)));
            if (i == 0 || i % 10000 != 0 || !LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.fine(String.format("Stored %d tiles.", i));
        }
        long endTime = System.currentTimeMillis();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info(String.format("Insert time '%d' (batch mode).", endTime - startTime));
        }
        return seedDirectory;
    }

    private static File createSeedFile(File rootDirectory, long[][] tiles) throws Exception {
        File seedFile = new File(rootDirectory, "seed_perf_test.sqlite");
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info(String.format("Start seeding file '%s'.", seedFile));
        }
        try (Connection connection = DriverManager.getConnection("jdbc:sqlite:" + seedFile.getPath());){
            String createTableSql = "CREATE TABLE IF NOT EXISTS tiles (zoom_level integer, tile_column integer, tile_row integer, tile_data blob, CONSTRAINT pk_tiles PRIMARY KEY(zoom_level, tile_column,tile_row));";
            SqlitlePerf.executeSql(connection, createTableSql);
            long startTime = System.currentTimeMillis();
            SqlitlePerf.executeSql(connection, "BEGIN TRANSACTION;");
            String sql = "INSERT OR REPLACE INTO tiles VALUES(?, ?, ?, ?);";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                for (int i = 0; i < 1000000; ++i) {
                    Tile tile = Tile.random();
                    tiles[i][0] = tile.x;
                    tiles[i][1] = tile.y;
                    tiles[i][2] = tile.z;
                    statement.setLong(1, tile.z);
                    statement.setLong(2, tile.x);
                    statement.setLong(3, tile.y);
                    statement.setBytes(4, tile.data);
                    statement.addBatch();
                    if (i == 0 || i % 10000 != 0) continue;
                    statement.executeBatch();
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.fine(String.format("Inserted batch %d.", i));
                }
                statement.executeBatch();
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(String.format("Inserted batch %d.", 1000000));
                }
            }
            catch (Exception exception) {
                throw Utils.exception((Exception)exception, (String)"Error executing SQL '%s'.", (Object[])new Object[]{sql});
            }
            SqlitlePerf.executeSql(connection, "END TRANSACTION;");
            long endTime = System.currentTimeMillis();
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info(String.format("Insert time '%d' (batch mode).", endTime - startTime));
            }
        }
        return seedFile;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static byte[] getTile(Connection connection, long[] xyz) {
        String sql = "SELECT tile_data FROM tiles WHERE zoom_level = ? AND tile_column = ? AND tile_row = ?;";
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            byte[] byArray;
            block20: {
                ResultSet resultSet;
                block18: {
                    byte[] byArray2;
                    block19: {
                        statement.setLong(1, xyz[2]);
                        statement.setLong(2, xyz[0]);
                        statement.setLong(3, xyz[1]);
                        resultSet = statement.executeQuery();
                        try {
                            if (!resultSet.next()) break block18;
                            byte[] data = resultSet.getBytes(1);
                            if (data.length != 2024 && LOGGER.isLoggable(Level.SEVERE)) {
                                LOGGER.log(Level.SEVERE, String.format("Tile %d-%d-%d data is not valid.", xyz[2], xyz[0], xyz[1]));
                            }
                            byArray2 = data;
                            if (resultSet == null) break block19;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return byArray2;
                }
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, String.format("Failed to load tile %d-%d-%d.", xyz[2], xyz[0], xyz[1]));
                }
                byArray = null;
                if (resultSet == null) break block20;
                resultSet.close();
            }
            return byArray;
        }
        catch (Exception exception) {
            throw Utils.exception((Exception)exception, (String)"Error executing SQL '%s'.", (Object[])new Object[]{sql});
        }
    }

    private static void executeSql(Connection connection, String sql) {
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.execute();
        }
        catch (Exception exception) {
            throw Utils.exception((Exception)exception, (String)"Error executing SQL '%s'.", (Object[])new Object[]{sql});
        }
    }

    private static /* synthetic */ void lambda$fileStore$4(long[] tile, BlobStore fileBlobStore) {
        TileObject mbtile = TileObject.createQueryTileObject((String)"layer", (long[])tile, (String)"grid", (String)"image/png", null);
        try {
            fileBlobStore.get(mbtile);
        }
        catch (Exception exception) {
            throw Utils.exception((Exception)exception, (String)"Error retrieving tile '%s'.", (Object[])new Object[]{mbtile});
        }
    }

    private static final class Tile {
        private static final Random random = new Random();
        final long x;
        final long y;
        final long z;
        final byte[] data;

        private Tile(long x, long y, long z, byte[] data) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.data = data;
        }

        static Tile random() {
            byte[] data = new byte[2024];
            random.nextBytes(data);
            return new Tile(random.nextInt(1000000), random.nextInt(1000000), random.nextInt(10), data);
        }
    }
}

