/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.sqlite;

import java.io.File;
import java.io.FileWriter;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;
import org.geowebcache.sqlite.MbtilesBlobStore;
import org.geowebcache.sqlite.MbtilesInfo;
import org.geowebcache.sqlite.Utils;
import org.junit.After;
import org.junit.Before;

public abstract class TestSupport {
    private File rootDirectory;
    private List<File> filesToDelete;
    private List<MbtilesBlobStore> storesToClean;

    @Before
    public void beforeTest() throws Exception {
        this.rootDirectory = Files.createTempDirectory("gwc-", new FileAttribute[0]).toFile();
        this.filesToDelete = new ArrayList<File>();
        this.filesToDelete.add(this.rootDirectory);
        this.storesToClean = new ArrayList<MbtilesBlobStore>();
    }

    @After
    public void afterTest() throws Exception {
        for (MbtilesBlobStore store : this.storesToClean) {
            try {
                store.destroy();
            }
            catch (Exception exception) {}
        }
        for (File file : this.filesToDelete) {
            if (!file.exists()) continue;
            FileUtils.forceDelete((File)file);
        }
    }

    protected File getRootDirectory() {
        return this.rootDirectory;
    }

    protected String getRootDirectoryPath() {
        try {
            return this.rootDirectory.getCanonicalPath();
        }
        catch (Exception exception) {
            throw Utils.exception((Exception)exception, (String)"Error getting root directory canonical path.", (Object[])new Object[0]);
        }
    }

    protected File createFileInRootDir(String path) throws Exception {
        File file = new File(this.rootDirectory, path);
        if (file.exists()) {
            return null;
        }
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        file.createNewFile();
        return file;
    }

    protected File buildRootFile(String ... pathParts) {
        return new File(this.rootDirectory, Utils.buildPath((String[])pathParts));
    }

    protected File buildFile(String ... pathParts) {
        return new File(Utils.buildPath((String[])pathParts));
    }

    protected void writeToFile(File file, String content) {
        Utils.createFileParents((File)file);
        try (FileWriter writer = new FileWriter(file);){
            writer.write(content);
            writer.flush();
        }
        catch (Exception exception) {
            throw Utils.exception((Exception)exception, (String)"Error creating or writing content to file '%s'.", (Object[])new Object[]{file});
        }
    }

    protected MbtilesInfo getDefaultConfiguration() {
        MbtilesInfo configuration = new MbtilesInfo();
        configuration.setPoolSize(1000L);
        configuration.setRootDirectory(this.getRootDirectory().getPath());
        configuration.setTemplatePath(Utils.buildPath((String[])new String[]{"{grid}", "{layer}", "{format}", "{z}", "tiles-{x}-{y}.sqlite"}));
        configuration.setRowRangeCount(500L);
        configuration.setColumnRangeCount(500L);
        return configuration;
    }

    protected static Resource stringToResource(String string) {
        return new ByteArrayResource(string.getBytes());
    }

    protected static String resourceToString(Resource resource) {
        return new String(Utils.resourceToByteArray((Resource)resource));
    }

    protected void addStoresToClean(MbtilesBlobStore ... stores) {
        for (MbtilesBlobStore store : stores) {
            this.storesToClean.add(store);
        }
    }

    protected void addFilesToDelete(File ... files) {
        for (File file : files) {
            this.filesToDelete.add(file);
        }
    }
}

