/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.sqlite;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geotools.util.logging.Logging;
import org.geowebcache.filter.parameters.ParametersUtils;
import org.geowebcache.sqlite.Utils;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.TileRange;

final class FileManager {
    private static Logger LOGGER = Logging.getLogger((String)FileManager.class.getName());
    private static final Pattern PATH_TEMPLATE_ATTRIBUTE_PATTERN = Pattern.compile("\\{(.+?)\\}");
    private final File rootPath;
    private final long rowRangeCount;
    private final long columnRangeCount;
    private final String[] pathBuilderOriginal;
    private final Utils.Tuple<Boolean, Integer> replaceParametersId;
    private final Utils.Tuple<Boolean, Integer> replaceZoom;
    private final Utils.Tuple<Boolean, Integer> replaceRow;
    private final Utils.Tuple<Boolean, Integer> replaceColumn;
    private final Utils.Tuple<Boolean, Integer> replaceLayerName;
    private final Utils.Tuple<Boolean, Integer> replaceGridSetId;
    private final Utils.Tuple<Boolean, Integer> replaceFormat;
    private final Set<Utils.Tuple<String, Integer>> replaceParameters;

    FileManager(File rootDirectory, String pathTemplate, long rowRangeCount, long columnRangeCount) {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info(String.format("Initiating file manager: [rootDirectory='%s', pathTemplate='%s', rowRangeCount='%d', columnRangeCount='%d'].", rootDirectory, pathTemplate, rowRangeCount, columnRangeCount));
        }
        this.rootPath = rootDirectory;
        this.rowRangeCount = rowRangeCount;
        this.columnRangeCount = columnRangeCount;
        Utils.Tuple<String[], Set<Utils.Tuple<String, Integer>>> parserResult = FileManager.parsePathTemplate(rootDirectory.getPath(), pathTemplate);
        this.pathBuilderOriginal = (String[])parserResult.first;
        this.replaceParametersId = FileManager.findAndRemove((Set)parserResult.second, "params");
        this.replaceZoom = FileManager.findAndRemove((Set)parserResult.second, "z");
        this.replaceRow = FileManager.findAndRemove((Set)parserResult.second, "x");
        this.replaceColumn = FileManager.findAndRemove((Set)parserResult.second, "y");
        this.replaceLayerName = FileManager.findAndRemove((Set)parserResult.second, "layer");
        this.replaceGridSetId = FileManager.findAndRemove((Set)parserResult.second, "grid");
        this.replaceFormat = FileManager.findAndRemove((Set)parserResult.second, "format");
        this.replaceParameters = (Set)parserResult.second;
    }

    File getFile(TileObject tile) {
        if (tile.getParametersId() == null && tile.getParameters() != null) {
            tile.setParametersId(ParametersUtils.getId((Map)tile.getParameters()));
        }
        return this.getFile(tile.getParametersId(), tile.getXYZ(), tile.getLayerName(), tile.getGridSetId(), tile.getBlobFormat(), tile.getParameters());
    }

    File getFile(String parametersId, long[] xyz, String layerName, String gridSetId, String format, Map<String, String> parameters) {
        String[] pathBuilderCopy = this.getPathBuilderCopy();
        if (((Boolean)this.replaceParametersId.first).booleanValue()) {
            pathBuilderCopy[((Integer)this.replaceParametersId.second).intValue()] = FileManager.normalizeAttributeValue("params", FileManager.handleParametersId(parametersId, parameters));
        }
        if (((Boolean)this.replaceZoom.first).booleanValue()) {
            pathBuilderCopy[((Integer)this.replaceZoom.second).intValue()] = String.valueOf(FileManager.getLongValue(xyz, 2));
        }
        if (((Boolean)this.replaceRow.first).booleanValue()) {
            pathBuilderCopy[((Integer)this.replaceRow.second).intValue()] = String.valueOf(this.computeColumnRange(FileManager.getLongValue(xyz, 0)));
        }
        if (((Boolean)this.replaceColumn.first).booleanValue()) {
            pathBuilderCopy[((Integer)this.replaceColumn.second).intValue()] = String.valueOf(this.computeRowRange(FileManager.getLongValue(xyz, 1)));
        }
        if (((Boolean)this.replaceLayerName.first).booleanValue()) {
            pathBuilderCopy[((Integer)this.replaceLayerName.second).intValue()] = FileManager.normalizeAttributeValue("layer", layerName);
        }
        if (((Boolean)this.replaceGridSetId.first).booleanValue()) {
            pathBuilderCopy[((Integer)this.replaceGridSetId.second).intValue()] = FileManager.normalizeAttributeValue("grid", gridSetId);
        }
        if (((Boolean)this.replaceFormat.first).booleanValue()) {
            pathBuilderCopy[((Integer)this.replaceFormat.second).intValue()] = FileManager.normalizeAttributeValue("format", format);
        }
        for (Utils.Tuple<String, Integer> replaceParameter : this.replaceParameters) {
            String value = parameters.get(((String)replaceParameter.first).toUpperCase());
            value = value == null ? parameters.get(((String)replaceParameter.first).toLowerCase()) : value;
            pathBuilderCopy[((Integer)replaceParameter.second).intValue()] = value = value == null ? "null" : FileManager.normalizeAttributeValue((String)replaceParameter.first, value);
        }
        return new File(FileManager.concatStringArray(pathBuilderCopy, 0));
    }

    List<File> getFiles(String layerName) {
        String[] pathBuilderCopy = this.getPathBuilderCopy();
        if (((Boolean)this.replaceLayerName.first).booleanValue()) {
            pathBuilderCopy[((Integer)this.replaceLayerName.second).intValue()] = layerName;
        }
        return this.getFiles(pathBuilderCopy);
    }

    List<File> getFiles(String layerName, String gridSetId) {
        String[] pathBuilderCopy = this.getPathBuilderCopy();
        if (((Boolean)this.replaceLayerName.first).booleanValue()) {
            pathBuilderCopy[((Integer)this.replaceLayerName.second).intValue()] = layerName;
        }
        if (((Boolean)this.replaceGridSetId.first).booleanValue()) {
            pathBuilderCopy[((Integer)this.replaceGridSetId.second).intValue()] = gridSetId;
        }
        return this.getFiles(pathBuilderCopy);
    }

    List<File> getParametersFiles(String layerName, String parametersId) {
        String[] pathBuilderCopy = this.getPathBuilderCopy();
        if (((Boolean)this.replaceLayerName.first).booleanValue()) {
            pathBuilderCopy[((Integer)this.replaceLayerName.second).intValue()] = layerName;
        }
        if (((Boolean)this.replaceParametersId.first).booleanValue()) {
            pathBuilderCopy[((Integer)this.replaceParametersId.second).intValue()] = parametersId;
        }
        return this.getFiles(pathBuilderCopy);
    }

    Map<File, List<long[]>> getFiles(TileRange tileRange) {
        HashMap<File, List<long[]>> files = new HashMap<File, List<long[]>>();
        for (int z = tileRange.getZoomStart(); z <= tileRange.getZoomStop(); ++z) {
            long[] range = tileRange.rangeBounds(z);
            if (range == null) continue;
            this.getFiles(files, tileRange.getParametersId(), tileRange.getLayerName(), tileRange.getGridSetId(), tileRange.getMimeType().getFormat(), tileRange.getParameters(), z, range);
        }
        return files;
    }

    public static String normalizePathValue(String value) {
        return value.replaceAll("\\\\|/|:|(?:\\s+)", "_");
    }

    private void getFiles(Map<File, List<long[]>> files, String parametersId, String layerName, String gridSetId, String format, Map<String, String> parameters, long z, long[] range) {
        long minRangeX = range[0] / this.columnRangeCount * this.columnRangeCount;
        long maxRangeX = range[2] / this.columnRangeCount * this.rowRangeCount;
        long minRangeY = range[1] / this.rowRangeCount * this.rowRangeCount;
        long maxRangeY = range[3] / this.rowRangeCount * this.rowRangeCount;
        for (long x = minRangeX; x <= maxRangeX; x += this.columnRangeCount) {
            long minx = Math.max(x, range[0]);
            long maxx = Math.min(x + this.columnRangeCount - 1L, range[2]);
            for (long y = minRangeY; y <= maxRangeY; y += this.rowRangeCount) {
                long[] tile = new long[]{x, y, z};
                File file = this.getFile(parametersId, tile, layerName, gridSetId, format, parameters);
                long miny = Math.max(y, range[1]);
                long maxy = Math.min(y + this.rowRangeCount - 1L, range[3]);
                List<long[]> ranges = files.get(file);
                if (ranges == null) {
                    ranges = new ArrayList<long[]>();
                    files.put(file, ranges);
                }
                ranges.add(new long[]{minx, miny, maxx, maxy, z});
            }
        }
    }

    private static String handleParametersId(String parametersId, Map<String, String> parameters) {
        if (parametersId != null) {
            return parametersId;
        }
        String computedParametersId = ParametersUtils.getId(parameters);
        if (computedParametersId == null) {
            return "null";
        }
        return computedParametersId;
    }

    private static String normalizeAttributeValue(String attribute, String value) {
        Utils.check(value != null, "Path template attribute '%s' value is NULL.", attribute);
        return FileManager.normalizePathValue(value);
    }

    private static long getLongValue(long[] xyz, int index) {
        Utils.check(xyz != null, "Path template attribute 'xyz' is NULL.", new Object[0]);
        Utils.check(xyz.length == 3, "Path template attribute 'xyz' doesn't have the correct length.", new Object[0]);
        return xyz[index];
    }

    private List<File> getFiles(String[] pathBuilderCopy) {
        String pathRegex = FileManager.concatStringArray(pathBuilderCopy, 1);
        String[] pathRegexParts = pathRegex.split(Utils.REGEX_FILE_SEPARATOR);
        return FileManager.walkFileTreeWithRegex(this.rootPath, 0, pathRegexParts);
    }

    private static List<File> walkFileTreeWithRegex(File path, int level, String[] pathParts) {
        File[] files = path.listFiles((directory, name) -> {
            String pathPart = pathParts[level];
            return pathPart.equals(name) || name.matches(pathPart);
        });
        if (Objects.isNull(files)) {
            return Collections.emptyList();
        }
        if (level != pathParts.length - 1) {
            ArrayList<File> matchedFiles = new ArrayList<File>();
            for (File file : files) {
                matchedFiles.addAll(FileManager.walkFileTreeWithRegex(file, level + 1, pathParts));
            }
            return matchedFiles;
        }
        return Arrays.asList(files);
    }

    private static String concatStringArray(String[] array, int startIndex) {
        StringBuilder result = new StringBuilder();
        for (int i = startIndex; i < array.length; ++i) {
            result.append(array[i]);
        }
        return result.toString();
    }

    private String[] getPathBuilderCopy() {
        String[] pathBuilderCopy = new String[this.pathBuilderOriginal.length];
        System.arraycopy(this.pathBuilderOriginal, 0, pathBuilderCopy, 0, this.pathBuilderOriginal.length);
        return pathBuilderCopy;
    }

    private static Utils.Tuple<Boolean, Integer> findAndRemove(Set<Utils.Tuple<String, Integer>> attributes, String attribute) {
        Utils.Tuple<String, Integer> found = null;
        for (Utils.Tuple<String, Integer> candidateAttribute : attributes) {
            if (!((String)candidateAttribute.first).equals(attribute)) continue;
            if (found != null) {
                throw Utils.exception("Term '%s' appears multiple times in the path template.", attribute);
            }
            found = candidateAttribute;
        }
        if (found != null) {
            attributes.remove(found);
            return Utils.Tuple.tuple(true, (Integer)found.second);
        }
        return Utils.Tuple.tuple(false, -1);
    }

    private static Utils.Tuple<String[], Set<Utils.Tuple<String, Integer>>> parsePathTemplate(String rootPath, String pathTemplate) {
        pathTemplate = pathTemplate.replaceAll("(\\\\)|/", Utils.REGEX_FILE_SEPARATOR);
        ArrayList<Object> pathBuilder = new ArrayList<Object>();
        pathBuilder.add(rootPath + File.separator);
        HashSet<Utils.Tuple<String, Integer>> attributes = new HashSet<Utils.Tuple<String, Integer>>();
        Matcher matcher = PATH_TEMPLATE_ATTRIBUTE_PATTERN.matcher(pathTemplate);
        int lastMatchIndex = 0;
        int pathBuilderIndex = 1;
        while (matcher.find()) {
            pathBuilder.add(pathTemplate.substring(lastMatchIndex, matcher.start()));
            pathBuilder.add(".*?");
            String attribute = matcher.group(1).toLowerCase();
            attributes.add(Utils.Tuple.tuple(attribute, pathBuilderIndex + 1));
            pathBuilderIndex += 2;
            lastMatchIndex = matcher.end();
        }
        pathBuilder.add(pathTemplate.substring(lastMatchIndex, pathTemplate.length()));
        return Utils.Tuple.tuple(pathBuilder.toArray(new String[pathBuilder.size()]), attributes);
    }

    private long computeRowRange(long tileRow) {
        return tileRow / this.rowRangeCount * this.rowRangeCount;
    }

    private long computeColumnRange(long tileRow) {
        return tileRow / this.columnRangeCount * this.columnRangeCount;
    }
}

