/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.sqlite;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.geotools.jdbc.util.SqlUtil;
import org.geotools.mbtiles.MBTilesFile;
import org.geotools.mbtiles.MBTilesMetadata;
import org.geotools.mbtiles.MBTilesTile;
import org.geotools.util.logging.Logging;
import org.geowebcache.filter.parameters.ParametersUtils;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.sqlite.FileManager;
import org.geowebcache.sqlite.GeoToolsMbtilesUtils;
import org.geowebcache.sqlite.MbtilesInfo;
import org.geowebcache.sqlite.SqliteBlobStore;
import org.geowebcache.sqlite.SqliteConnectionManager;
import org.geowebcache.sqlite.Utils;
import org.geowebcache.storage.BlobStoreListener;
import org.geowebcache.storage.BlobStoreListenerList;
import org.geowebcache.storage.CompositeBlobStore;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.TileRange;

public final class MbtilesBlobStore
extends SqliteBlobStore {
    private static Logger LOGGER = Logging.getLogger((String)MbtilesBlobStore.class.getName());
    private static final Pattern MBTILES_METADATA_FILE_NAME_PATTERN = Pattern.compile("(.*?)\\.properties");
    private final File metadataFile;
    private final boolean eagerDelete;
    private final boolean useCreateTime;
    private final BlobStoreListenerList listeners;
    private final Map<String, MBTilesMetadata> layersMetadata = new ConcurrentHashMap<String, MBTilesMetadata>();
    private final ExecutorService executorService;
    private final boolean gzipVector;

    MbtilesBlobStore(MbtilesInfo configuration) throws StorageException {
        this(configuration, new SqliteConnectionManager(configuration.getPoolSize(), configuration.getPoolReaperIntervalMs()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MbtilesBlobStore(MbtilesInfo configuration, SqliteConnectionManager connectionManager) throws StorageException {
        super(configuration, connectionManager);
        this.metadataFile = new File(configuration.getRootDirectoryFile(), "metadata.sqlite");
        boolean exists = this.metadataFile.exists();
        boolean empty = true;
        if (!configuration.getRootDirectoryFile().exists()) throw new StorageException("Root directory file does not exist: " + String.valueOf(configuration.getRootDirectoryFile()));
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(configuration.getRootDirectoryFile().toPath());){
            Iterator<Path> iterator = ds.iterator();
            if (iterator.hasNext()) {
                Path p = iterator.next();
                LOGGER.severe("Found file: " + String.valueOf(p));
                empty = false;
            }
        }
        catch (StorageException e) {
            throw e;
        }
        catch (IOException e) {
            throw new StorageException("Error while checking that " + configuration.getRootDirectory() + " is empty", (Throwable)e);
        }
        CompositeBlobStore.checkSuitability((String)configuration.getRootDirectory(), (boolean)exists, (boolean)empty);
        this.eagerDelete = configuration.eagerDelete();
        this.useCreateTime = configuration.useCreateTime();
        this.executorService = Executors.newFixedThreadPool(configuration.getExecutorConcurrency());
        this.listeners = new BlobStoreListenerList();
        this.gzipVector = configuration.isGzipVector();
        this.initMbtilesLayersMetadata(configuration.getMbtilesMetadataDirectory());
        if (!LOGGER.isLoggable(Level.INFO)) return;
        LOGGER.info(String.format("MBTiles blob store initiated: [eagerDelete='%b', useCreateTime='%b'.", this.eagerDelete, this.useCreateTime));
    }

    private boolean tileIsGzipped(TileObject tile) throws MimeException {
        return this.gzipVector && MimeType.createFromFormat((String)tile.getBlobFormat()).isVector();
    }

    public void put(TileObject tile) throws StorageException {
        File file = this.fileManager.getFile(tile);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("Tile '%s' mapped to file '%s'.", tile, file));
        }
        this.initDatabaseFileIfNeeded(file, tile.getLayerName(), tile.getBlobFormat());
        this.connectionManager.doWork(file, false, connection -> {
            MBTilesFile mbtiles = GeoToolsMbtilesUtils.getMBTilesFile(connection, file);
            MBTilesTile gtTile = new MBTilesTile(tile.getXYZ()[2], tile.getXYZ()[0], tile.getXYZ()[1]);
            try {
                byte[] bytes;
                block19: {
                    boolean gzipped = this.tileIsGzipped(tile);
                    if (gzipped) {
                        try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                             GZIPOutputStream gzOut = new GZIPOutputStream(byteStream);){
                            bytes = byteStream.toByteArray();
                            break block19;
                        }
                    }
                    bytes = Utils.resourceToByteArray(tile.getBlob());
                }
                gtTile.setData(bytes);
                byte[] olData = null;
                if (!this.listeners.isEmpty()) {
                    olData = mbtiles.loadTile(tile.getXYZ()[2], tile.getXYZ()[0], tile.getXYZ()[1]).getData();
                }
                mbtiles.saveTile(gtTile);
                if (this.useCreateTime) {
                    this.putTileCreateTime(connection, tile.getXYZ()[2], tile.getXYZ()[0], tile.getXYZ()[1], System.currentTimeMillis());
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(String.format("Tile '%s' saved in file '%s'.", tile, file));
                }
                if (this.listeners.isEmpty()) {
                    return;
                }
                if (olData == null) {
                    this.listeners.sendTileStored(tile);
                } else {
                    this.listeners.sendTileUpdated(tile, (long)olData.length);
                }
            }
            catch (Exception exception) {
                throw Utils.exception(exception, "Error saving tile '%s' in file '%s'.", tile, file);
            }
        });
        this.persistParameterMap(tile);
    }

    public boolean get(TileObject tile) throws StorageException {
        File file = this.fileManager.getFile(tile);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("Tile '%s' mapped to file '%s'.", tile, file));
        }
        this.initDatabaseFileIfNeeded(file, tile.getLayerName(), tile.getBlobFormat());
        boolean exists = this.connectionManager.doWork(file, true, connection -> {
            block25: {
                try (MBTilesFile mbtiles = GeoToolsMbtilesUtils.getMBTilesFile(connection, file);){
                    byte[] bytes;
                    block26: {
                        boolean gzipped = this.tileIsGzipped(tile);
                        MBTilesTile gtTile = mbtiles.loadTile(tile.getXYZ()[2], tile.getXYZ()[0], tile.getXYZ()[1]);
                        bytes = gtTile.getData();
                        if (gtTile.getData() == null) break block25;
                        if (gzipped) {
                            try (ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                                 ByteArrayInputStream byteIn = new ByteArrayInputStream(gtTile.getData());
                                 GZIPInputStream gzIn = new GZIPInputStream(byteIn);){
                                IOUtils.copy((InputStream)gzIn, (OutputStream)byteOut);
                                bytes = byteOut.toByteArray();
                                break block26;
                            }
                        }
                        bytes = gtTile.getData();
                    }
                    tile.setBlob(Utils.byteArrayToResource(bytes));
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(String.format("Tile '%s' found on file '%s'.", tile, file));
                    }
                    Boolean bl = true;
                    return bl;
                }
                catch (Exception exception) {
                    throw Utils.exception(exception, "Error loading tile '%s' from MBTiles file '%s'.", tile, file);
                }
            }
            if (!LOGGER.isLoggable(Level.FINE)) return false;
            LOGGER.fine(String.format("Tile '%s' not found on file '%s'.", tile, file));
            return false;
        });
        if (exists && this.useCreateTime) {
            Long createdTime = this.getTileCreateTime(file, tile.getXYZ()[2], tile.getXYZ()[0], tile.getXYZ()[1]);
            if (createdTime == null) {
                createdTime = file.lastModified();
                this.putTileCreateTime(file, tile.getXYZ()[2], tile.getXYZ()[0], tile.getXYZ()[1], (long)createdTime);
            }
            tile.setCreated(createdTime.longValue());
        } else if (exists) {
            tile.setCreated(System.currentTimeMillis());
        }
        return exists;
    }

    public boolean delete(TileObject tile) throws StorageException {
        File file = this.fileManager.getFile(tile);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("Tile '%s' mapped to file '%s'.", tile, file));
        }
        if (!file.exists()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("Containing file '%s' for tile '%s' doesn't exists.", file, tile));
            }
            return false;
        }
        return this.connectionManager.doWork(file, false, connection -> {
            MBTilesFile mbtiles = GeoToolsMbtilesUtils.getMBTilesFile(connection, file);
            MBTilesTile gtTile = new MBTilesTile(tile.getXYZ()[2], tile.getXYZ()[0], tile.getXYZ()[1]);
            try {
                byte[] olData = mbtiles.loadTile(tile.getXYZ()[2], tile.getXYZ()[0], tile.getXYZ()[1]).getData();
                if (olData != null) {
                    tile.setBlobSize(olData.length);
                    mbtiles.saveTile(gtTile);
                    this.listeners.sendTileDeleted(tile);
                    if (this.useCreateTime) {
                        this.deleteTileCreateTime(connection, tile.getXYZ()[2], tile.getXYZ()[0], tile.getXYZ()[1]);
                    }
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(String.format("Tile '%s' deleted from file '%s'.", tile, file));
                    }
                    return true;
                }
            }
            catch (Exception exception) {
                throw Utils.exception(exception, "Error deleting tile '%s' from MBTiles file '%s'.", tile, file);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("Tile '%s' not found on file '%s'.", tile, file));
            }
            return false;
        });
    }

    public synchronized void putLayerMetadata(String layerName, String key, String value) {
        this.connectionManager.executeSql(this.metadataFile, "CREATE TABLE IF NOT EXISTS metadata (layerName text, key text, value text, PRIMARY KEY(layerName, key));", new Object[0]);
        this.connectionManager.executeSql(this.metadataFile, "INSERT OR REPLACE INTO metadata VALUES (?, ?, ?);", layerName, key, value);
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info(String.format("Metadata for layer '%s' for key '%s' inserted or updated on file '%s'.", layerName, key, this.metadataFile));
        }
    }

    public String getLayerMetadata(String layerName, String key) {
        try {
            return this.connectionManager.executeQuery(this.metadataFile, resultSet -> {
                try {
                    if (resultSet.next()) {
                        String value = resultSet.getString(1);
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine(String.format("Metadata for layer '%s' with key '%s' found '%s'.", layerName, key, value));
                        }
                        return value;
                    }
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(String.format("Metadata for layer '%s' with key '%s' not found.", layerName, key));
                    }
                    return null;
                }
                catch (Exception exception) {
                    throw Utils.exception(exception, "Error reading result set.", new Object[0]);
                }
            }, "SELECT value FROM metadata WHERE layerName = ? AND key = ?;", layerName, key);
        }
        catch (Exception exception) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, String.format("Error getting metadata from file '%s'.", this.metadataFile), exception);
            }
            return null;
        }
    }

    public boolean layerExists(String layerName) {
        return !this.fileManager.getFiles(layerName).isEmpty();
    }

    public boolean delete(String layerName) throws StorageException {
        boolean deleted = this.deleteFiles(this.fileManager.getFiles(layerName));
        this.listeners.sendLayerDeleted(layerName);
        return deleted;
    }

    public boolean deleteByGridsetId(String layerName, String gridSetId) throws StorageException {
        boolean deleted = this.deleteFiles(this.fileManager.getFiles(layerName, gridSetId));
        this.listeners.sendGridSubsetDeleted(layerName, gridSetId);
        return deleted;
    }

    public boolean deleteByParametersId(String layerName, String parametersId) throws StorageException {
        boolean deleted = this.deleteFiles(this.fileManager.getParametersFiles(layerName, parametersId));
        this.listeners.sendParametersDeleted(layerName, parametersId);
        return deleted;
    }

    public boolean delete(TileRange tileRange) throws StorageException {
        Map<File, List<long[]>> files = this.fileManager.getFiles(tileRange);
        if (files.isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Nothing to do.");
            }
            return false;
        }
        ExecutorCompletionService<Boolean> completionService = new ExecutorCompletionService<Boolean>(this.executorService);
        int tasks = 0;
        for (Map.Entry<File, List<long[]>> entry : files.entrySet()) {
            File file = entry.getKey();
            if (!file.exists()) continue;
            if (this.eagerDelete) {
                completionService.submit(() -> this.connectionManager.delete(file), true);
            } else {
                for (long[] range : entry.getValue()) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(String.format("Deleting tiles range [minx=%d, miny=%d, maxx=%d, maxxy=%d, zoom=%d] in file '%s'.", range[0], range[1], range[2], range[3], range[4], file));
                    }
                    completionService.submit(() -> this.connectionManager.executeSql(file, "DELETE FROM tiles WHERE zoom_level = ? AND tile_column BETWEEN ? AND ? AND tile_row BETWEEN ? AND ?;", range[4], range[0], range[2], range[1], range[3]), true);
                }
            }
            ++tasks;
        }
        for (int i = 0; i < tasks; ++i) {
            try {
                completionService.take().get();
                continue;
            }
            catch (Exception exception) {
                throw Utils.exception(exception, "Something bad happen when deleting tile range.", new Object[0]);
            }
        }
        return true;
    }

    public boolean rename(String oldLayerName, String newLayerName) throws StorageException {
        List<File> files = this.fileManager.getFiles(oldLayerName);
        if (files.isEmpty()) {
            return false;
        }
        for (File currentFile : files) {
            String normalizedLayerName = FileManager.normalizePathValue(newLayerName);
            File newFile = new File(currentFile.getPath().replace(oldLayerName, normalizedLayerName));
            this.connectionManager.rename(currentFile, newFile);
        }
        this.listeners.sendLayerRenamed(oldLayerName, newLayerName);
        return true;
    }

    public void addListener(BlobStoreListener listener) {
        this.listeners.addListener(listener);
    }

    public boolean removeListener(BlobStoreListener listener) {
        return this.listeners.removeListener(listener);
    }

    public void clear() throws StorageException {
        this.connectionManager.reapAllConnections();
    }

    @Override
    public void destroy() {
        block2: {
            this.connectionManager.reapAllConnections();
            this.connectionManager.stopPoolReaper();
            this.executorService.shutdown();
            try {
                this.executorService.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (Exception exception) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block2;
                LOGGER.log(Level.SEVERE, "Error when waiting for executor task to finish.", exception);
            }
        }
    }

    private boolean deleteFiles(List<File> files) throws StorageException {
        if (files.isEmpty()) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("No files to delete.");
            }
            return false;
        }
        ExecutorCompletionService<Boolean> completionService = new ExecutorCompletionService<Boolean>(this.executorService);
        int tasks = 0;
        for (File file : files) {
            completionService.submit(() -> this.connectionManager.delete(file), true);
            ++tasks;
        }
        for (int i = 0; i < tasks; ++i) {
            try {
                completionService.take().get();
                continue;
            }
            catch (Exception exception) {
                throw Utils.exception(exception, "Something bad happen when deleting files.", new Object[0]);
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Files deleted.");
        }
        return true;
    }

    private void deleteTileCreateTime(Connection connection, long z, long x, long y) throws StorageException {
        block2: {
            try {
                this.connectionManager.executeSql(connection, "DELETE FROM tiles_metadata WHERE zoom_level = ? AND tile_column = ? AND tile_row = ?", z, x, y);
            }
            catch (Exception exception) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block2;
                LOGGER.log(Level.SEVERE, String.format("Something bad happen when deleting create time for tile '%d-%d-%d'.", x, y, z), exception);
            }
        }
    }

    private Long getTileCreateTime(File file, long z, long x, long y) throws StorageException {
        String query = "SELECT create_time FROM tiles_metadata WHERE zoom_level = ? AND tile_column = ? AND tile_row = ?";
        try {
            return this.connectionManager.executeQuery(file, resultSet -> {
                if (resultSet.next()) {
                    return resultSet.getLong(1);
                }
                return null;
            }, query, z, x, y);
        }
        catch (Exception exception) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, String.format("Something bad happen when querying create time for tile '%d-%d-%d'.", x, y, z), exception);
            }
            return null;
        }
    }

    private void putTileCreateTime(File file, long z, long x, long y, long createTime) {
        this.connectionManager.doWork(file, false, connection -> this.putTileCreateTime(connection, z, x, y, createTime));
    }

    private void putTileCreateTime(Connection connection, long z, long x, long y, long createTime) {
        this.createTilesMetadataTable(connection);
        this.connectionManager.executeSql(connection, "INSERT OR REPLACE INTO tiles_metadata VALUES (?, ?, ?, ?);", z, x, y, createTime);
    }

    private void createTilesMetadataTable(Connection connection) {
        this.connectionManager.executeSql(connection, "CREATE TABLE IF NOT EXISTS tiles_metadata (zoom_level integer, tile_column integer, tile_row integer, create_time integer, CONSTRAINT pk_tiles PRIMARY KEY(zoom_level, tile_column,tile_row));", new Object[0]);
    }

    void initDatabaseFileIfNeeded(File file, String layerName, String format) {
        if (file.exists()) {
            return;
        }
        this.connectionManager.doWork(file, false, connection -> {
            try {
                SqlUtil.runScript((InputStream)this.getClass().getResourceAsStream("/org/geotools/mbtiles/mbtiles.sql"), (Connection)connection);
                this.createTilesMetadataTable(connection);
                this.insertMbtilesLayerMetadata(file, connection, layerName, format);
            }
            catch (Exception exception) {
                throw Utils.exception(exception, "Error running geotools mbtiles sql script.", new Object[0]);
            }
        });
    }

    private void insertMbtilesLayerMetadata(File file, Connection connection, String layerName, String format) {
        MBTilesMetadata gtMetadata = new MBTilesMetadata();
        gtMetadata.setName(layerName);
        if (format.contains("png")) {
            gtMetadata.setFormat(MBTilesMetadata.t_format.PNG);
        } else if (format.contains("jpeg")) {
            gtMetadata.setFormat(MBTilesMetadata.t_format.JPEG);
        } else if (format.contains("protobuf")) {
            gtMetadata.setFormat(MBTilesMetadata.t_format.PBF);
        }
        MBTilesMetadata existingMetadata = this.layersMetadata.get(FileManager.normalizePathValue(layerName));
        if (existingMetadata != null) {
            gtMetadata.setName(layerName);
            gtMetadata.setAttribution(existingMetadata.getAttribution());
            gtMetadata.setBounds(existingMetadata.getBounds());
            gtMetadata.setDescription(existingMetadata.getDescription());
            gtMetadata.setMaxZoom(existingMetadata.getMaxZoom());
            gtMetadata.setMinZoom(existingMetadata.getMinZoom());
            gtMetadata.setType(existingMetadata.getType());
            gtMetadata.setVersion(existingMetadata.getVersion());
        }
        try (MBTilesFile mbtiles = GeoToolsMbtilesUtils.getMBTilesFile(connection, file);){
            mbtiles.saveMetaData(gtMetadata);
        }
        catch (Exception exception) {
            throw Utils.exception(exception, "Error storing metadata on file '%s'.", file);
        }
    }

    private void initMbtilesLayersMetadata(String mbtilesMetadataDirectoryPath) {
        if (mbtilesMetadataDirectoryPath == null) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Mbtiles metadata directory path is NULL, no mbtiles metadata will be parsed.");
            }
            return;
        }
        File mbtilesMetadataDirectory = new File(mbtilesMetadataDirectoryPath);
        if (!mbtilesMetadataDirectory.exists()) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info(String.format("Mbtiles metadata directory '%s' doesn't exists, no mbtiles metadata will be parsed.", mbtilesMetadataDirectoryPath));
            }
            return;
        }
        File[] files = mbtilesMetadataDirectory.listFiles();
        if (files == null) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info(String.format("No files present in mbtiles metadata directory '%s', no mbtiles metadata will be parsed.", mbtilesMetadataDirectoryPath));
            }
            return;
        }
        for (File file : files) {
            Matcher matcher = MBTILES_METADATA_FILE_NAME_PATTERN.matcher(file.getName());
            if (!matcher.matches()) continue;
            String layerName = matcher.group(1);
            Properties metadata = new Properties();
            try (FileInputStream input = new FileInputStream(file);){
                metadata.load(input);
            }
            catch (Exception exception) {
                throw Utils.exception(exception, "Error reading mbtiles metadata file '%s'.", file);
            }
            MBTilesMetadata gtMetadata = new MBTilesMetadata();
            gtMetadata.setAttribution(metadata.getProperty("attribution"));
            gtMetadata.setBoundsStr(metadata.getProperty("bounds"));
            gtMetadata.setDescription(metadata.getProperty("description"));
            gtMetadata.setMaxZoomStr(metadata.getProperty("maxZoom"));
            gtMetadata.setMinZoomStr(metadata.getProperty("minZoom"));
            gtMetadata.setTypeStr(metadata.getProperty("type"));
            gtMetadata.setVersion(metadata.getProperty("version"));
            this.layersMetadata.put(layerName, gtMetadata);
            if (!LOGGER.isLoggable(Level.INFO)) continue;
            LOGGER.info(String.format("Parsed mbtiles metadata for layer '%s'.", layerName));
        }
    }

    public Map<String, Optional<Map<String, String>>> getParametersMapping(String layerName) {
        try {
            return this.connectionManager.executeQuery(this.metadataFile, resultSet -> {
                try {
                    HashMap<String, Optional<Map>> result = new HashMap<String, Optional<Map>>();
                    while (resultSet.next()) {
                        Map params = ParametersUtils.getMap((String)resultSet.getString(1));
                        result.put(ParametersUtils.getId((Map)params), Optional.of(params));
                    }
                    return result;
                }
                catch (Exception exception) {
                    throw Utils.exception(exception, "Error reading result set.", new Object[0]);
                }
            }, "SELECT value FROM metadata WHERE layerName = ? AND key like 'parameters.%';", layerName);
        }
        catch (Exception exception) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, String.format("Error getting metadata from file '%s'.", this.metadataFile), exception);
            }
            return Collections.emptyMap();
        }
    }

    protected void persistParameterMap(TileObject stObj) {
        if (Objects.nonNull(stObj.getParametersId())) {
            this.putLayerMetadata(stObj.getLayerName(), "parameters." + stObj.getParametersId(), ParametersUtils.getKvp((Map)stObj.getParameters()));
        }
    }
}

