/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.sqlite;

import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.locks.LockProvider;
import org.geowebcache.sqlite.MbtilesBlobStore;
import org.geowebcache.sqlite.SqliteInfo;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.StorageException;

public class MbtilesInfo
extends SqliteInfo {
    private static final long serialVersionUID = -6618985107587790155L;
    private String mbtilesMetadataDirectory;
    private int executorConcurrency = 5;
    private Boolean gzipVector = false;

    public MbtilesInfo() {
    }

    public MbtilesInfo(String id) {
        super(id);
    }

    public String getMbtilesMetadataDirectory() {
        return this.mbtilesMetadataDirectory;
    }

    public void setMbtilesMetadataDirectory(String mbtilesMetadataDirectory) {
        this.mbtilesMetadataDirectory = mbtilesMetadataDirectory;
    }

    public int getExecutorConcurrency() {
        return this.executorConcurrency;
    }

    public void setExecutorConcurrency(int executorConcurrency) {
        this.executorConcurrency = executorConcurrency;
    }

    public boolean isGzipVector() {
        return this.gzipVector != null && this.gzipVector != false;
    }

    public void setGzipVector(boolean gzipVector) {
        this.gzipVector = gzipVector;
    }

    public BlobStore createInstance(TileLayerDispatcher layers, LockProvider lockProvider) throws StorageException {
        return new MbtilesBlobStore(this, super.getConnectionManager());
    }

    public String toString() {
        return "MBTiles BlobStore";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.executorConcurrency;
        result = 31 * result + (this.gzipVector == null ? 0 : this.gzipVector.hashCode());
        result = 31 * result + (this.mbtilesMetadataDirectory == null ? 0 : this.mbtilesMetadataDirectory.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        MbtilesInfo other = (MbtilesInfo)((Object)obj);
        if (this.executorConcurrency != other.executorConcurrency) {
            return false;
        }
        if (this.gzipVector == null ? other.gzipVector != null : !this.gzipVector.equals(other.gzipVector)) {
            return false;
        }
        return !(this.mbtilesMetadataDirectory == null ? other.mbtilesMetadataDirectory != null : !this.mbtilesMetadataDirectory.equals(other.mbtilesMetadataDirectory));
    }
}

