/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.sqlite;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.geotools.util.logging.Logging;
import org.geowebcache.config.BlobStoreConfiguration;
import org.geowebcache.config.BlobStoreInfo;
import org.geowebcache.config.ServerConfiguration;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.sqlite.SqliteBlobStore;
import org.geowebcache.sqlite.SqliteInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"**/sqlite"})
public class OperationsRest {
    private static Logger LOGGER = Logging.getLogger((String)OperationsRest.class.getName());
    @Autowired
    private TileLayerDispatcher tileLayerDispatcher;
    @Autowired
    private BlobStoreConfiguration blobConfiguration;
    @Autowired
    private ServerConfiguration gwcConfiguration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/replace"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<String> replace(@RequestParam(value="layer") String layer, @RequestParam(value="destination", required=false) String destination, @RequestParam(value="source", required=false) String source, @RequestParam(value="file", required=false) MultipartFile uploadedFile) {
        File workingDirectory;
        block14: {
            SqliteBlobStore blobStore;
            File file;
            block15: {
                block13: {
                    block12: {
                        workingDirectory = null;
                        file = null;
                        workingDirectory = Files.createTempDirectory("replace-operation-", new FileAttribute[0]).toFile();
                        blobStore = this.getBlobStoreForLayer(layer);
                        if (blobStore != null) break block12;
                        ResponseEntity responseEntity = ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)"No SQLite store could be associated with provided layer.");
                        FileUtils.deleteQuietly((File)workingDirectory);
                        return responseEntity;
                    }
                    if (uploadedFile != null && !uploadedFile.isEmpty()) {
                        file = this.handleFileUpload(uploadedFile, workingDirectory);
                    } else if (source != null) {
                        file = new File(source);
                    }
                    if (file != null && file.exists()) break block13;
                    ResponseEntity responseEntity = ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)"Provided file is NULL or doesn't exists.");
                    FileUtils.deleteQuietly((File)workingDirectory);
                    return responseEntity;
                }
                file = this.unzipFileIfNeeded(file, workingDirectory);
                if (file.isDirectory()) {
                    blobStore.replace(file);
                    break block14;
                }
                if (destination != null) break block15;
                ResponseEntity responseEntity = ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)"Destination is required for single files.");
                FileUtils.deleteQuietly((File)workingDirectory);
                return responseEntity;
            }
            try {
                blobStore.replace(file, destination);
            }
            catch (Exception exception) {
                ResponseEntity responseEntity;
                try {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, "Error executing the replace operation.", exception);
                    }
                    responseEntity = ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)exception.getMessage());
                }
                catch (Throwable throwable) {
                    FileUtils.deleteQuietly(workingDirectory);
                    throw throwable;
                }
                FileUtils.deleteQuietly((File)workingDirectory);
                return responseEntity;
            }
        }
        FileUtils.deleteQuietly((File)workingDirectory);
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(null);
    }

    private File handleFileUpload(MultipartFile uploadedFile, File workingDirectory) throws Exception {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Handling file upload.");
        }
        File outputFile = new File(workingDirectory, UUID.randomUUID().toString());
        byte[] bytes = uploadedFile.getBytes();
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(outputFile));){
            stream.write(bytes);
        }
        return outputFile;
    }

    private File unzipFileIfNeeded(File file, File workingDirectory) throws Exception {
        if (file.isDirectory()) {
            return file;
        }
        try (FileInputStream fileInput = new FileInputStream(file);){
            ZipEntry zipEntry;
            ZipInputStream zipInput;
            block13: {
                File file2;
                zipInput = new ZipInputStream(fileInput);
                try {
                    zipEntry = zipInput.getNextEntry();
                    if (zipEntry != null) break block13;
                    file2 = file;
                }
                catch (Throwable throwable) {
                    try {
                        zipInput.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                zipInput.close();
                return file2;
            }
            File file3 = this.unzip(zipInput, zipEntry, workingDirectory);
            zipInput.close();
            return file3;
        }
    }

    private File unzip(ZipInputStream zipInputStream, ZipEntry zipEntry, File workingDirectory) throws Exception {
        File outputDirectory = new File(workingDirectory, UUID.randomUUID().toString());
        outputDirectory.mkdir();
        while (zipEntry != null) {
            File outputFile = new File(outputDirectory, zipEntry.getName());
            if (zipEntry.isDirectory()) {
                outputFile.mkdir();
            } else {
                this.extractFile(zipInputStream, outputFile);
            }
            zipInputStream.closeEntry();
            zipEntry = zipInputStream.getNextEntry();
        }
        return outputDirectory;
    }

    private void extractFile(ZipInputStream inputStream, File outputFile) throws Exception {
        byte[] bytes = new byte[1024];
        try (FileOutputStream outputStream = new FileOutputStream(outputFile);){
            int read;
            while ((read = inputStream.read(bytes)) != -1) {
                outputStream.write(bytes, 0, read);
            }
        }
    }

    private SqliteBlobStore getBlobStoreForLayer(String layerName) throws Exception {
        String blobStoreId = this.tileLayerDispatcher.getTileLayer(layerName).getBlobStoreId();
        BlobStoreInfo blobStoreConfig = null;
        for (BlobStoreInfo candidateBlobStoreConfig : this.blobConfiguration.getBlobStores()) {
            if (blobStoreId == null && candidateBlobStoreConfig.isDefault()) {
                blobStoreConfig = candidateBlobStoreConfig;
                break;
            }
            if (!candidateBlobStoreConfig.getName().equals(blobStoreId)) continue;
            blobStoreConfig = candidateBlobStoreConfig;
            break;
        }
        if (blobStoreConfig == null || !(blobStoreConfig instanceof SqliteInfo)) {
            return null;
        }
        return (SqliteBlobStore)blobStoreConfig.createInstance(this.tileLayerDispatcher, this.gwcConfiguration.getLockProvider());
    }
}

