/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.sqlite;

import java.io.File;
import org.geowebcache.sqlite.FileManager;
import org.geowebcache.sqlite.SqliteConnectionManager;
import org.geowebcache.sqlite.SqliteInfo;
import org.geowebcache.storage.BlobStore;

abstract class SqliteBlobStore
implements BlobStore {
    private final SqliteInfo configuration;
    protected final FileManager fileManager;
    protected final SqliteConnectionManager connectionManager;

    protected SqliteBlobStore(SqliteInfo configuration, SqliteConnectionManager connectionManager) {
        this.configuration = configuration;
        this.fileManager = new FileManager(configuration.getRootDirectoryFile(), configuration.getTemplatePath(), configuration.getRowRangeCount(), configuration.getColumnRangeCount());
        this.connectionManager = connectionManager;
    }

    SqliteInfo getConfiguration() {
        return this.configuration;
    }

    void replace(File newFile, String destination) {
        File destinationFile = new File(this.configuration.getRootDirectoryFile(), destination);
        this.connectionManager.replace(destinationFile, newFile);
    }

    void replace(File directory) {
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            this.walkDirectoryTreeAndReplace(file, "");
        }
    }

    private void walkDirectoryTreeAndReplace(File current, String relativePath) {
        String newRelativePath = relativePath + File.separator + current.getName();
        if (!current.isDirectory()) {
            File destinationFile = new File(this.configuration.getRootDirectoryFile(), newRelativePath);
            this.connectionManager.replace(destinationFile, current);
            return;
        }
        File[] files = current.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            this.walkDirectoryTreeAndReplace(file, newRelativePath);
        }
    }

    public void destroy() {
    }
}

