/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.sqlite;

import java.io.File;
import java.util.UUID;
import org.geowebcache.config.BlobStoreInfo;
import org.geowebcache.sqlite.SqliteConnectionManager;
import org.geowebcache.sqlite.Utils;

public abstract class SqliteInfo
extends BlobStoreInfo {
    private static final long serialVersionUID = 2300159159094621077L;
    private transient SqliteConnectionManager connectionManager;
    private String rootDirectory;
    private String templatePath = Utils.buildPath("{layer}", "{grid}{format}{params}", "{z}_{x}_{y}.sqlite");
    private long poolSize = 1000L;
    private long poolReaperIntervalMs = 500L;
    private long rowRangeCount = 250L;
    private long columnRangeCount = 250L;
    private boolean eagerDelete = false;
    private boolean useCreateTime = true;

    public SqliteInfo() {
        this(UUID.randomUUID().toString());
    }

    public SqliteInfo(String id) {
        super(id);
    }

    public File getRootDirectoryFile() {
        File file = new File(this.rootDirectory);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public String getRootDirectory() {
        return this.rootDirectory;
    }

    public void setRootDirectory(String rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }

    public long getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(long poolSize) {
        this.poolSize = poolSize;
    }

    public long getPoolReaperIntervalMs() {
        return this.poolReaperIntervalMs;
    }

    public void setPoolReaperIntervalMs(long poolReaperIntervalMs) {
        this.poolReaperIntervalMs = poolReaperIntervalMs;
    }

    public long getRowRangeCount() {
        return this.rowRangeCount;
    }

    public void setRowRangeCount(long rowRangeCount) {
        this.rowRangeCount = rowRangeCount;
    }

    public long getColumnRangeCount() {
        return this.columnRangeCount;
    }

    public void setColumnRangeCount(long columnRangeCount) {
        this.columnRangeCount = columnRangeCount;
    }

    public boolean eagerDelete() {
        return this.eagerDelete;
    }

    public void setEagerDelete(boolean eagerDelete) {
        this.eagerDelete = eagerDelete;
    }

    public boolean useCreateTime() {
        return this.useCreateTime;
    }

    public void setUseCreateTime(boolean useCreateTime) {
        this.useCreateTime = useCreateTime;
    }

    public String getLocation() {
        return this.rootDirectory;
    }

    protected synchronized SqliteConnectionManager getConnectionManager() {
        if (this.connectionManager == null) {
            this.connectionManager = new SqliteConnectionManager(this);
        }
        return this.connectionManager;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.columnRangeCount ^ this.columnRangeCount >>> 32);
        result = 31 * result + (this.eagerDelete ? 1231 : 1237);
        result = 31 * result + (int)(this.poolReaperIntervalMs ^ this.poolReaperIntervalMs >>> 32);
        result = 31 * result + (int)(this.poolSize ^ this.poolSize >>> 32);
        result = 31 * result + (this.rootDirectory == null ? 0 : this.rootDirectory.hashCode());
        result = 31 * result + (int)(this.rowRangeCount ^ this.rowRangeCount >>> 32);
        result = 31 * result + (this.templatePath == null ? 0 : this.templatePath.hashCode());
        result = 31 * result + (this.useCreateTime ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SqliteInfo other = (SqliteInfo)((Object)obj);
        if (this.columnRangeCount != other.columnRangeCount) {
            return false;
        }
        if (this.eagerDelete != other.eagerDelete) {
            return false;
        }
        if (this.poolReaperIntervalMs != other.poolReaperIntervalMs) {
            return false;
        }
        if (this.poolSize != other.poolSize) {
            return false;
        }
        if (this.rootDirectory == null ? other.rootDirectory != null : !this.rootDirectory.equals(other.rootDirectory)) {
            return false;
        }
        if (this.rowRangeCount != other.rowRangeCount) {
            return false;
        }
        if (this.templatePath == null ? other.templatePath != null : !this.templatePath.equals(other.templatePath)) {
            return false;
        }
        return this.useCreateTime == other.useCreateTime;
    }
}

