/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.sqlite;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.geotools.util.logging.Logging;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;

final class Utils {
    private static Logger LOGGER = Logging.getLogger((String)Utils.class.getName());
    static final String REGEX_FILE_SEPARATOR = File.separator.equals("\\") ? "\\\\" : File.separator;

    private Utils() {
    }

    @SafeVarargs
    static <K, V> Map<K, V> tuplesToMap(Tuple<K, V> ... tuples) {
        HashMap map = new HashMap();
        for (Tuple<K, V> tuple : tuples) {
            map.put(tuple.first, tuple.second);
        }
        return map;
    }

    static void check(boolean condition, String message, Object ... arguments) {
        if (!condition) {
            throw Utils.exception(message, arguments);
        }
    }

    static RuntimeException exception(String message, Object ... arguments) {
        String finalMessage = String.format(message, arguments);
        LOGGER.severe(finalMessage);
        return new RuntimeException(finalMessage);
    }

    static RuntimeException exception(Exception exception, String message, Object ... arguments) {
        String finalMessage = String.format(message, arguments);
        LOGGER.severe(finalMessage);
        return new RuntimeException(finalMessage, exception);
    }

    static byte[] resourceToByteArray(Resource resource) {
        try {
            return IOUtils.toByteArray((InputStream)resource.getInputStream());
        }
        catch (Exception exception) {
            throw Utils.exception(exception, "Error converting resource to byte array.", new Object[0]);
        }
    }

    static Resource byteArrayToResource(byte[] data) {
        return new ByteArrayResource(data);
    }

    static String buildPath(String ... pathParts) {
        return StringUtils.join((Object[])pathParts, (String)File.separator);
    }

    static void createFileParents(File file) {
        File parentFile = file.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
    }

    static final class Tuple<T, U> {
        final T first;
        final U second;

        private Tuple(T first, U second) {
            this.first = first;
            this.second = second;
        }

        static <R, S> Tuple<R, S> tuple(R first, S second) {
            return new Tuple<R, S>(first, second);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Tuple tuple = (Tuple)object;
            return Objects.equals(this.first, tuple.first) && Objects.equals(this.second, tuple.second);
        }

        public int hashCode() {
            return Objects.hash(this.first, this.second);
        }

        public String toString() {
            return "Tuple{first=" + String.valueOf(this.first) + ", second=" + String.valueOf(this.second) + "}";
        }
    }
}

