/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.swift;

import com.google.common.io.ByteSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.MimeType;
import org.geowebcache.storage.BlobStoreListener;
import org.geowebcache.storage.BlobStoreListenerList;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.TileRange;
import org.geowebcache.swift.IBlobStoreListenerNotifier;
import org.geowebcache.swift.SwiftBlobStore;
import org.geowebcache.swift.SwiftBlobStoreInfo;
import org.geowebcache.swift.SwiftDeleteTask;
import org.geowebcache.swift.SwiftUploadTask;
import org.geowebcache.util.TMSKeyBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.io.payloads.ByteSourcePayload;
import org.jclouds.openstack.swift.v1.SwiftApi;
import org.jclouds.openstack.swift.v1.blobstore.RegionScopedBlobStoreContext;
import org.jclouds.openstack.swift.v1.blobstore.RegionScopedSwiftBlobStore;
import org.jclouds.openstack.swift.v1.domain.Container;
import org.jclouds.openstack.swift.v1.domain.ObjectList;
import org.jclouds.openstack.swift.v1.domain.SwiftObject;
import org.jclouds.openstack.swift.v1.features.BulkApi;
import org.jclouds.openstack.swift.v1.features.ObjectApi;
import org.jclouds.openstack.swift.v1.options.ListContainerOptions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.springframework.test.util.ReflectionTestUtils;

public class SwiftBlobStoreTest {
    private String TEST_KEY = "test/key";
    private SwiftBlobStore swiftBlobStore;
    @Mock
    private ObjectApi objectApi;
    private TileObject sampleTileObject;
    private TMSKeyBuilder keyBuilder;
    @Mock
    private SwiftApi swiftApi;
    @Mock
    private BulkApi bulkApi;
    private BlobStoreListenerList testListeners;
    @Mock
    private RegionScopedBlobStoreContext blobStoreContext;
    @Mock
    private RegionScopedSwiftBlobStore blobStore;
    @Mock
    private PageSet pageSet;
    private static final String VALID_TEST_LAYER_NAME = "TestLayer";
    private static final String INVALID_TEST_LAYER_NAME = "NonExistentLayer";

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.openMocks((Object)this);
        ByteArrayResource bytes = new ByteArrayResource("1 2 3 4 5 6 test".getBytes());
        long[] xyz = new long[]{1L, 2L, 3L};
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("test param key", "test param value");
        this.sampleTileObject = TileObject.createCompleteTileObject((String)VALID_TEST_LAYER_NAME, (long[])xyz, (String)"EPSG:4326", (String)"image/jpeg", parameters, (Resource)bytes);
        Mockito.when((Object)this.swiftApi.getObjectApi((String)Mockito.any(), (String)Mockito.any())).thenReturn((Object)this.objectApi);
        Mockito.when((Object)this.swiftApi.getBulkApi((String)Mockito.any())).thenReturn((Object)this.bulkApi);
        Mockito.when((Object)this.blobStoreContext.getBlobStore((String)Mockito.any())).thenReturn((Object)this.blobStore);
        Mockito.when((Object)this.blobStore.list(Mockito.anyString(), (org.jclouds.blobstore.options.ListContainerOptions)Mockito.any())).thenReturn((Object)this.pageSet);
        SwiftBlobStoreInfo config = (SwiftBlobStoreInfo)Mockito.mock(SwiftBlobStoreInfo.class);
        Mockito.when((Object)config.buildApi()).thenReturn((Object)this.swiftApi);
        Mockito.when((Object)config.getBlobStore()).thenReturn((Object)this.blobStoreContext);
        Mockito.when((Object)config.getContainer()).thenReturn((Object)"TestContainer");
        Mockito.when((Object)config.isValid()).thenReturn((Object)true);
        this.swiftBlobStore = (SwiftBlobStore)Mockito.spy((Object)new SwiftBlobStore(config, (TileLayerDispatcher)Mockito.mock(TileLayerDispatcher.class)));
        this.keyBuilder = (TMSKeyBuilder)Mockito.spy((Object)new TMSKeyBuilder("test_prefix", (TileLayerDispatcher)Mockito.mock(TileLayerDispatcher.class)));
        this.testListeners = (BlobStoreListenerList)Mockito.spy((Object)new BlobStoreListenerList());
        ((TMSKeyBuilder)Mockito.doReturn((Object)"sample/key").when((Object)this.keyBuilder)).forTile(this.sampleTileObject);
        ReflectionTestUtils.setField((Object)this.swiftBlobStore, (String)"keyBuilder", (Object)this.keyBuilder);
        ReflectionTestUtils.setField((Object)this.swiftBlobStore, (String)"listeners", (Object)this.testListeners);
    }

    @After
    public void tearDown() {
        this.swiftBlobStore.destroy();
    }

    @Test
    public void destroy() {
        this.swiftBlobStore.destroy();
        try {
            ((SwiftApi)Mockito.verify((Object)this.swiftApi, (VerificationMode)Mockito.times((int)1))).close();
            ((RegionScopedBlobStoreContext)Mockito.verify((Object)this.blobStoreContext, (VerificationMode)Mockito.times((int)1))).close();
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void addListener() {
        Assert.assertTrue((boolean)this.testListeners.isEmpty());
        BlobStoreListener swiftListener = (BlobStoreListener)Mockito.mock(BlobStoreListener.class);
        this.swiftBlobStore.addListener(swiftListener);
        ArrayList blobStoreListenersResult = (ArrayList)this.testListeners.getListeners();
        Assert.assertTrue((boolean)blobStoreListenersResult.contains(swiftListener));
    }

    @Test
    public void removeListener() {
        BlobStoreListener swiftListener = (BlobStoreListener)Mockito.mock(BlobStoreListener.class);
        this.testListeners.addListener(swiftListener);
        ArrayList testListenersList = (ArrayList)this.testListeners.getListeners();
        Assert.assertTrue((boolean)testListenersList.contains(swiftListener));
        this.swiftBlobStore.removeListener(swiftListener);
        Assert.assertTrue((boolean)this.testListeners.isEmpty());
    }

    private Resource createTestResource(Long contentLen) {
        Resource testResource = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)testResource.getSize()).thenReturn((Object)contentLen);
        return testResource;
    }

    private TileObject createMockTileObject(Resource testResource) {
        TileObject testTileObject = (TileObject)Mockito.mock(TileObject.class);
        Mockito.when((Object)testTileObject.getBlob()).thenReturn((Object)testResource);
        ((TMSKeyBuilder)Mockito.doReturn((Object)this.TEST_KEY).when((Object)this.keyBuilder)).forTile(testTileObject);
        return testTileObject;
    }

    @Test
    public void testPutWhenFormatNull() {
        Resource testResource = this.createTestResource(3L);
        TileObject testTileObject = this.createMockTileObject(testResource);
        Mockito.when((Object)testTileObject.getBlobFormat()).thenReturn(null);
        try {
            this.swiftBlobStore.put(testTileObject);
            Assert.fail((String)"Null check when tile format is null failed");
        }
        catch (NullPointerException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"Object Blob Format must not be null."));
        }
        catch (StorageException e) {
            Assert.fail((String)("Should be throwing a NullPointerException.\n" + e));
        }
        ((TMSKeyBuilder)Mockito.verify((Object)this.keyBuilder, (VerificationMode)Mockito.times((int)0))).forTile(testTileObject);
    }

    @Test
    public void testPutWhenBlobIsNull() {
        TileObject testTileObject = this.createMockTileObject((Resource)Mockito.mock(Resource.class));
        Mockito.when((Object)testTileObject.getBlob()).thenReturn(null);
        try {
            this.swiftBlobStore.put(testTileObject);
            Assert.fail((String)"Null check when blob is null failed");
        }
        catch (NullPointerException e) {
            ((TileObject)Mockito.verify((Object)testTileObject, (VerificationMode)Mockito.times((int)1))).getBlob();
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"Object Blob must not be null."));
        }
        catch (StorageException e) {
            Assert.fail((String)("Should be throwing a NullPointerException.\n" + e));
        }
        ((TMSKeyBuilder)Mockito.verify((Object)this.keyBuilder, (VerificationMode)Mockito.times((int)0))).forTile(testTileObject);
    }

    @Test(expected=RuntimeException.class)
    public void testPutWhenBlobIsAnInvalidMimeType() {
        Resource testResource = this.createTestResource(3L);
        TileObject testTileObject = this.createMockTileObject(testResource);
        Mockito.when((Object)testTileObject.getBlobFormat()).thenReturn((Object)"invalid mime type");
        try {
            this.swiftBlobStore.put(testTileObject);
            Assert.fail((String)"Null check for grid check id failed");
        }
        catch (StorageException e) {
            Assert.fail((String)("Should be throwing a RuntimeException caused by a MimeException.\n" + e));
        }
    }

    @Test
    public void get() {
        final String thePayloadData = "Test Content";
        Date lastModified = new Date();
        ByteSourcePayload testByteSourcePayload = new ByteSourcePayload(new ByteSource(){

            public InputStream openStream() {
                return new ByteArrayInputStream(thePayloadData.getBytes());
            }
        });
        SwiftObject swiftObject = (SwiftObject)Mockito.mock(SwiftObject.class);
        Mockito.when((Object)swiftObject.getLastModified()).thenReturn((Object)lastModified);
        Mockito.when((Object)swiftObject.getPayload()).thenReturn((Object)testByteSourcePayload);
        try {
            Mockito.when((Object)this.objectApi.get("sample/key")).thenReturn((Object)swiftObject);
            boolean result = this.swiftBlobStore.get(this.sampleTileObject);
            ((TMSKeyBuilder)Mockito.verify((Object)this.keyBuilder, (VerificationMode)Mockito.times((int)1))).forTile(this.sampleTileObject);
            ((ObjectApi)Mockito.verify((Object)this.objectApi, (VerificationMode)Mockito.times((int)1))).get("sample/key");
            ((SwiftObject)Mockito.verify((Object)swiftObject, (VerificationMode)Mockito.times((int)1))).getPayload();
            ByteArrayResource expectedByteArray = new ByteArrayResource(thePayloadData.getBytes());
            ByteArrayResource actualByteArray = (ByteArrayResource)this.sampleTileObject.getBlob();
            Assert.assertEquals((long)thePayloadData.length(), (long)this.sampleTileObject.getBlobSize());
            Assert.assertArrayEquals((byte[])expectedByteArray.getContents(), (byte[])actualByteArray.getContents());
            Assert.assertEquals((long)lastModified.getTime(), (long)this.sampleTileObject.getCreated());
            Assert.assertTrue((boolean)result);
            Mockito.when((Object)this.objectApi.get("sample/key")).thenReturn(null);
            result = this.swiftBlobStore.get(this.sampleTileObject);
            Assert.assertFalse((boolean)result);
        }
        catch (StorageException e) {
            Assert.fail((String)"A storage exception was not expected to be thrown");
        }
    }

    @Test
    @Ignore
    public void deleteByLayerName() throws InterruptedException {
        String layerPrefix = "layerPrefix";
        ((TMSKeyBuilder)Mockito.doReturn((Object)layerPrefix).when((Object)this.keyBuilder)).forLayer(VALID_TEST_LAYER_NAME);
        ((PageSet)Mockito.doReturn((Object)true).when((Object)this.pageSet)).isEmpty();
        ((SwiftBlobStore)Mockito.verify((Object)this.swiftBlobStore, (VerificationMode)Mockito.times((int)0))).deleteByPath((String)Mockito.eq((Object)layerPrefix), (IBlobStoreListenerNotifier)Mockito.any());
        ((BlobStoreListenerList)Mockito.verify((Object)this.testListeners, (VerificationMode)Mockito.times((int)0))).sendLayerDeleted(VALID_TEST_LAYER_NAME);
        Assert.assertTrue((boolean)this.swiftBlobStore.delete(VALID_TEST_LAYER_NAME));
        Thread.sleep(1500L);
        ((SwiftBlobStore)Mockito.verify((Object)this.swiftBlobStore, (VerificationMode)Mockito.times((int)1))).deleteByPath((String)Mockito.eq((Object)layerPrefix), (IBlobStoreListenerNotifier)Mockito.any());
        ((BlobStoreListenerList)Mockito.verify((Object)this.testListeners, (VerificationMode)Mockito.times((int)1))).sendLayerDeleted(VALID_TEST_LAYER_NAME);
        try {
            this.swiftBlobStore.delete((String)null);
            Assert.fail((String)"Null check for layer name failed");
        }
        catch (NullPointerException e) {
            Thread.sleep(1500L);
            ((SwiftBlobStore)Mockito.verify((Object)this.swiftBlobStore, (VerificationMode)Mockito.times((int)0))).deleteByPath((String)Mockito.eq(null), (IBlobStoreListenerNotifier)Mockito.any());
            ((BlobStoreListenerList)Mockito.verify((Object)this.testListeners, (VerificationMode)Mockito.times((int)0))).sendLayerDeleted(null);
        }
    }

    @Test
    @Ignore
    public void deleteByTileRange() throws InterruptedException {
        TileRange testTileRange = (TileRange)Mockito.mock(TileRange.class);
        MimeType mimeType = (MimeType)Mockito.mock(MimeType.class);
        Mockito.when((Object)mimeType.getInternalName()).thenReturn((Object)"png");
        Mockito.when((Object)mimeType.getFormat()).thenReturn((Object)"image/png");
        Mockito.when((Object)testTileRange.getMimeType()).thenReturn((Object)((MimeType)Mockito.mock(MimeType.class)));
        long[][] rangebounds = new long[][]{{1L, 2L, 1L, 2L, 1L}, {1L, 2L, 1L, 2L, 2L}, {1L, 2L, 1L, 2L, 3L}};
        TileRange realTestTileRange = new TileRange(VALID_TEST_LAYER_NAME, "test_gridset_id", 1, 2, (long[][])rangebounds, mimeType, new HashMap(), "test_param_id");
        String testCoordinatesPrefix = "test/coord/prefix";
        SwiftObject testSwiftObject = (SwiftObject)Mockito.mock(SwiftObject.class);
        ((TMSKeyBuilder)Mockito.doReturn((Object)testCoordinatesPrefix).when((Object)this.keyBuilder)).coordinatesPrefix(testTileRange, true);
        ((TMSKeyBuilder)Mockito.doReturn((Object)"layer_id").when((Object)this.keyBuilder)).layerId(VALID_TEST_LAYER_NAME);
        Mockito.when((Object)this.objectApi.get(testCoordinatesPrefix)).thenReturn(null);
        Assert.assertFalse((boolean)this.swiftBlobStore.delete(testTileRange));
        ((TMSKeyBuilder)Mockito.verify((Object)this.keyBuilder, (VerificationMode)Mockito.times((int)1))).coordinatesPrefix(testTileRange, true);
        ((ObjectApi)Mockito.verify((Object)this.objectApi, (VerificationMode)Mockito.times((int)1))).get(testCoordinatesPrefix);
        Mockito.when((Object)this.objectApi.get((String)Mockito.any())).thenReturn((Object)testSwiftObject);
        Assert.assertTrue((boolean)this.swiftBlobStore.delete(realTestTileRange));
        Thread.sleep(500L);
        ((TMSKeyBuilder)Mockito.verify((Object)this.keyBuilder, (VerificationMode)Mockito.times((int)1))).coordinatesPrefix(realTestTileRange, true);
        ((ObjectApi)Mockito.verify((Object)this.objectApi, (VerificationMode)Mockito.times((int)1))).get("test_prefix/layer_id/test_gridset_id/test_param_id/");
        List<String> expectedKeys = Arrays.asList("test_prefix/layer_id/test_gridset_id/test_param_id/1/1/2.png", "test_prefix/layer_id/test_gridset_id/test_param_id/2/1/2.png");
        ((BulkApi)Mockito.verify((Object)this.bulkApi, (VerificationMode)Mockito.times((int)1))).bulkDelete(expectedKeys);
        BlobStoreListener testListener = (BlobStoreListener)Mockito.mock(BlobStoreListener.class);
        this.testListeners.addListener(testListener);
        Assert.assertTrue((boolean)this.swiftBlobStore.delete(realTestTileRange));
        Thread.sleep(500L);
        ((SwiftBlobStore)Mockito.verify((Object)this.swiftBlobStore, (VerificationMode)Mockito.times((int)2))).delete((TileObject)Mockito.any(TileObject.class));
    }

    @Test
    @Ignore
    public void deleteByGridsetId() throws InterruptedException {
        String testGridSetID = "TestGridSetID";
        String testGridsetPrefix = "test/gridset/prefix";
        ((TMSKeyBuilder)Mockito.doReturn((Object)testGridsetPrefix).when((Object)this.keyBuilder)).forGridset(VALID_TEST_LAYER_NAME, testGridSetID);
        ((PageSet)Mockito.doReturn((Object)false).when((Object)this.pageSet)).isEmpty();
        Assert.assertTrue((boolean)this.swiftBlobStore.deleteByGridsetId(VALID_TEST_LAYER_NAME, testGridSetID));
        ((TMSKeyBuilder)Mockito.verify((Object)this.keyBuilder, (VerificationMode)Mockito.times((int)1))).forGridset(VALID_TEST_LAYER_NAME, testGridSetID);
        ((SwiftBlobStore)Mockito.verify((Object)this.swiftBlobStore, (VerificationMode)Mockito.times((int)1))).deleteByPath((String)Mockito.eq((Object)testGridsetPrefix), (IBlobStoreListenerNotifier)Mockito.any());
        Thread.sleep(500L);
        ((BlobStoreListenerList)Mockito.verify((Object)this.testListeners, (VerificationMode)Mockito.times((int)0))).sendGridSubsetDeleted(VALID_TEST_LAYER_NAME, testGridSetID);
        ((PageSet)Mockito.doReturn((Object)true).when((Object)this.pageSet)).isEmpty();
        Assert.assertTrue((boolean)this.swiftBlobStore.deleteByGridsetId(VALID_TEST_LAYER_NAME, testGridSetID));
        ((TMSKeyBuilder)Mockito.verify((Object)this.keyBuilder, (VerificationMode)Mockito.times((int)2))).forGridset(VALID_TEST_LAYER_NAME, testGridSetID);
        ((SwiftBlobStore)Mockito.verify((Object)this.swiftBlobStore, (VerificationMode)Mockito.times((int)2))).deleteByPath((String)Mockito.eq((Object)testGridsetPrefix), (IBlobStoreListenerNotifier)Mockito.any());
        Thread.sleep(500L);
        ((BlobStoreListenerList)Mockito.verify((Object)this.testListeners, (VerificationMode)Mockito.times((int)1))).sendGridSubsetDeleted(VALID_TEST_LAYER_NAME, testGridSetID);
        try {
            this.swiftBlobStore.deleteByGridsetId(null, testGridSetID);
            Assert.fail((String)"Null check for layer name failed");
        }
        catch (NullPointerException e) {
            ((TMSKeyBuilder)Mockito.verify((Object)this.keyBuilder, (VerificationMode)Mockito.times((int)0))).forGridset(null, testGridSetID);
            ((BlobStoreListenerList)Mockito.verify((Object)this.testListeners, (VerificationMode)Mockito.times((int)0))).sendGridSubsetDeleted(null, testGridSetID);
        }
        try {
            this.swiftBlobStore.deleteByGridsetId(VALID_TEST_LAYER_NAME, null);
            Assert.fail((String)"Null check for grid check id failed");
        }
        catch (NullPointerException e) {
            ((TMSKeyBuilder)Mockito.verify((Object)this.keyBuilder, (VerificationMode)Mockito.times((int)0))).forGridset(VALID_TEST_LAYER_NAME, null);
            ((BlobStoreListenerList)Mockito.verify((Object)this.testListeners, (VerificationMode)Mockito.times((int)0))).sendGridSubsetDeleted(VALID_TEST_LAYER_NAME, null);
        }
    }

    @Test
    @Ignore
    public void deleteByTileObject() throws InterruptedException {
        TileObject tileObjectWithNullName = (TileObject)Mockito.mock(TileObject.class);
        Mockito.when((Object)tileObjectWithNullName.getLayerName()).thenReturn(null);
        try {
            this.swiftBlobStore.delete(tileObjectWithNullName);
            Assert.fail((String)"Null check for grid check id failed");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        String tilePrefix = "tilePrefix";
        ((TMSKeyBuilder)Mockito.doReturn((Object)tilePrefix).when((Object)this.keyBuilder)).forTile(this.sampleTileObject);
        Assert.assertTrue((boolean)this.swiftBlobStore.delete(this.sampleTileObject));
        Thread.sleep(500L);
        ((SwiftBlobStore)Mockito.verify((Object)this.swiftBlobStore, (VerificationMode)Mockito.times((int)1))).deleteByPath((String)Mockito.eq((Object)tilePrefix), (IBlobStoreListenerNotifier)Mockito.any());
        BlobStoreListener testListener = (BlobStoreListener)Mockito.mock(BlobStoreListener.class);
        this.testListeners.addListener(testListener);
        ((PageSet)Mockito.doReturn((Object)true).when((Object)this.pageSet)).isEmpty();
        Assert.assertTrue((boolean)this.swiftBlobStore.delete(this.sampleTileObject));
        Thread.sleep(500L);
        ((SwiftBlobStore)Mockito.verify((Object)this.swiftBlobStore, (VerificationMode)Mockito.times((int)2))).deleteByPath((String)Mockito.eq((Object)tilePrefix), (IBlobStoreListenerNotifier)Mockito.any());
        ((BlobStoreListenerList)Mockito.verify((Object)this.testListeners, (VerificationMode)Mockito.times((int)1))).sendTileDeleted(this.sampleTileObject);
        Mockito.when((Object)this.objectApi.get(VALID_TEST_LAYER_NAME)).thenReturn((Object)((SwiftObject)Mockito.mock(SwiftObject.class)));
        ((PageSet)Mockito.doReturn((Object)false).when((Object)this.pageSet)).isEmpty();
        Assert.assertTrue((boolean)this.swiftBlobStore.delete(this.sampleTileObject));
        Thread.sleep(500L);
        ((SwiftBlobStore)Mockito.verify((Object)this.swiftBlobStore, (VerificationMode)Mockito.times((int)3))).deleteByPath((String)Mockito.eq((Object)tilePrefix), (IBlobStoreListenerNotifier)Mockito.any());
        ((BlobStoreListenerList)Mockito.verify((Object)this.testListeners, (VerificationMode)Mockito.times((int)1))).sendTileDeleted(this.sampleTileObject);
    }

    @Test
    public void rename() {
        boolean result = this.swiftBlobStore.rename(VALID_TEST_LAYER_NAME, "NewLayerName");
        ((ObjectApi)Mockito.verify((Object)this.objectApi, (VerificationMode)Mockito.times((int)1))).get(VALID_TEST_LAYER_NAME);
        ((BlobStoreListenerList)Mockito.verify((Object)this.testListeners, (VerificationMode)Mockito.times((int)0))).sendLayerRenamed(VALID_TEST_LAYER_NAME, "NewLayerName");
        Assert.assertTrue((boolean)result);
        Mockito.when((Object)this.objectApi.get(VALID_TEST_LAYER_NAME)).thenReturn((Object)((SwiftObject)Mockito.mock(SwiftObject.class)));
        result = this.swiftBlobStore.rename(VALID_TEST_LAYER_NAME, "NewLayerName");
        ((ObjectApi)Mockito.verify((Object)this.objectApi, (VerificationMode)Mockito.times((int)2))).get(VALID_TEST_LAYER_NAME);
        ((BlobStoreListenerList)Mockito.verify((Object)this.testListeners, (VerificationMode)Mockito.times((int)1))).sendLayerRenamed(VALID_TEST_LAYER_NAME, "NewLayerName");
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void clear() {
        try {
            this.swiftBlobStore.clear();
            Assert.fail((String)"This method should not work, it should throw a Unsupported Operation Exception");
        }
        catch (UnsupportedOperationException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"clear() should not be called"));
        }
    }

    @Test
    public void getLayerMetadata() {
        SwiftObject swiftObject = (SwiftObject)Mockito.mock(SwiftObject.class);
        SwiftObject swiftObjectWithoutMetadata = (SwiftObject)Mockito.mock(SwiftObject.class);
        Mockito.when((Object)this.objectApi.get("")).thenReturn(null);
        Mockito.when((Object)this.objectApi.get(INVALID_TEST_LAYER_NAME)).thenReturn(null);
        Mockito.when((Object)this.objectApi.get(VALID_TEST_LAYER_NAME)).thenReturn((Object)swiftObject);
        Mockito.when((Object)this.objectApi.get("valid layer without metadata")).thenReturn((Object)swiftObjectWithoutMetadata);
        HashMap<String, String> sampleMetadata = new HashMap<String, String>();
        sampleMetadata.put("sample_key", "sample_value");
        Mockito.when((Object)swiftObject.getMetadata()).thenReturn(sampleMetadata);
        Mockito.when((Object)swiftObjectWithoutMetadata.getMetadata()).thenReturn(new HashMap());
        String result = this.swiftBlobStore.getLayerMetadata("", "sample_key");
        Assert.assertNull((Object)result);
        result = this.swiftBlobStore.getLayerMetadata(INVALID_TEST_LAYER_NAME, "sample_key");
        Assert.assertNull((Object)result);
        result = this.swiftBlobStore.getLayerMetadata("valid layer name without metadata", "sample_key");
        Assert.assertNull((Object)result);
        result = this.swiftBlobStore.getLayerMetadata(VALID_TEST_LAYER_NAME, "sample_key");
        ((ObjectApi)Mockito.verify((Object)this.objectApi, (VerificationMode)Mockito.times((int)1))).get(VALID_TEST_LAYER_NAME);
        Assert.assertEquals((Object)"sample_value", (Object)result);
        result = this.swiftBlobStore.getLayerMetadata(VALID_TEST_LAYER_NAME, "");
        ((ObjectApi)Mockito.verify((Object)this.objectApi, (VerificationMode)Mockito.times((int)1))).get("");
        Assert.assertNull((Object)result);
    }

    @Test
    public void putLayerMetadata() {
        Assert.assertNull((Object)this.objectApi.get(VALID_TEST_LAYER_NAME));
        this.swiftBlobStore.putLayerMetadata(VALID_TEST_LAYER_NAME, "test_key", "test_value");
        Assert.assertNull((Object)this.objectApi.get(VALID_TEST_LAYER_NAME));
        SwiftObject layer = (SwiftObject)Mockito.mock(SwiftObject.class);
        Mockito.when((Object)this.objectApi.get(VALID_TEST_LAYER_NAME)).thenReturn((Object)layer);
        this.swiftBlobStore.putLayerMetadata(VALID_TEST_LAYER_NAME, "test_key", "test_value");
        ((SwiftObject)Mockito.verify((Object)layer, (VerificationMode)Mockito.times((int)1))).getMetadata();
        HashMap<String, String> newMetadata = new HashMap<String, String>();
        newMetadata.put("test_key", "test_value");
        ((ObjectApi)Mockito.verify((Object)this.objectApi, (VerificationMode)Mockito.times((int)1))).updateMetadata(VALID_TEST_LAYER_NAME, newMetadata);
        HashMap<String, String> existingMetadata = new HashMap<String, String>();
        existingMetadata.put("sample_key", "sample_value");
        Mockito.when((Object)layer.getMetadata()).thenReturn(existingMetadata);
        this.swiftBlobStore.putLayerMetadata(VALID_TEST_LAYER_NAME, "test_key", "test_value");
        ((SwiftObject)Mockito.verify((Object)layer, (VerificationMode)Mockito.times((int)2))).getMetadata();
        HashMap<String, String> updatedMetadata = new HashMap<String, String>();
        updatedMetadata.put("test_key", "test_value");
        updatedMetadata.put("sample_key", "sample_value");
        ((ObjectApi)Mockito.verify((Object)this.objectApi, (VerificationMode)Mockito.times((int)1))).updateMetadata(VALID_TEST_LAYER_NAME, updatedMetadata);
    }

    @Test
    public void layerExists() {
        SwiftObject swiftObject = (SwiftObject)Mockito.mock(SwiftObject.class);
        Mockito.when((Object)this.objectApi.get(VALID_TEST_LAYER_NAME)).thenReturn((Object)swiftObject);
        Assert.assertTrue((boolean)this.swiftBlobStore.layerExists(VALID_TEST_LAYER_NAME));
        Mockito.when((Object)this.objectApi.get("layer which doesn't exist")).thenReturn(null);
        Assert.assertFalse((boolean)this.swiftBlobStore.layerExists("layer which doesn't exist"));
    }

    @Test
    public void getParametersMapping() {
        String prefixPath = "sample/prefix/path";
        String testObjectName = "test object";
        SwiftObject swiftObject = (SwiftObject)Mockito.mock(SwiftObject.class);
        Mockito.when((Object)swiftObject.getName()).thenReturn((Object)testObjectName);
        ArrayList<SwiftObject> swiftObjects = new ArrayList<SwiftObject>();
        swiftObjects.add(swiftObject);
        ObjectList swiftObjectList = ObjectList.create(swiftObjects, (Container)((Container)Mockito.mock(Container.class)));
        ListContainerOptions options = new ListContainerOptions();
        options.prefix(prefixPath);
        Mockito.when((Object)this.objectApi.list(options)).thenReturn((Object)swiftObjectList);
        ((TMSKeyBuilder)Mockito.doReturn((Object)prefixPath).when((Object)this.keyBuilder)).parametersMetadataPrefix(VALID_TEST_LAYER_NAME);
        Map testResult = this.swiftBlobStore.getParametersMapping(VALID_TEST_LAYER_NAME);
        ((TMSKeyBuilder)Mockito.verify((Object)this.keyBuilder, (VerificationMode)Mockito.times((int)1))).parametersMetadataPrefix(VALID_TEST_LAYER_NAME);
        ((ObjectApi)Mockito.verify((Object)this.objectApi, (VerificationMode)Mockito.times((int)1))).list(options);
        HashMap expectedResult = new HashMap();
        expectedResult.put(testObjectName, Optional.ofNullable(new HashMap()));
        Assert.assertEquals(expectedResult, (Object)testResult);
        HashMap<String, String> objectMetadata = new HashMap<String, String>();
        objectMetadata.put("test_key", "test_value");
        Mockito.when((Object)swiftObject.getMetadata()).thenReturn(objectMetadata);
        testResult = this.swiftBlobStore.getParametersMapping(VALID_TEST_LAYER_NAME);
        ((TMSKeyBuilder)Mockito.verify((Object)this.keyBuilder, (VerificationMode)Mockito.times((int)2))).parametersMetadataPrefix(VALID_TEST_LAYER_NAME);
        ((ObjectApi)Mockito.verify((Object)this.objectApi, (VerificationMode)Mockito.times((int)2))).list(options);
        HashMap expectedResultWithMetadata = new HashMap();
        expectedResultWithMetadata.put(testObjectName, Optional.of(objectMetadata));
        Assert.assertEquals(expectedResultWithMetadata, (Object)testResult);
    }

    @Test
    public void deleteByParametersId() {
        String testParametersId = "testParamId";
        try {
            this.swiftBlobStore.deleteByParametersId(null, testParametersId);
            Assert.fail((String)"Null check for layer name failed");
        }
        catch (NullPointerException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"layerName"));
        }
        try {
            this.swiftBlobStore.deleteByParametersId(VALID_TEST_LAYER_NAME, null);
            Assert.fail((String)"Null check for parameters id failed");
        }
        catch (NullPointerException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"parametersId"));
        }
        HashSet<String> dummyParamsPrefixes = new HashSet<String>(Arrays.asList("prefix/one", "prefix/two"));
        ((TMSKeyBuilder)Mockito.doReturn(dummyParamsPrefixes).when((Object)this.keyBuilder)).forParameters(VALID_TEST_LAYER_NAME, testParametersId);
        ((SwiftBlobStore)Mockito.doReturn((Object)true).when((Object)this.swiftBlobStore)).deleteByPath("prefix/one");
        ((SwiftBlobStore)Mockito.doReturn((Object)true).when((Object)this.swiftBlobStore)).deleteByPath("prefix/two");
        boolean outcome = this.swiftBlobStore.deleteByParametersId(VALID_TEST_LAYER_NAME, testParametersId);
        ((SwiftBlobStore)Mockito.verify((Object)this.swiftBlobStore, (VerificationMode)Mockito.times((int)1))).deleteByPath("prefix/one");
        ((SwiftBlobStore)Mockito.verify((Object)this.swiftBlobStore, (VerificationMode)Mockito.times((int)1))).deleteByPath("prefix/two");
        ((BlobStoreListenerList)Mockito.verify((Object)this.testListeners, (VerificationMode)Mockito.times((int)1))).sendParametersDeleted(VALID_TEST_LAYER_NAME, testParametersId);
        Assert.assertTrue((boolean)outcome);
        ((SwiftBlobStore)Mockito.doReturn((Object)false).when((Object)this.swiftBlobStore)).deleteByPath("prefix/one");
        outcome = this.swiftBlobStore.deleteByParametersId(VALID_TEST_LAYER_NAME, testParametersId);
        ((SwiftBlobStore)Mockito.verify((Object)this.swiftBlobStore, (VerificationMode)Mockito.times((int)2))).deleteByPath("prefix/one");
        ((SwiftBlobStore)Mockito.verify((Object)this.swiftBlobStore, (VerificationMode)Mockito.times((int)2))).deleteByPath("prefix/two");
        ((BlobStoreListenerList)Mockito.verify((Object)this.testListeners, (VerificationMode)Mockito.times((int)1))).sendParametersDeleted(VALID_TEST_LAYER_NAME, testParametersId);
        Assert.assertFalse((boolean)outcome);
    }

    @Test
    @Ignore
    public void deleteWhenUploadExists() throws Exception {
        BlockingQueue taskQueue = (BlockingQueue)Mockito.spy(new LinkedBlockingQueue(1000));
        ThreadPoolExecutor executor = (ThreadPoolExecutor)Mockito.spy((Object)new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)taskQueue, new ThreadPoolExecutor.CallerRunsPolicy()));
        Runnable mockUpload1 = () -> {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        };
        SwiftUploadTask mockUpload2 = (SwiftUploadTask)Mockito.mock(SwiftUploadTask.class);
        SwiftUploadTask mockUpload3 = (SwiftUploadTask)Mockito.mock(SwiftUploadTask.class);
        Mockito.when((Object)mockUpload2.getKey()).thenReturn((Object)"path/tile.png");
        Mockito.when((Object)mockUpload3.getKey()).thenReturn((Object)"anotherpath/tile.png");
        ReflectionTestUtils.setField((Object)this.swiftBlobStore, (String)"taskQueue", (Object)taskQueue);
        ReflectionTestUtils.setField((Object)this.swiftBlobStore, (String)"executor", (Object)executor);
        ((ThreadPoolExecutor)Mockito.verify((Object)executor, (VerificationMode)Mockito.times((int)0))).execute((Runnable)Mockito.any(Runnable.class));
        Assert.assertTrue((boolean)taskQueue.isEmpty());
        executor.execute(mockUpload1);
        executor.execute((Runnable)mockUpload2);
        executor.execute((Runnable)mockUpload3);
        Assert.assertEquals((long)2L, (long)taskQueue.size());
        Assert.assertFalse((boolean)taskQueue.contains(mockUpload1));
        Assert.assertTrue((boolean)taskQueue.contains(mockUpload2));
        Assert.assertTrue((boolean)taskQueue.contains(mockUpload3));
        this.swiftBlobStore.deleteByPath("path");
        ((BlockingQueue)Mockito.verify((Object)taskQueue, (VerificationMode)Mockito.times((int)1))).remove(Mockito.eq((Object)mockUpload2));
        ((BlockingQueue)Mockito.verify((Object)taskQueue, (VerificationMode)Mockito.times((int)0))).remove(Mockito.eq((Object)mockUpload3));
        ((ThreadPoolExecutor)Mockito.verify((Object)executor, (VerificationMode)Mockito.times((int)1))).execute((Runnable)Mockito.any(SwiftDeleteTask.class));
        Assert.assertEquals((long)2L, (long)taskQueue.size());
        Assert.assertFalse((boolean)taskQueue.contains(mockUpload1));
        Assert.assertFalse((boolean)taskQueue.contains(mockUpload2));
        Assert.assertTrue((boolean)taskQueue.contains(mockUpload3));
    }
}

