/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.swift;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;
import org.geowebcache.storage.BlobStoreListener;
import org.geowebcache.storage.BlobStoreListenerList;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileObject;
import org.geowebcache.swift.SwiftTile;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jclouds.io.Payload;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.test.util.ReflectionTestUtils;

public class SwiftTileTest {
    protected SwiftTile swiftTile;
    protected BlobStoreListenerList testListeners;
    private static final String VALID_TEST_LAYER_NAME = "TestLayer";
    private static final Resource testBytes = new ByteArrayResource("1 2 3 4 5 6 test".getBytes());
    private long[] xyz = new long[]{1L, 2L, 3L};
    private Map<String, String> parameters = Collections.singletonMap("testKey", "testValue1");

    @Before
    public void setUp() throws Exception {
        this.createValidSwiftTile();
    }

    protected void addListener() {
        BlobStoreListener swiftListener = (BlobStoreListener)Mockito.mock(BlobStoreListener.class);
        this.testListeners.addListener(swiftListener);
    }

    public void createValidSwiftTile() throws IOException {
        TileObject sampleTileObject = (TileObject)Mockito.spy((Object)TileObject.createCompleteTileObject((String)VALID_TEST_LAYER_NAME, (long[])this.xyz, (String)"EPSG:4326", (String)"image/jpeg", this.parameters, (Resource)testBytes));
        Mockito.when((Object)sampleTileObject.getParametersId()).thenReturn((Object)"1234");
        this.swiftTile = (SwiftTile)Mockito.spy((Object)new SwiftTile(sampleTileObject));
        this.testListeners = (BlobStoreListenerList)Mockito.spy((Object)new BlobStoreListenerList());
    }

    @Test(expected=IOException.class)
    public void testSwiftTileWhenBlobInputStreamThrowsIOException() throws IOException {
        Resource invalidResource = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)invalidResource.getSize()).thenReturn((Object)3L);
        Mockito.when((Object)invalidResource.getInputStream()).thenThrow(IOException.class);
        TileObject sampleTileObject = TileObject.createCompleteTileObject((String)VALID_TEST_LAYER_NAME, (long[])this.xyz, (String)"EPSG:4326", (String)"image/jpeg", this.parameters, (Resource)invalidResource);
        this.swiftTile = new SwiftTile(sampleTileObject);
    }

    @Test
    public void testPutWhenFormatNull() throws IOException {
        TileObject sampleTileObject = (TileObject)Mockito.spy((Object)TileObject.createCompleteTileObject((String)VALID_TEST_LAYER_NAME, (long[])this.xyz, (String)"EPSG:4326", null, this.parameters, (Resource)testBytes));
        try {
            this.swiftTile = new SwiftTile(sampleTileObject);
            Assert.fail((String)"Null check for tile format failed.");
        }
        catch (NullPointerException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"Object Blob Format must not be null."));
        }
        catch (StorageException e) {
            Assert.fail((String)("Should be throwing a NullPointerException.\n" + e));
        }
    }

    @Test
    public void testPutWhenBlobIsNull() throws IOException {
        TileObject sampleTileObject = (TileObject)Mockito.spy((Object)TileObject.createCompleteTileObject((String)VALID_TEST_LAYER_NAME, (long[])this.xyz, (String)"EPSG:4326", null, this.parameters, (Resource)testBytes));
        Mockito.when((Object)sampleTileObject.getBlob()).thenReturn(null);
        try {
            this.swiftTile = new SwiftTile(sampleTileObject);
            Assert.fail((String)"Null check when blob is null failed");
        }
        catch (NullPointerException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"Object Blob must not be null."));
        }
        catch (StorageException e) {
            Assert.fail((String)("Should be throwing a NullPointerException.\n" + e));
        }
    }

    @Test
    public void testGetPayloadMetadataOutputLength() throws IOException {
        Long testOutputLengthValue = 5L;
        ReflectionTestUtils.setField((Object)this.swiftTile, (String)"outputLength", (Object)testOutputLengthValue);
        try (Payload testPayload = this.swiftTile.getPayload();){
            Assert.assertEquals((Object)testOutputLengthValue, (Object)testPayload.getContentMetadata().getContentLength());
        }
    }

    @Test
    public void testGetPayloadMetadataMimeType() throws IOException {
        String testBlobFormat = "image/png";
        ReflectionTestUtils.setField((Object)this.swiftTile, (String)"blobFormat", (Object)testBlobFormat);
        try (Payload testPayload = this.swiftTile.getPayload();){
            Assert.assertEquals((Object)testBlobFormat, (Object)testPayload.getContentMetadata().getContentType());
        }
    }

    @Test
    public void testSetExisted() {
        Long testNewSize = 6L;
        ReflectionTestUtils.setField((Object)this.swiftTile, (String)"existed", (Object)false);
        ReflectionTestUtils.setField((Object)this.swiftTile, (String)"oldSize", (Object)0L);
        this.swiftTile.setExisted(testNewSize.longValue());
        Assert.assertTrue((boolean)((Boolean)ReflectionTestUtils.getField((Object)this.swiftTile, (String)"existed")));
        Assert.assertEquals((Object)testNewSize, (Object)ReflectionTestUtils.getField((Object)this.swiftTile, (String)"oldSize"));
    }

    private void checkListenersNotifications(int sendTileUpdatedTimes, int sendTileStoredTimes) {
        ((BlobStoreListenerList)Mockito.verify((Object)this.testListeners, (VerificationMode)Mockito.times((int)sendTileUpdatedTimes))).sendTileUpdated(Mockito.anyString(), Mockito.anyString(), Mockito.anyString(), (String)Mockito.any(), Mockito.anyLong(), Mockito.anyLong(), Mockito.anyInt(), Mockito.anyLong(), Mockito.anyLong());
        ((BlobStoreListenerList)Mockito.verify((Object)this.testListeners, (VerificationMode)Mockito.times((int)sendTileStoredTimes))).sendTileStored(Mockito.anyString(), Mockito.anyString(), Mockito.anyString(), (String)Mockito.any(), Mockito.anyLong(), Mockito.anyLong(), Mockito.anyInt(), Mockito.anyLong());
    }

    @Test
    public void testNotifyListenersWhenEmptyAndExisted() {
        ReflectionTestUtils.setField((Object)this.swiftTile, (String)"existed", (Object)true);
        this.swiftTile.notifyListeners(this.testListeners);
        this.checkListenersNotifications(0, 0);
    }

    @Test
    public void testNotifyListenersWhenEmptyAndNotExisted() {
        ReflectionTestUtils.setField((Object)this.swiftTile, (String)"existed", (Object)false);
        this.swiftTile.notifyListeners(this.testListeners);
        this.checkListenersNotifications(0, 0);
    }

    @Test
    public void testNotifyListenersWhenNotEmptyAndExisted() {
        ReflectionTestUtils.setField((Object)this.swiftTile, (String)"existed", (Object)true);
        this.addListener();
        this.swiftTile.notifyListeners(this.testListeners);
        this.checkListenersNotifications(1, 0);
    }

    @Test
    public void testNotifyListenersWhenNotEmptyAndNotExisted() {
        ReflectionTestUtils.setField((Object)this.swiftTile, (String)"existed", (Object)false);
        this.addListener();
        this.swiftTile.notifyListeners(this.testListeners);
        this.checkListenersNotifications(0, 1);
    }

    @Test
    public void testTestToString() {
        String testString = this.swiftTile.toString();
        String expectedString = "TestLayer, EPSG:4326, image/jpeg, 1234, xyz=1,2,3";
        Assert.assertEquals((Object)expectedString, (Object)testString);
    }
}

