/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.swift;

import org.geowebcache.swift.SwiftTile;
import org.geowebcache.swift.SwiftTileTest;
import org.geowebcache.swift.SwiftUploadTask;
import org.jclouds.io.Payload;
import org.jclouds.io.payloads.BaseMutableContentMetadata;
import org.jclouds.openstack.swift.v1.domain.SwiftObject;
import org.jclouds.openstack.swift.v1.features.ObjectApi;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class SwiftUploadTaskTest
extends SwiftTileTest {
    private ObjectApi testObjectApi = (ObjectApi)Mockito.mock(ObjectApi.class);
    private String testKey = "TestKey";

    @Test
    public void testRunWithEmptyListeners() {
        SwiftUploadTask swiftUploadTask = new SwiftUploadTask(this.testKey, this.swiftTile, this.testListeners, this.testObjectApi);
        swiftUploadTask.run();
        ((ObjectApi)Mockito.verify((Object)this.testObjectApi, (VerificationMode)Mockito.times((int)0))).getWithoutBody(this.testKey);
        ((SwiftTile)Mockito.verify((Object)this.swiftTile, (VerificationMode)Mockito.times((int)0))).setExisted(Mockito.anyLong());
    }

    @Test
    public void testRunWithNullObject() {
        Mockito.when((Object)this.testObjectApi.getWithoutBody(this.testKey)).thenReturn(null);
        this.addListener();
        SwiftUploadTask swiftUploadTask = new SwiftUploadTask(this.testKey, this.swiftTile, this.testListeners, this.testObjectApi);
        swiftUploadTask.run();
        ((ObjectApi)Mockito.verify((Object)this.testObjectApi, (VerificationMode)Mockito.times((int)1))).getWithoutBody(this.testKey);
        ((SwiftTile)Mockito.verify((Object)this.swiftTile, (VerificationMode)Mockito.times((int)0))).setExisted(Mockito.anyLong());
    }

    @Test
    public void testRunWithValidObject() {
        SwiftObject testSwiftObject = (SwiftObject)Mockito.mock(SwiftObject.class);
        Payload testPayload = (Payload)Mockito.mock(Payload.class);
        BaseMutableContentMetadata metadata = (BaseMutableContentMetadata)Mockito.mock(BaseMutableContentMetadata.class);
        Mockito.when((Object)metadata.getContentLength()).thenReturn((Object)3L);
        Mockito.when((Object)testPayload.getContentMetadata()).thenReturn((Object)metadata);
        Mockito.when((Object)testSwiftObject.getPayload()).thenReturn((Object)testPayload);
        Mockito.when((Object)this.testObjectApi.getWithoutBody(this.testKey)).thenReturn((Object)testSwiftObject);
        this.addListener();
        SwiftUploadTask swiftUploadTask = new SwiftUploadTask(this.testKey, this.swiftTile, this.testListeners, this.testObjectApi);
        swiftUploadTask.run();
        ((ObjectApi)Mockito.verify((Object)this.testObjectApi, (VerificationMode)Mockito.times((int)1))).getWithoutBody(this.testKey);
        ((SwiftTile)Mockito.verify((Object)this.swiftTile, (VerificationMode)Mockito.times((int)1))).setExisted(Mockito.anyLong());
        ((ObjectApi)Mockito.verify((Object)this.testObjectApi)).put((String)Mockito.eq((Object)this.testKey), (Payload)Mockito.any(Payload.class));
        ((SwiftTile)Mockito.verify((Object)this.swiftTile, (VerificationMode)Mockito.times((int)1))).notifyListeners(this.testListeners);
    }
}

