/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.swift;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geowebcache.io.Resource;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.storage.BlobStoreListenerList;
import org.geowebcache.storage.TileObject;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.io.payloads.BaseMutableContentMetadata;
import org.jclouds.io.payloads.ByteArrayPayload;

public class SwiftTile {
    static final Logger log = Logging.getLogger((String)"org.geowebcache.swift.SwiftBlobStore");
    private final String layerName;
    private final String gridSetId;
    private final String blobFormat;
    private final String parametersId;
    private final long x;
    private final long y;
    private final int z;
    private final long outputLength;
    private boolean existed = false;
    private long oldSize = 0L;
    private final byte[] data;

    public SwiftTile(TileObject tile) throws IOException {
        this.layerName = tile.getLayerName();
        this.gridSetId = tile.getGridSetId();
        this.blobFormat = tile.getBlobFormat();
        this.parametersId = tile.getParametersId();
        Resource blob = tile.getBlob();
        Preconditions.checkNotNull((Object)blob, (Object)"Object Blob must not be null.");
        Preconditions.checkNotNull((Object)this.blobFormat, (Object)"Object Blob Format must not be null.");
        long[] xyz = tile.getXYZ();
        this.x = xyz[0];
        this.y = xyz[1];
        this.z = (int)xyz[2];
        try (InputStream stream = blob.getInputStream();){
            this.data = ByteStreams.toByteArray((InputStream)stream);
        }
        this.outputLength = this.data.length;
    }

    private BaseMutableContentMetadata getMetadata() {
        BaseMutableContentMetadata metadata = new BaseMutableContentMetadata();
        metadata.setContentLength(Long.valueOf(this.outputLength));
        try {
            metadata.setContentType(MimeType.createFromFormat((String)this.blobFormat).getMimeType());
        }
        catch (MimeException e) {
            log.warning("Could not determine mimetype for " + this.toString());
        }
        return metadata;
    }

    public Payload getPayload() {
        ByteArrayPayload payload = new ByteArrayPayload(this.data);
        payload.setContentMetadata((MutableContentMetadata)this.getMetadata());
        return payload;
    }

    public void setExisted(long oldSize) {
        this.existed = true;
        this.oldSize = oldSize;
    }

    public void notifyListeners(BlobStoreListenerList listeners) {
        boolean hasListeners;
        boolean bl = hasListeners = !listeners.isEmpty();
        if (hasListeners && this.existed) {
            listeners.sendTileUpdated(this.layerName, this.gridSetId, this.blobFormat, this.parametersId, this.x, this.y, this.z, this.outputLength, this.oldSize);
        } else if (hasListeners) {
            listeners.sendTileStored(this.layerName, this.gridSetId, this.blobFormat, this.parametersId, this.x, this.y, this.z, this.outputLength);
        }
    }

    public String toString() {
        String format = "%s, %s, %s, %s, xyz=%d,%d,%d";
        return String.format(format, this.layerName, this.gridSetId, this.blobFormat, this.parametersId, this.x, this.y, this.z);
    }
}

