/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.swift;

import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geowebcache.storage.BlobStoreListenerList;
import org.geowebcache.swift.SwiftTile;
import org.jclouds.http.HttpResponseException;
import org.jclouds.io.Payload;
import org.jclouds.openstack.swift.v1.domain.SwiftObject;
import org.jclouds.openstack.swift.v1.features.ObjectApi;

class SwiftUploadTask
implements Runnable {
    static final Logger log = Logging.getLogger((String)SwiftUploadTask.class.getName());
    static final String logStr = "%s, %s, %dms";
    private final String key;
    private final SwiftTile tile;
    private final ObjectApi objectApi;
    private final BlobStoreListenerList listeners;

    SwiftUploadTask(String key, SwiftTile tile, BlobStoreListenerList listeners, ObjectApi objectApi) {
        this.key = key;
        this.tile = tile;
        this.objectApi = objectApi;
        this.listeners = listeners;
    }

    private void checkExisted() {
        if (this.listeners.isEmpty()) {
            return;
        }
        LocalDateTime time = LocalDateTime.now();
        long getWithoutBody = System.nanoTime();
        SwiftObject object = this.objectApi.getWithoutBody(this.key);
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format(logStr, time.format(DateTimeFormatter.ISO_DATE_TIME), "HEAD", (System.nanoTime() - getWithoutBody) / 1000000L));
        }
        if (object == null) {
            return;
        }
        try (Payload payload = object.getPayload();){
            this.tile.setExisted(payload.getContentMetadata().getContentLength());
        }
        catch (IOException e) {
            log.warning(e.getMessage());
        }
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public void run() {
        log.fine("Processing " + this.key);
        this.checkExisted();
        try (Payload payload = this.tile.getPayload();){
            String localLogStr = "%s, %s, %dms, %dkB";
            LocalDateTime time = LocalDateTime.now();
            long upload = System.nanoTime();
            this.objectApi.put(this.key, payload);
            if (log.isLoggable(Level.FINE)) {
                log.fine(String.format(localLogStr, time.format(DateTimeFormatter.ISO_DATE_TIME), "PUT", (System.nanoTime() - upload) / 1000000L, payload.getContentMetadata().getContentLength()));
            }
            this.tile.notifyListeners(this.listeners);
        }
        catch (HttpResponseException e) {
            log.warning(String.format("Swift tile upload failed: %s", e.getMessage()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

